/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.web.flow;

import com.yubico.u2f.U2F;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterRequestData;
import org.apereo.cas.adaptors.u2f.U2FRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class U2FStartRegistrationAction
extends AbstractAction {
    private final U2F u2f = new U2F();
    private final String serverAddress;
    private final U2FDeviceRepository u2FDeviceRepository;

    public U2FStartRegistrationAction(String serverAddress, U2FDeviceRepository u2FDeviceRepository) {
        this.serverAddress = serverAddress;
        this.u2FDeviceRepository = u2FDeviceRepository;
    }

    protected Event doExecute(RequestContext requestContext) {
        Principal p = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
        RegisterRequestData registerRequestData = this.u2f.startRegistration(this.serverAddress, (Iterable)this.u2FDeviceRepository.getRegisteredDevices(p.getId()));
        this.u2FDeviceRepository.requestDeviceRegistration(registerRequestData.getRequestId(), p.getId(), registerRequestData.toJson());
        if (!registerRequestData.getRegisterRequests().isEmpty()) {
            RegisterRequest req = (RegisterRequest)registerRequestData.getRegisterRequests().get(0);
            requestContext.getFlowScope().put("u2fReg", (Object)new U2FRegistration(req.getChallenge(), req.getAppId()));
            return this.success();
        }
        return this.error();
    }
}

