/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypass;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.U2FMultifactorProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="u2fAuthenticationMultifactorProviderBypassConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FAuthenticationMultifactorProviderBypassConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"u2fBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass u2fBypassEvaluator() {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        MultifactorAuthenticationProviderBypassProperties props = this.casProperties.getAuthn().getMfa().getU2f().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.u2fRegisteredServiceMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.u2fAuthenticationMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.u2fCredentialMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.u2fHttpRequestMultifactorAuthenticationProviderBypass());
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypass(this.u2fGroovyMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.u2fRestMultifactorAuthenticationProviderBypass());
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"u2fRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass u2fRestMultifactorAuthenticationProviderBypass() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new RestMultifactorAuthenticationProviderBypass(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass u2fGroovyMultifactorAuthenticationProviderBypass() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new GroovyMultifactorAuthenticationProviderBypass(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass u2fHttpRequestMultifactorAuthenticationProviderBypass() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypass(props, u2f.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass u2fCredentialMultifactorAuthenticationProviderBypass() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypass(props, u2f.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass u2fRegisteredServiceMultifactorAuthenticationProviderBypass() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        return new RegisteredServiceMultifactorAuthenticationProviderBypass(u2f.getId());
    }

    @Bean
    @ConditionalOnMissingBean(name={"u2fPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass u2fPrincipalMultifactorAuthenticationProviderBypass() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypass(props, u2f.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass u2fAuthenticationMultifactorAuthenticationProviderBypass() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypass(props, u2f.getId());
    }
}

