/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.web.flow;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apereo.cas.adaptors.u2f.U2FTokenCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class U2FMultifactorWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    public static final String MFA_U2F_EVENT_ID = "mfa-u2f";

    public U2FMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, Optional.of(flowDefinitionRegistry), mfaFlowCustomizers);
    }

    protected void doInitialize() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            Flow flow = this.getFlow((FlowDefinitionRegistry)registry, MFA_U2F_EVENT_ID);
            this.createFlowVariable(flow, "credential", U2FTokenCredential.class);
            flow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
            this.createEndState(flow, "success");
            ActionState initLoginFormState = this.createActionState(flow, "initializeLoginForm", (Action)this.createEvaluateAction("initializeLoginAction"));
            this.createTransitionForState((TransitionableState)initLoginFormState, "success", "accountRegistrationCheck");
            this.setStartState(flow, (TransitionableState)initLoginFormState);
            ActionState checkState = this.createActionState(flow, "accountRegistrationCheck", (Action)this.createEvaluateAction("u2fCheckAccountRegistrationAction"));
            this.createTransitionForState((TransitionableState)checkState, "register", "viewRegistrationU2f");
            this.createTransitionForState((TransitionableState)checkState, "success", "viewLoginForm");
            ActionState saveState = this.createActionState(flow, "saveRegistration", (Action)this.createEvaluateAction("u2fSaveAccountRegistrationAction"));
            this.createTransitionForState((TransitionableState)saveState, "success", "viewLoginForm");
            ActionState realSubmitState = this.createActionState(flow, "realSubmit", (Action)this.createEvaluateAction("u2fAuthenticationWebflowAction"));
            this.createTransitionForState((TransitionableState)realSubmitState, "success", "success");
            this.createTransitionForState((TransitionableState)realSubmitState, "error", "initializeLoginForm");
            SetAction setPrincipalAction = this.createSetAction("viewScope.principal", "conversationScope.authentication.principal");
            ViewState viewRegState = this.createViewState(flow, "viewRegistrationU2f", "casU2fRegistrationView");
            viewRegState.getEntryActionList().addAll(new Action[]{this.createEvaluateAction("u2fStartRegistrationAction"), setPrincipalAction});
            this.createTransitionForState((TransitionableState)viewRegState, "submit", "saveRegistration");
            List loginProperties = CollectionUtils.wrapList((Object[])new String[]{"token"});
            BinderConfiguration loginBinder = this.createStateBinderConfiguration(loginProperties);
            ViewState viewLoginFormState = this.createViewState(flow, "viewLoginForm", "casU2fLoginView", loginBinder);
            this.createStateModelBinding((TransitionableState)viewLoginFormState, "credential", U2FTokenCredential.class);
            viewLoginFormState.getEntryActionList().addAll(new Action[]{this.createEvaluateAction("u2fStartAuthenticationAction"), setPrincipalAction});
            this.createTransitionForState((TransitionableState)viewLoginFormState, "submit", "realSubmit", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
        });
        this.registerMultifactorProviderAuthenticationWebflow(this.getLoginFlow(), MFA_U2F_EVENT_ID, this.casProperties.getAuthn().getMfa().getU2f().getId());
    }
}

