/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.yubico.u2f.U2F;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.u2f.U2FAuthenticationRegistrationRecordCipherExecutor;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FGroovyResourceDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FInMemoryDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FJsonResourceDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FRestResourceDeviceRepository;
import org.apereo.cas.authentication.PseudoPlatformTransactionManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(value="u2fConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"transactionManagerU2f"})
    @Bean
    public PlatformTransactionManager transactionManagerU2f() {
        return new PseudoPlatformTransactionManager();
    }

    @ConditionalOnMissingBean(name={"u2fDeviceRepositoryCleanerScheduler"})
    @Bean
    @Autowired
    @ConditionalOnProperty(prefix="authn.mfa.u2f.cleaner", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public Runnable u2fDeviceRepositoryCleanerScheduler(@Qualifier(value="u2fDeviceRepository") U2FDeviceRepository storage) {
        return new U2FDeviceRepositoryCleanerScheduler(storage);
    }

    @ConditionalOnMissingBean(name={"u2fService"})
    @Bean
    public U2F u2fService() {
        return new U2F();
    }

    @ConditionalOnMissingBean(name={"u2fDeviceRepository"})
    @Bean
    @RefreshScope
    @Autowired
    public U2FDeviceRepository u2fDeviceRepository(@Qualifier(value="u2fRegistrationRecordCipherExecutor") CipherExecutor u2fRegistrationRecordCipherExecutor) {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getExpireRegistrations(), u2f.getExpireRegistrationsTimeUnit()).build(key -> "");
        if (u2f.getJson().getLocation() != null) {
            return new U2FJsonResourceDeviceRepository(requestStorage, u2f.getJson().getLocation(), u2f.getExpireDevices(), u2f.getExpireDevicesTimeUnit(), u2fRegistrationRecordCipherExecutor);
        }
        if (u2f.getGroovy().getLocation() != null) {
            return new U2FGroovyResourceDeviceRepository(requestStorage, u2f.getGroovy().getLocation(), u2f.getExpireDevices(), u2f.getExpireDevicesTimeUnit(), u2fRegistrationRecordCipherExecutor);
        }
        if (StringUtils.isNotBlank((CharSequence)u2f.getRest().getUrl())) {
            return new U2FRestResourceDeviceRepository(requestStorage, u2f.getExpireDevices(), u2f.getExpireDevicesTimeUnit(), u2f.getRest(), u2fRegistrationRecordCipherExecutor);
        }
        LoadingCache userStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getExpireDevices(), u2f.getExpireDevicesTimeUnit()).build(key -> new ArrayList(0));
        return new U2FInMemoryDeviceRepository(userStorage, requestStorage, u2fRegistrationRecordCipherExecutor);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fRegistrationRecordCipherExecutor"})
    public CipherExecutor u2fRegistrationRecordCipherExecutor() {
        EncryptionJwtSigningJwtCryptographyProperties crypto = this.casProperties.getAuthn().getMfa().getU2f().getCrypto();
        if (crypto.isEnabled()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, U2FAuthenticationRegistrationRecordCipherExecutor.class);
        }
        LOGGER.info("U2F registration record encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of U2F registration records for MFA");
        return CipherExecutor.noOp();
    }

    public static class U2FDeviceRepositoryCleanerScheduler
    implements Runnable {
        private final U2FDeviceRepository repository;

        @Override
        @Scheduled(initialDelayString="${cas.authn.mfa.u2f.cleaner.schedule.start-delay:PT20S}", fixedDelayString="${cas.authn.mfa.u2f.cleaner.schedule.repeat-interval:PT5M}")
        public void run() {
            LOGGER.debug("Starting to clean expired U2F devices from repository");
            this.repository.clean();
        }

        @Generated
        public U2FDeviceRepositoryCleanerScheduler(U2FDeviceRepository repository) {
            this.repository = repository;
        }
    }
}

