/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import com.yubico.u2f.U2F;
import org.apereo.cas.adaptors.u2f.U2FAuthenticationHandler;
import org.apereo.cas.adaptors.u2f.U2FMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.u2f.U2FTokenCredential;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="u2fAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FAuthenticationEventExecutionPlanConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="u2fService")
    private ObjectProvider<U2F> u2fService;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="u2fDeviceRepository")
    private ObjectProvider<U2FDeviceRepository> u2fDeviceRepository;
    @Autowired
    @Qualifier(value="u2fBypassEvaluator")
    private ObjectProvider<MultifactorAuthenticationProviderBypassEvaluator> u2fBypassEvaluator;
    @Autowired
    @Qualifier(value="failureModeEvaluator")
    private ObjectProvider<MultifactorAuthenticationFailureModeEvaluator> failureModeEvaluator;

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fAuthenticationMetaDataPopulator"})
    public AuthenticationMetaDataPopulator u2fAuthenticationMetaDataPopulator() {
        String authenticationContextAttribute = this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
        return new AuthenticationContextAttributeMetaDataPopulator(authenticationContextAttribute, this.u2fAuthenticationHandler(), this.u2fMultifactorAuthenticationProvider().getId());
    }

    @ConditionalOnMissingBean(name={"u2fPrincipalFactory"})
    @Bean
    public PrincipalFactory u2fPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"u2fAuthenticationHandler"})
    @Bean
    @RefreshScope
    public AuthenticationHandler u2fAuthenticationHandler() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        return new U2FAuthenticationHandler(u2f.getName(), (ServicesManager)this.servicesManager.getObject(), this.u2fPrincipalFactory(), (U2FDeviceRepository)this.u2fDeviceRepository.getObject(), (U2F)this.u2fService.getObject(), Integer.valueOf(u2f.getOrder()));
    }

    @ConditionalOnMissingBean(name={"u2fMultifactorAuthenticationProvider"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProvider u2fMultifactorAuthenticationProvider() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        U2FMultifactorAuthenticationProvider p = new U2FMultifactorAuthenticationProvider();
        p.setBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)this.u2fBypassEvaluator.getObject());
        p.setFailureMode(u2f.getFailureMode());
        p.setFailureModeEvaluator((MultifactorAuthenticationFailureModeEvaluator)this.failureModeEvaluator.getObject());
        p.setOrder(u2f.getRank());
        p.setId(u2f.getId());
        return p;
    }

    @ConditionalOnMissingBean(name={"u2fAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer u2fAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            plan.registerAuthenticationHandler(this.u2fAuthenticationHandler());
            plan.registerAuthenticationMetadataPopulator(this.u2fAuthenticationMetaDataPopulator());
            plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{U2FTokenCredential.class}));
        };
    }
}

