/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.yubico.u2f.U2F;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.web.U2FRegisteredDevicesEndpoint;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAccountCheckRegistrationAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAccountSaveRegistrationAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAuthenticationWebflowAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.u2f.web.flow.U2FMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.adaptors.u2f.web.flow.U2FMultifactorWebflowConfigurer;
import org.apereo.cas.adaptors.u2f.web.flow.U2FStartAuthenticationAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FStartRegistrationAction;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.config.ConditionalOnMultifactorTrustedDevicesEnabled;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="u2FWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FWebflowConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="u2fDeviceRepository")
    private ObjectProvider<U2FDeviceRepository> u2fDeviceRepository;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="u2fService")
    private ObjectProvider<U2F> u2fService;
    @Autowired
    @Qualifier(value="flowBuilder")
    private ObjectProvider<FlowBuilder> flowBuilder;
    @Autowired
    @Qualifier(value="casWebflowConfigurationContext")
    private ObjectProvider<CasWebflowEventResolutionConfigurationContext> casWebflowConfigurationContext;

    @Bean
    @ConditionalOnMissingBean(name={"u2fFlowRegistry"})
    public FlowDefinitionRegistry u2fFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, (FlowBuilderServices)this.flowBuilderServices.getObject());
        builder.addFlowBuilder((FlowBuilder)this.flowBuilder.getObject(), "mfa-u2f");
        return builder.build();
    }

    @ConditionalOnMissingBean(name={"u2fAuthenticationWebflowAction"})
    @Bean
    @RefreshScope
    public Action u2fAuthenticationWebflowAction() {
        return new U2FAuthenticationWebflowAction(this.u2fAuthenticationWebflowEventResolver());
    }

    @ConditionalOnMissingBean(name={"u2fMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer u2fMultifactorWebflowConfigurer() {
        U2FMultifactorWebflowConfigurer cfg = new U2FMultifactorWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.u2fFlowRegistry(), this.applicationContext, this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)this.applicationContext));
        cfg.setOrder(100);
        return cfg;
    }

    @ConditionalOnMissingBean(name={"u2fStartAuthenticationAction"})
    @Bean
    @RefreshScope
    public Action u2fStartAuthenticationAction() {
        return new U2FStartAuthenticationAction((U2F)this.u2fService.getObject(), this.casProperties.getServer().getName(), (U2FDeviceRepository)this.u2fDeviceRepository.getObject());
    }

    @ConditionalOnMissingBean(name={"u2fStartRegistrationAction"})
    @Bean
    @RefreshScope
    public Action u2fStartRegistrationAction() {
        return new U2FStartRegistrationAction((U2F)this.u2fService.getObject(), this.casProperties.getServer().getName(), (U2FDeviceRepository)this.u2fDeviceRepository.getObject());
    }

    @ConditionalOnMissingBean(name={"u2fCheckAccountRegistrationAction"})
    @Bean
    @RefreshScope
    public Action u2fCheckAccountRegistrationAction() {
        return new U2FAccountCheckRegistrationAction((U2FDeviceRepository)this.u2fDeviceRepository.getObject());
    }

    @ConditionalOnMissingBean(name={"u2fSaveAccountRegistrationAction"})
    @Bean
    @RefreshScope
    public Action u2fSaveAccountRegistrationAction() {
        return new U2FAccountSaveRegistrationAction((U2F)this.u2fService.getObject(), (U2FDeviceRepository)this.u2fDeviceRepository.getObject());
    }

    @ConditionalOnMissingBean(name={"u2fAuthenticationWebflowEventResolver"})
    @Bean
    @RefreshScope
    public CasWebflowEventResolver u2fAuthenticationWebflowEventResolver() {
        return new U2FAuthenticationWebflowEventResolver((CasWebflowEventResolutionConfigurationContext)this.casWebflowConfigurationContext.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"u2fCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer u2fCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.u2fMultifactorWebflowConfigurer());
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public U2FRegisteredDevicesEndpoint u2fRegisteredDevicesEndpoint() {
        return new U2FRegisteredDevicesEndpoint(this.casProperties, (U2FDeviceRepository)this.u2fDeviceRepository.getObject());
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnMultifactorTrustedDevicesEnabled(prefix="cas.authn.mfa.u2f")
    @Configuration(value="u2fMultifactorTrustConfiguration")
    public class U2FMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"u2fMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer", "u2fMultifactorWebflowConfigurer"})
        public CasWebflowConfigurer u2fMultifactorTrustWebflowConfigurer() {
            U2FMultifactorTrustedDeviceWebflowConfigurer cfg = new U2FMultifactorTrustedDeviceWebflowConfigurer((FlowBuilderServices)U2FWebflowConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)U2FWebflowConfiguration.this.loginFlowDefinitionRegistry.getObject(), U2FWebflowConfiguration.this.u2fFlowRegistry(), U2FWebflowConfiguration.this.applicationContext, U2FWebflowConfiguration.this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)U2FWebflowConfiguration.this.applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @Bean
        public CasWebflowExecutionPlanConfigurer u2fMultifactorTrustCasWebflowExecutionPlanConfigurer() {
            return plan -> plan.registerWebflowConfigurer(this.u2fMultifactorTrustWebflowConfigurer());
        }
    }
}

