/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="u2fAuthenticationMultifactorProviderBypassConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FAuthenticationMultifactorProviderBypassConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"u2fBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator u2fBypassEvaluator() {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        MultifactorAuthenticationProviderBypassProperties props = this.casProperties.getAuthn().getMfa().getU2f().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fPrincipalMultifactorAuthenticationProviderBypass());
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fRegisteredServiceMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator());
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fAuthenticationMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fCredentialMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fHttpRequestMultifactorAuthenticationProviderBypass());
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fGroovyMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.u2fRestMultifactorAuthenticationProviderBypass());
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"u2fRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator u2fRestMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new RestMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator u2fGroovyMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator u2fHttpRequestMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(u2f.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator u2fCredentialMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator u2fRegisteredServiceMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(u2f.getId());
    }

    @Bean
    @ConditionalOnMissingBean(name={"u2fPrincipalMultifactorAuthenticationProviderBypass"})
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator u2fPrincipalMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"u2fAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator u2fAuthenticationMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }
}

