/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.yubico.u2f.U2F;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.u2f.U2FAuthenticationRegistrationRecordCipherExecutor;
import org.apereo.cas.adaptors.u2f.U2FDeviceRepositoryCleanerScheduler;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FGroovyResourceDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FInMemoryDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FJsonResourceDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FRestResourceDeviceRepository;
import org.apereo.cas.authentication.PseudoPlatformTransactionManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.common.Cleanable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.transaction.PlatformTransactionManager;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.U2F})
@AutoConfiguration
public class U2FConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FConfiguration.class);

    @Configuration(value="U2FCleanerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FCleanerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Cleanable u2fDeviceRepositoryCleanerScheduler(ConfigurableApplicationContext applicationContext, @Qualifier(value="u2fDeviceRepository") U2FDeviceRepository storage) {
            return (Cleanable)BeanSupplier.of(Cleanable.class).when(BeanCondition.on((String)"cas.authn.mfa.u2f.cleaner.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new U2FDeviceRepositoryCleanerScheduler(storage)).otherwiseProxy().get();
        }
    }

    @Configuration(value="U2FTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FTransactionConfiguration {
        @ConditionalOnMissingBean(name={"transactionManagerU2f"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerU2f() {
            return new PseudoPlatformTransactionManager();
        }
    }

    @Configuration(value="U2FCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FCryptoConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"u2fRegistrationRecordCipherExecutor"})
        public CipherExecutor u2fRegistrationRecordCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getMfa().getU2f().getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, U2FAuthenticationRegistrationRecordCipherExecutor.class);
            }
            LOGGER.info("U2F registration record encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of U2F registration records for MFA");
            return CipherExecutor.noOp();
        }
    }

    @Configuration(value="U2FRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"u2fService"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public U2F u2fService() {
            return new U2F();
        }

        @ConditionalOnMissingBean(name={"u2fDeviceRepository"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public U2FDeviceRepository u2fDeviceRepository(@Qualifier(value="u2fRegistrationRecordCipherExecutor") CipherExecutor u2fRegistrationRecordCipherExecutor, CasConfigurationProperties casProperties) {
            U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
            LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getCore().getExpireRegistrations(), u2f.getCore().getExpireRegistrationsTimeUnit()).build(key -> "");
            if (u2f.getJson().getLocation() != null) {
                return new U2FJsonResourceDeviceRepository(requestStorage, casProperties, u2fRegistrationRecordCipherExecutor);
            }
            if (u2f.getGroovy().getLocation() != null) {
                return new U2FGroovyResourceDeviceRepository(requestStorage, casProperties, u2fRegistrationRecordCipherExecutor);
            }
            if (StringUtils.isNotBlank((CharSequence)u2f.getRest().getUrl())) {
                return new U2FRestResourceDeviceRepository(requestStorage, casProperties, u2fRegistrationRecordCipherExecutor);
            }
            LoadingCache userStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getCore().getExpireDevices(), u2f.getCore().getExpireDevicesTimeUnit()).build(key -> new ArrayList(0));
            return new U2FInMemoryDeviceRepository(userStorage, requestStorage, u2fRegistrationRecordCipherExecutor, casProperties);
        }
    }
}

