/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.U2F})
@AutoConfiguration
public class U2FAuthenticationMultifactorProviderBypassConfiguration {
    @ConditionalOnMissingBean(name={"u2fBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator u2fBypassEvaluator(CasConfigurationProperties casProperties, @Qualifier(value="u2fPrincipalMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator u2fPrincipalMultifactorAuthenticationProviderBypass, @Qualifier(value="u2fRegisteredServiceMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator u2fRegisteredServiceMultifactorAuthenticationProviderBypass, @Qualifier(value="u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator, @Qualifier(value="u2fAuthenticationMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator u2fAuthenticationMultifactorAuthenticationProviderBypass, @Qualifier(value="u2fCredentialMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator u2fCredentialMultifactorAuthenticationProviderBypass, @Qualifier(value="u2fHttpRequestMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator u2fHttpRequestMultifactorAuthenticationProviderBypass, @Qualifier(value="u2fGroovyMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator u2fGroovyMultifactorAuthenticationProviderBypass, @Qualifier(value="u2fRestMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator u2fRestMultifactorAuthenticationProviderBypass) {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        MultifactorAuthenticationProviderBypassProperties props = casProperties.getAuthn().getMfa().getU2f().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fPrincipalMultifactorAuthenticationProviderBypass);
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fRegisteredServiceMultifactorAuthenticationProviderBypass);
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator);
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fAuthenticationMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fCredentialMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fHttpRequestMultifactorAuthenticationProviderBypass);
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fGroovyMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(u2fRestMultifactorAuthenticationProviderBypass);
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"u2fRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator u2fRestMultifactorAuthenticationProviderBypass(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new RestMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator u2fGroovyMultifactorAuthenticationProviderBypass(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator u2fHttpRequestMultifactorAuthenticationProviderBypass(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @ConditionalOnMissingBean(name={"u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator u2fRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(u2f.getId());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"u2fCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator u2fCredentialMultifactorAuthenticationProviderBypass(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"u2fRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator u2fRegisteredServiceMultifactorAuthenticationProviderBypass(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(u2f.getId());
    }

    @Bean
    @ConditionalOnMissingBean(name={"u2fPrincipalMultifactorAuthenticationProviderBypass"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator u2fPrincipalMultifactorAuthenticationProviderBypass(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"u2fAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator u2fAuthenticationMultifactorAuthenticationProviderBypass(CasConfigurationProperties casProperties) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = u2f.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, u2f.getId());
    }
}

