/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.LegacyValidateController;
import org.apereo.cas.web.ProxyController;
import org.apereo.cas.web.ProxyValidateController;
import org.apereo.cas.web.ServiceValidateController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.v3.V3ProxyValidateController;
import org.apereo.cas.web.v3.V3ServiceValidateController;
import org.apereo.cas.web.view.Cas10ResponseView;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.apereo.cas.web.view.attributes.DefaultCas30ProtocolAttributesRenderer;
import org.apereo.cas.web.view.attributes.InlinedCas30ProtocolAttributesRenderer;
import org.apereo.cas.web.view.json.Cas30JsonResponseView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="casValidationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasValidationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasValidationConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ProtocolAttributeEncoder protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3SuccessView")
    private View cas3SuccessView;
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas20ProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas20ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas10ProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas10ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="cas2ServiceFailureView")
    private View cas2ServiceFailureView;
    @Autowired
    @Qualifier(value="cas2SuccessView")
    private View cas2SuccessView;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers;
    @Autowired
    @Qualifier(value="cas3ServiceFailureView")
    private View cas3ServiceFailureView;
    @Autowired
    @Qualifier(value="cas2ProxySuccessView")
    private ObjectProvider<View> cas2ProxySuccessView;
    @Autowired
    @Qualifier(value="cas2ProxyFailureView")
    private ObjectProvider<View> cas2ProxyFailureView;
    @Autowired
    @Qualifier(value="proxy10Handler")
    private ObjectProvider<ProxyHandler> proxy10Handler;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ObjectProvider<ProxyHandler> proxy20Handler;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;

    @Bean
    @ConditionalOnMissingBean(name={"cas1ServiceSuccessView"})
    public View cas1ServiceSuccessView() {
        return new Cas10ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.authenticationAttributeReleasePolicy);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas1ServiceFailureView"})
    public View cas1ServiceFailureView() {
        return new Cas10ResponseView(false, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.authenticationAttributeReleasePolicy);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas2ServiceSuccessView"})
    public View cas2ServiceSuccessView() {
        return new Cas20ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.cas2SuccessView, this.authenticationAttributeReleasePolicy, (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ServiceJsonView"})
    public View cas3ServiceJsonView() {
        String authenticationContextAttribute = this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute();
        boolean isReleaseProtocolAttributes = this.casProperties.getAuthn().isReleaseProtocolAttributes();
        return new Cas30JsonResponseView(true, this.protocolAttributeEncoder, this.servicesManager, authenticationContextAttribute, isReleaseProtocolAttributes, this.authenticationAttributeReleasePolicy, (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getIfAvailable(), this.cas3ProtocolAttributesRenderer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ProtocolAttributesRenderer"})
    public CasProtocolAttributesRenderer cas3ProtocolAttributesRenderer() {
        switch (this.casProperties.getView().getCas3().getAttributeRendererType()) {
            case INLINE: {
                return new InlinedCas30ProtocolAttributesRenderer();
            }
        }
        return new DefaultCas30ProtocolAttributesRenderer();
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ServiceSuccessView"})
    public View cas3ServiceSuccessView() {
        String authenticationContextAttribute = this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute();
        boolean isReleaseProtocolAttributes = this.casProperties.getAuthn().isReleaseProtocolAttributes();
        return new Cas30ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, authenticationContextAttribute, this.cas3SuccessView, isReleaseProtocolAttributes, this.authenticationAttributeReleasePolicy, (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getIfAvailable(), this.cas3ProtocolAttributesRenderer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"proxyController"})
    @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
    public ProxyController proxyController() {
        return new ProxyController((View)this.cas2ProxySuccessView.getIfAvailable(), (View)this.cas2ProxyFailureView.getIfAvailable(), this.centralAuthenticationService, this.webApplicationServiceFactory, this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"v3ServiceValidateController"})
    public V3ServiceValidateController v3ServiceValidateController() {
        return new V3ServiceValidateController(this.cas20WithoutProxyProtocolValidationSpecification, (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.servicesManager, this.centralAuthenticationService, (ProxyHandler)this.proxy20Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
    }

    @Bean
    @ConditionalOnMissingBean(name={"v3ProxyValidateController"})
    @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
    public V3ProxyValidateController v3ProxyValidateController() {
        return new V3ProxyValidateController(this.cas20ProtocolValidationSpecification, (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.servicesManager, this.centralAuthenticationService, (ProxyHandler)this.proxy20Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
    }

    @Bean
    @ConditionalOnMissingBean(name={"proxyValidateController"})
    public ProxyValidateController proxyValidateController() {
        if (this.casProperties.getView().getCas2().isV3ForwardCompatible()) {
            return new ProxyValidateController(this.cas20ProtocolValidationSpecification, (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.servicesManager, this.centralAuthenticationService, (ProxyHandler)this.proxy20Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
        }
        return new ProxyValidateController(this.cas20ProtocolValidationSpecification, (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.servicesManager, this.centralAuthenticationService, (ProxyHandler)this.proxy20Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas2ServiceSuccessView(), this.cas2ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
    }

    @Bean
    @ConditionalOnMissingBean(name={"legacyValidateController"})
    public LegacyValidateController legacyValidateController() {
        return new LegacyValidateController(this.cas10ProtocolValidationSpecification, (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.servicesManager, this.centralAuthenticationService, (ProxyHandler)this.proxy10Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas1ServiceSuccessView(), this.cas1ServiceFailureView(), this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceValidateController"})
    public ServiceValidateController serviceValidateController() {
        if (this.casProperties.getView().getCas2().isV3ForwardCompatible()) {
            return new ServiceValidateController(this.cas20WithoutProxyProtocolValidationSpecification, (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.servicesManager, this.centralAuthenticationService, (ProxyHandler)this.proxy20Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
        }
        return new ServiceValidateController(this.cas20WithoutProxyProtocolValidationSpecification, (AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.servicesManager, this.centralAuthenticationService, (ProxyHandler)this.proxy20Handler.getIfAvailable(), (ArgumentExtractor)this.argumentExtractor.getIfAvailable(), this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas2ServiceSuccessView(), this.cas2ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
    }
}

