/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.view.CasProtocolView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.thymeleaf.spring4.SpringTemplateEngine;

@Configuration(value="casProtocolViewsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasProtocolViewsConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasProtocolViewsConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SpringTemplateEngine springTemplateEngine;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ThymeleafProperties thymeleafProperties;

    @Configuration(value="OpenIdProtocolViews")
    public class OpenIdProtocolViews {
        @Bean
        @Scope(value="prototype")
        public CasProtocolView casOpenIdServiceFailureView() {
            return new CasProtocolView("protocol/openid/casOpenIdServiceFailureView", CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }

        @Bean
        @Scope(value="prototype")
        public CasProtocolView casOpenIdServiceSuccessView() {
            return new CasProtocolView("protocol/openid/casOpenIdServiceSuccessView", CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }

        @Bean
        @Scope(value="prototype")
        public CasProtocolView casOpenIdAssociationSuccessView() {
            return new CasProtocolView("protocol/openid/casOpenIdAssociationSuccessView", CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }

        @Bean
        @Scope(value="prototype")
        public CasProtocolView openIdProviderView() {
            return new CasProtocolView("protocol/openid/user", CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }
    }

    @Configuration(value="OidcProtocolViews")
    public class OidcProtocolViews {
        @Bean
        @Scope(value="prototype")
        public CasProtocolView oidcConfirmView() {
            return new CasProtocolView("protocol/oidc/confirm", CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }
    }

    @Configuration(value="OAuthProtocolViews")
    public class OAuthProtocolViews {
        @Bean
        @Scope(value="prototype")
        public CasProtocolView oauthConfirmView() {
            return new CasProtocolView("protocol/oauth/confirm", CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }
    }

    @Configuration(value="CasProtocolViews")
    public class CasProtocolViews {
        @Bean
        @Scope(value="prototype")
        public CasProtocolView cas2SuccessView() {
            return new CasProtocolView(CasProtocolViewsConfiguration.this.casProperties.getView().getCas2().getSuccess(), CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties, "application/xml");
        }

        @Bean
        @Scope(value="prototype")
        public CasProtocolView cas2ServiceFailureView() {
            return new CasProtocolView(CasProtocolViewsConfiguration.this.casProperties.getView().getCas2().getFailure(), CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }

        @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
        @Bean
        @Scope(value="prototype")
        public CasProtocolView cas2ProxyFailureView() {
            return new CasProtocolView(CasProtocolViewsConfiguration.this.casProperties.getView().getCas2().getProxy().getFailure(), CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties, "application/xml");
        }

        @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
        @Bean
        @Scope(value="prototype")
        public CasProtocolView cas2ProxySuccessView() {
            return new CasProtocolView(CasProtocolViewsConfiguration.this.casProperties.getView().getCas2().getProxy().getSuccess(), CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties, "application/xml");
        }

        @Bean
        @Scope(value="prototype")
        public CasProtocolView cas3SuccessView() {
            return new CasProtocolView(CasProtocolViewsConfiguration.this.casProperties.getView().getCas3().getSuccess(), CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }

        @Bean
        @Scope(value="prototype")
        public CasProtocolView cas3ServiceFailureView() {
            return new CasProtocolView(CasProtocolViewsConfiguration.this.casProperties.getView().getCas3().getFailure(), CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties, "application/xml");
        }

        @Bean
        @Scope(value="prototype")
        public CasProtocolView casPostResponseView() {
            return new CasProtocolView("protocol/casPostResponseView", CasProtocolViewsConfiguration.this.applicationContext, CasProtocolViewsConfiguration.this.springTemplateEngine, CasProtocolViewsConfiguration.this.thymeleafProperties);
        }
    }
}

