/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.validation.ChainingCasProtocolValidationSpecification;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.ServiceValidationViewFactory;
import org.apereo.cas.web.ServiceValidationViewFactoryConfigurer;
import org.apereo.cas.web.ServiceValidationViewTypes;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.v1.LegacyValidateController;
import org.apereo.cas.web.v2.ProxyController;
import org.apereo.cas.web.v2.ProxyValidateController;
import org.apereo.cas.web.v2.ServiceValidateController;
import org.apereo.cas.web.v3.V3ProxyValidateController;
import org.apereo.cas.web.v3.V3ServiceValidateController;
import org.apereo.cas.web.view.Cas10ResponseView;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.apereo.cas.web.view.attributes.AttributeValuesPerLineProtocolAttributesRenderer;
import org.apereo.cas.web.view.attributes.DefaultCas30ProtocolAttributesRenderer;
import org.apereo.cas.web.view.attributes.InlinedCas30ProtocolAttributesRenderer;
import org.apereo.cas.web.view.attributes.NoOpProtocolAttributesRenderer;
import org.apereo.cas.web.view.json.Cas30JsonResponseView;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.View;

@Configuration(value="casValidationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasValidationConfiguration {
    @Autowired
    @Qualifier(value="casProtocolViewFactory")
    private ObjectProvider<CasProtocolViewFactory> casProtocolViewFactory;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ObjectProvider<ProtocolAttributeEncoder> protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private ObjectProvider<AuthenticationAttributeReleasePolicy> authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ObjectProvider<CasProtocolValidationSpecification> cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas20ProtocolValidationSpecification")
    private ObjectProvider<CasProtocolValidationSpecification> cas20ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas10ProtocolValidationSpecification")
    private ObjectProvider<CasProtocolValidationSpecification> cas10ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private ObjectProvider<ServiceTicketValidationAuthorizersExecutionPlan> serviceValidationAuthorizers;
    @Autowired
    @Qualifier(value="proxy10Handler")
    private ObjectProvider<ProxyHandler> proxy10Handler;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ObjectProvider<ProxyHandler> proxy20Handler;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="requestedContextValidator")
    private ObjectProvider<RequestedAuthenticationContextValidator> requestedContextValidator;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;

    @Bean
    @ConditionalOnMissingBean(name={"cas1ServiceSuccessView"})
    @RefreshScope
    public View cas1ServiceSuccessView() {
        return new Cas10ResponseView(true, (ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), this.cas1ProtocolAttributesRenderer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas1ServiceFailureView"})
    @RefreshScope
    public View cas1ServiceFailureView() {
        return new Cas10ResponseView(false, (ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), this.cas1ProtocolAttributesRenderer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas2ServiceSuccessView"})
    @RefreshScope
    public View cas2ServiceSuccessView() {
        return new Cas20ResponseView(true, (ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject(), this.cas2SuccessView(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), NoOpProtocolAttributesRenderer.INSTANCE);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"cas3ServiceJsonView"})
    public View cas3ServiceJsonView() {
        return new Cas30JsonResponseView(true, (ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), this.cas3ProtocolAttributesRenderer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ProtocolAttributesRenderer"})
    @RefreshScope
    public CasProtocolAttributesRenderer cas3ProtocolAttributesRenderer() {
        switch (this.casProperties.getView().getCas3().getAttributeRendererType()) {
            case INLINE: {
                return new InlinedCas30ProtocolAttributesRenderer();
            }
        }
        return new DefaultCas30ProtocolAttributesRenderer();
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas1ProtocolAttributesRenderer"})
    @RefreshScope
    public CasProtocolAttributesRenderer cas1ProtocolAttributesRenderer() {
        switch (this.casProperties.getView().getCas1().getAttributeRendererType()) {
            case VALUES_PER_LINE: {
                return new AttributeValuesPerLineProtocolAttributesRenderer();
            }
        }
        return NoOpProtocolAttributesRenderer.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ServiceSuccessView"})
    @RefreshScope
    public View cas3ServiceSuccessView() {
        return new Cas30ResponseView(true, (ProtocolAttributeEncoder)this.protocolAttributeEncoder.getObject(), (ServicesManager)this.servicesManager.getObject(), this.cas3SuccessView(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), this.cas3ProtocolAttributesRenderer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"proxyController"})
    @ConditionalOnProperty(prefix="cas.sso", name={"proxy-authn-enabled"}, havingValue="true", matchIfMissing=true)
    public ProxyController proxyController() {
        return new ProxyController(this.cas2ProxySuccessView(), this.cas2ProxyFailureView(), (CentralAuthenticationService)this.centralAuthenticationService.getObject(), this.webApplicationServiceFactory, (ApplicationContext)this.applicationContext);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"serviceValidationViewFactory"})
    public ServiceValidationViewFactory serviceValidationViewFactory() {
        ServiceValidationViewFactory viewFactory = new ServiceValidationViewFactory();
        Map configurers = this.applicationContext.getBeansOfType(ServiceValidationViewFactoryConfigurer.class, false, true);
        ArrayList results = new ArrayList(configurers.values());
        AnnotationAwareOrderComparator.sort(results);
        results.forEach(cfg -> cfg.configureViewFactory(viewFactory));
        return viewFactory;
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"casServiceValidationViewFactoryConfigurer"})
    public ServiceValidationViewFactoryConfigurer casServiceValidationViewFactoryConfigurer() {
        return viewFactory -> {
            viewFactory.registerView(ServiceValidationViewTypes.JSON, this.cas3ServiceJsonView());
            View successViewV3 = this.cas3ServiceSuccessView();
            View failureViewV3 = this.cas3ServiceFailureView();
            viewFactory.registerView(V3ServiceValidateController.class, Pair.of((Object)successViewV3, (Object)failureViewV3));
            viewFactory.registerView(V3ProxyValidateController.class, Pair.of((Object)successViewV3, (Object)failureViewV3));
            if (this.casProperties.getView().getCas2().isV3ForwardCompatible()) {
                viewFactory.registerView(ProxyValidateController.class, Pair.of((Object)successViewV3, (Object)failureViewV3));
                viewFactory.registerView(ServiceValidateController.class, Pair.of((Object)successViewV3, (Object)failureViewV3));
            } else {
                View successViewV2 = this.cas2ServiceSuccessView();
                View failureViewV2 = this.cas2ServiceFailureView();
                viewFactory.registerView(ProxyValidateController.class, Pair.of((Object)successViewV2, (Object)failureViewV2));
                viewFactory.registerView(ServiceValidateController.class, Pair.of((Object)successViewV2, (Object)failureViewV2));
            }
            viewFactory.registerView(LegacyValidateController.class, Pair.of((Object)this.cas1ServiceSuccessView(), (Object)this.cas1ServiceFailureView()));
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"v3ServiceValidateControllerValidationSpecification"})
    public CasProtocolValidationSpecification v3ServiceValidateControllerValidationSpecification() {
        ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
        validationChain.addSpecification((CasProtocolValidationSpecification)this.cas20WithoutProxyProtocolValidationSpecification.getObject());
        return validationChain;
    }

    @Bean
    @ConditionalOnMissingBean(name={"v3ServiceValidateController"})
    public V3ServiceValidateController v3ServiceValidateController() {
        ServiceValidateConfigurationContext context = this.getServiceValidateConfigurationContextBuilder().validationSpecifications(CollectionUtils.wrapSet((Object)this.v3ServiceValidateControllerValidationSpecification())).proxyHandler((ProxyHandler)this.proxy20Handler.getObject()).build();
        return new V3ServiceValidateController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"v3ProxyValidateControllerValidationSpecification"})
    @ConditionalOnProperty(prefix="cas.sso", name={"proxy-authn-enabled"}, havingValue="true", matchIfMissing=true)
    public CasProtocolValidationSpecification v3ProxyValidateControllerValidationSpecification() {
        ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
        validationChain.addSpecification((CasProtocolValidationSpecification)this.cas20ProtocolValidationSpecification.getObject());
        return validationChain;
    }

    @Bean
    @ConditionalOnMissingBean(name={"v3ProxyValidateController"})
    @ConditionalOnProperty(prefix="cas.sso", name={"proxy-authn-enabled"}, havingValue="true", matchIfMissing=true)
    public V3ProxyValidateController v3ProxyValidateController() {
        ServiceValidateConfigurationContext context = this.getServiceValidateConfigurationContextBuilder().validationSpecifications(CollectionUtils.wrapSet((Object)this.v3ProxyValidateControllerValidationSpecification())).proxyHandler((ProxyHandler)this.proxy20Handler.getObject()).build();
        return new V3ProxyValidateController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"proxyValidateControllerValidationSpecification"})
    public CasProtocolValidationSpecification proxyValidateControllerValidationSpecification() {
        ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
        validationChain.addSpecification((CasProtocolValidationSpecification)this.cas20ProtocolValidationSpecification.getObject());
        return validationChain;
    }

    @Bean
    @ConditionalOnMissingBean(name={"proxyValidateController"})
    public ProxyValidateController proxyValidateController() {
        ServiceValidateConfigurationContext context = this.getServiceValidateConfigurationContextBuilder().validationSpecifications(CollectionUtils.wrapSet((Object)this.proxyValidateControllerValidationSpecification())).proxyHandler((ProxyHandler)this.proxy20Handler.getObject()).build();
        return new ProxyValidateController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"legacyValidateControllerValidationSpecification"})
    public CasProtocolValidationSpecification legacyValidateControllerValidationSpecification() {
        ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
        validationChain.addSpecification((CasProtocolValidationSpecification)this.cas10ProtocolValidationSpecification.getObject());
        return validationChain;
    }

    @Bean
    @ConditionalOnMissingBean(name={"legacyValidateController"})
    public LegacyValidateController legacyValidateController() {
        ServiceValidateConfigurationContext context = this.getServiceValidateConfigurationContextBuilder().validationSpecifications(CollectionUtils.wrapSet((Object)this.legacyValidateControllerValidationSpecification())).proxyHandler((ProxyHandler)this.proxy10Handler.getObject()).build();
        return new LegacyValidateController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceValidateControllerValidationSpecification"})
    public CasProtocolValidationSpecification serviceValidateControllerValidationSpecification() {
        ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
        validationChain.addSpecification((CasProtocolValidationSpecification)this.cas20WithoutProxyProtocolValidationSpecification.getObject());
        return validationChain;
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceValidateController"})
    public ServiceValidateController serviceValidateController() {
        ServiceValidateConfigurationContext context = this.getServiceValidateConfigurationContextBuilder().validationSpecifications(CollectionUtils.wrapSet((Object)this.serviceValidateControllerValidationSpecification())).proxyHandler((ProxyHandler)this.proxy20Handler.getObject()).build();
        return new ServiceValidateController(context);
    }

    @Bean
    public View cas2SuccessView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, this.casProperties.getView().getCas2().getSuccess(), "application/xml");
    }

    @Bean
    public View cas2ServiceFailureView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, this.casProperties.getView().getCas2().getFailure());
    }

    @ConditionalOnProperty(prefix="cas.sso", name={"proxy-authn-enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public View cas2ProxyFailureView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, this.casProperties.getView().getCas2().getProxy().getFailure(), "application/xml");
    }

    @ConditionalOnProperty(prefix="cas.sso", name={"proxy-authn-enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public View cas2ProxySuccessView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, this.casProperties.getView().getCas2().getProxy().getSuccess(), "application/xml");
    }

    @Bean
    public View cas3SuccessView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, this.casProperties.getView().getCas3().getSuccess());
    }

    @Bean
    public View cas3ServiceFailureView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, this.casProperties.getView().getCas3().getFailure(), "application/xml");
    }

    @Bean
    public View casPostResponseView() {
        return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(this.applicationContext, "protocol/casPostResponseView");
    }

    private ServiceValidateConfigurationContext.ServiceValidateConfigurationContextBuilder getServiceValidateConfigurationContextBuilder() {
        return ServiceValidateConfigurationContext.builder().authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).argumentExtractor((ArgumentExtractor)this.argumentExtractor.getObject()).requestedContextValidator((RequestedAuthenticationContextValidator)this.requestedContextValidator.getObject()).authnContextAttribute(this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute()).validationAuthorizers((ServiceTicketValidationAuthorizersExecutionPlan)this.serviceValidationAuthorizers.getObject()).renewEnabled(this.casProperties.getSso().isRenewAuthnEnabled()).validationViewFactory(this.serviceValidationViewFactory());
    }
}

