/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.yubico.core.DefaultSessionManager;
import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.core.WebAuthnServer;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.attestation.AttestationResolver;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.MetadataService;
import com.yubico.webauthn.attestation.StandardMetadataService;
import com.yubico.webauthn.attestation.TrustResolver;
import com.yubico.webauthn.attestation.resolver.CompositeAttestationResolver;
import com.yubico.webauthn.attestation.resolver.CompositeTrustResolver;
import com.yubico.webauthn.attestation.resolver.SimpleAttestationResolver;
import com.yubico.webauthn.attestation.resolver.SimpleTrustResolverWithEquality;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.extension.appid.AppId;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationCoreProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.webauthn.WebAuthnAuthenticationHandler;
import org.apereo.cas.webauthn.WebAuthnCredential;
import org.apereo.cas.webauthn.WebAuthnCredentialRegistrationCipherExecutor;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.apereo.cas.webauthn.WebAuthnUtils;
import org.apereo.cas.webauthn.storage.JsonResourceWebAuthnCredentialRepository;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.apereo.cas.webauthn.web.WebAuthnController;
import org.apereo.cas.webauthn.web.WebAuthnRegisteredDevicesEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.StringUtils;

@Configuration(value="webAuthnConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class WebAuthnConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnConfiguration.class);
    private static final int CACHE_MAX_SIZE = 10000;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="failureModeEvaluator")
    private ObjectProvider<MultifactorAuthenticationFailureModeEvaluator> failureModeEvaluator;
    @Autowired
    @Qualifier(value="webAuthnBypassEvaluator")
    private ObjectProvider<MultifactorAuthenticationProviderBypassEvaluator> webAuthnBypassEvaluator;

    @ConditionalOnMissingBean(name={"webAuthnController"})
    @Bean
    public WebAuthnController webAuthnController() throws Exception {
        return new WebAuthnController(this.webAuthnServer());
    }

    @ConditionalOnMissingBean(name={"webAuthnCredentialRepository"})
    @Bean
    @RefreshScope
    public WebAuthnCredentialRepository webAuthnCredentialRepository() {
        WebAuthnMultifactorAuthenticationProperties webauthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        Resource location = webauthn.getJson().getLocation();
        if (location != null) {
            return new JsonResourceWebAuthnCredentialRepository(this.casProperties, location, this.webAuthnCredentialRegistrationCipherExecutor());
        }
        return WebAuthnCredentialRepository.inMemory();
    }

    @ConditionalOnMissingBean(name={"webAuthnMultifactorAuthenticationProvider"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider() {
        WebAuthnMultifactorAuthenticationProperties webauthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        WebAuthnMultifactorAuthenticationProvider p = new WebAuthnMultifactorAuthenticationProvider();
        p.setBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)this.webAuthnBypassEvaluator.getObject());
        p.setFailureMode(webauthn.getFailureMode());
        p.setFailureModeEvaluator((MultifactorAuthenticationFailureModeEvaluator)this.failureModeEvaluator.getObject());
        p.setOrder(webauthn.getRank());
        p.setId(webauthn.getId());
        return p;
    }

    @Bean
    @ConditionalOnMissingBean(name={"simpleTrustResolverWithEquality"})
    public TrustResolver simpleTrustResolverWithEquality() {
        return new SimpleTrustResolverWithEquality(new ArrayList());
    }

    @Bean
    @ConditionalOnMissingBean(name={"webAuthnMetadataService"})
    public MetadataService webAuthnMetadataService() throws Exception {
        Map foundTrustResolvers = this.applicationContext.getBeansOfType(TrustResolver.class, false, true);
        ArrayList<Object> trustResolvers = new ArrayList<Object>();
        trustResolvers.add(StandardMetadataService.createDefaultTrustResolver());
        trustResolvers.addAll(foundTrustResolvers.values());
        CompositeTrustResolver trustResolver = new CompositeTrustResolver(trustResolvers);
        Map foundAttestations = this.applicationContext.getBeansOfType(AttestationResolver.class, false, true);
        ArrayList<Object> attestationResolvers = new ArrayList<Object>();
        attestationResolvers.add(StandardMetadataService.createDefaultAttestationResolver((TrustResolver)trustResolver));
        Resource resource = this.casProperties.getAuthn().getMfa().getWebAuthn().getCore().getTrustedDeviceMetadata().getLocation();
        if (resource != null) {
            MetadataObject metadata = (MetadataObject)WebAuthnUtils.getObjectMapper().readValue(resource.getInputStream(), MetadataObject.class);
            attestationResolvers.add(new SimpleAttestationResolver((Collection)CollectionUtils.wrapList((Object[])new MetadataObject[]{metadata}), (TrustResolver)trustResolver));
        }
        attestationResolvers.addAll(foundAttestations.values());
        CompositeAttestationResolver attestationResolver = new CompositeAttestationResolver(attestationResolvers);
        return new StandardMetadataService((AttestationResolver)attestationResolver);
    }

    @Bean
    @ConditionalOnMissingBean(name={"webAuthnSessionManager"})
    public SessionManager webAuthnSessionManager() {
        return new DefaultSessionManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"webAuthnServer"})
    public WebAuthnServer webAuthnServer() throws Exception {
        WebAuthnMultifactorAuthenticationCoreProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn().getCore();
        String serverName = this.casProperties.getServer().getName();
        AppId appId = new AppId(org.apache.commons.lang3.StringUtils.defaultString((String)webAuthn.getApplicationId(), (String)serverName));
        RelyingPartyIdentity defaultRelyingPartyId = RelyingPartyIdentity.builder().id(org.apache.commons.lang3.StringUtils.defaultString((String)webAuthn.getRelyingPartyId(), (String)new URL(serverName).getHost())).name(org.apache.commons.lang3.StringUtils.defaultString((String)webAuthn.getRelyingPartyName(), (String)"CAS")).build();
        LinkedHashSet<String> origins = new LinkedHashSet<String>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)webAuthn.getAllowedOrigins())) {
            origins.addAll(StringUtils.commaDelimitedListToSet((String)webAuthn.getAllowedOrigins()));
        } else {
            origins.add(serverName);
        }
        AttestationConveyancePreference conveyance = AttestationConveyancePreference.valueOf((String)webAuthn.getAttestationConveyancePreference().toUpperCase());
        RelyingParty relyingParty = RelyingParty.builder().identity(defaultRelyingPartyId).credentialRepository((CredentialRepository)this.webAuthnCredentialRepository()).origins(origins).attestationConveyancePreference(conveyance).metadataService(this.webAuthnMetadataService()).allowUnrequestedExtensions(webAuthn.isAllowUnrequestedExtensions()).allowUntrustedAttestation(webAuthn.isAllowUntrustedAttestation()).validateSignatureCounter(webAuthn.isValidateSignatureCounter()).appId(appId).build();
        return new WebAuthnServer((RegistrationStorage)this.webAuthnCredentialRepository(), WebAuthnConfiguration.newCache(), WebAuthnConfiguration.newCache(), relyingParty, this.webAuthnSessionManager());
    }

    @ConditionalOnMissingBean(name={"webAuthnPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory webAuthnPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"webAuthnCredentialRegistrationCipherExecutor"})
    @Bean
    @RefreshScope
    public CipherExecutor webAuthnCredentialRegistrationCipherExecutor() {
        EncryptionJwtSigningJwtCryptographyProperties crypto = this.casProperties.getAuthn().getMfa().getWebAuthn().getCrypto();
        if (crypto.isEnabled()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, WebAuthnCredentialRegistrationCipherExecutor.class);
        }
        LOGGER.trace("Web Authn credential registration records managed by CAS are not signed/encrypted.");
        return CipherExecutor.noOp();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"webAuthnAuthenticationHandler"})
    public AuthenticationHandler webAuthnAuthenticationHandler() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        return new WebAuthnAuthenticationHandler(webAuthn.getName(), (ServicesManager)this.servicesManager.getObject(), this.webAuthnPrincipalFactory(), (RegistrationStorage)this.webAuthnCredentialRepository(), this.webAuthnSessionManager(), Integer.valueOf(webAuthn.getOrder()));
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"webAuthnAuthenticationMetaDataPopulator"})
    public AuthenticationMetaDataPopulator webAuthnAuthenticationMetaDataPopulator() {
        String authenticationContextAttribute = this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
        return new AuthenticationContextAttributeMetaDataPopulator(authenticationContextAttribute, this.webAuthnAuthenticationHandler(), this.webAuthnMultifactorAuthenticationProvider().getId());
    }

    @ConditionalOnMissingBean(name={"webAuthnAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer webAuthnAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            plan.registerAuthenticationHandler(this.webAuthnAuthenticationHandler());
            plan.registerAuthenticationMetadataPopulator(this.webAuthnAuthenticationMetaDataPopulator());
            plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{WebAuthnCredential.class}));
        };
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public WebAuthnRegisteredDevicesEndpoint webAuthnRegisteredDevicesEndpoint() {
        return new WebAuthnRegisteredDevicesEndpoint(this.casProperties, this.webAuthnCredentialRepository());
    }

    @ConditionalOnMissingBean(name={"webAuthnDeviceRepositoryCleanerScheduler"})
    @Bean
    @ConditionalOnProperty(prefix="authn.mfa.web-authn.cleaner", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public Runnable webAuthnDeviceRepositoryCleanerScheduler() {
        return new WebAuthnDeviceRepositoryCleanerScheduler(this.webAuthnCredentialRepository());
    }

    private static <K, V> Cache<K, V> newCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(Duration.ofMinutes(5L)).build();
    }

    public static class WebAuthnDeviceRepositoryCleanerScheduler
    implements Runnable {
        private final WebAuthnCredentialRepository repository;

        @Override
        @Scheduled(initialDelayString="${cas.authn.mfa.web-authn.cleaner.schedule.start-delay:PT20S}", fixedDelayString="${cas.authn.mfa.web-authn.cleaner.schedule.repeat-interval:PT5M}")
        public void run() {
            LOGGER.debug("Starting to clean expired devices from repository");
            this.repository.clean();
        }

        @Generated
        public WebAuthnDeviceRepositoryCleanerScheduler(WebAuthnCredentialRepository repository) {
            this.repository = repository;
        }
    }
}

