/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.webauthn.web.flow.WebAuthnAccountCheckRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAccountSaveRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAuthenticationWebflowAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAuthenticationWebflowEventResolver;
import org.apereo.cas.webauthn.web.flow.WebAuthnMultifactorTrustWebflowConfigurer;
import org.apereo.cas.webauthn.web.flow.WebAuthnMultifactorWebflowConfigurer;
import org.apereo.cas.webauthn.web.flow.WebAuthnStartAuthenticationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnStartRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnValidateSessionCredentialTokenAction;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="webAuthnWebflowConfiguration", proxyBeanMethods=true)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class WebAuthnWebflowConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webAuthnPrincipalFactory")
    private ObjectProvider<PrincipalFactory> webAuthnPrincipalFactory;
    @Autowired
    @Qualifier(value="webAuthnSessionManager")
    private ObjectProvider<SessionManager> webAuthnSessionManager;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="webAuthnCredentialRepository")
    private ObjectProvider<RegistrationStorage> webAuthnCredentialRepository;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="casWebflowConfigurationContext")
    private ObjectProvider<CasWebflowEventResolutionConfigurationContext> casWebflowConfigurationContext;
    @Autowired
    @Qualifier(value="flowBuilder")
    private ObjectProvider<FlowBuilder> flowBuilder;

    @Bean
    @ConditionalOnMissingBean(name={"webAuthnFlowRegistry"})
    public FlowDefinitionRegistry webAuthnFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, (FlowBuilderServices)this.flowBuilderServices.getObject());
        builder.addFlowBuilder((FlowBuilder)this.flowBuilder.getObject(), "mfa-webauthn");
        return builder.build();
    }

    @ConditionalOnMissingBean(name={"webAuthnAuthenticationWebflowAction"})
    @Bean
    @RefreshScope
    @Autowired
    public Action webAuthnAuthenticationWebflowAction(@Qualifier(value="webAuthnAuthenticationWebflowEventResolver") CasWebflowEventResolver webAuthnAuthenticationWebflowEventResolver) {
        return new WebAuthnAuthenticationWebflowAction(webAuthnAuthenticationWebflowEventResolver);
    }

    @ConditionalOnMissingBean(name={"webAuthnMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer webAuthnMultifactorWebflowConfigurer() {
        WebAuthnMultifactorWebflowConfigurer cfg = new WebAuthnMultifactorWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.webAuthnFlowRegistry(), this.applicationContext, this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)this.applicationContext));
        cfg.setOrder(100);
        return cfg;
    }

    @ConditionalOnMissingBean(name={"webAuthnStartAuthenticationAction"})
    @Bean
    @RefreshScope
    public Action webAuthnStartAuthenticationAction() {
        return new WebAuthnStartAuthenticationAction((RegistrationStorage)this.webAuthnCredentialRepository.getObject());
    }

    @ConditionalOnMissingBean(name={"webAuthnStartRegistrationAction"})
    @Bean
    @RefreshScope
    public Action webAuthnStartRegistrationAction() {
        return new WebAuthnStartRegistrationAction((RegistrationStorage)this.webAuthnCredentialRepository.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"webAuthnCheckAccountRegistrationAction"})
    @Bean
    @RefreshScope
    public Action webAuthnCheckAccountRegistrationAction() {
        return new WebAuthnAccountCheckRegistrationAction((RegistrationStorage)this.webAuthnCredentialRepository.getObject());
    }

    @ConditionalOnMissingBean(name={"webAuthnSaveAccountRegistrationAction"})
    @Bean
    @RefreshScope
    public Action webAuthnSaveAccountRegistrationAction() {
        return new WebAuthnAccountSaveRegistrationAction((RegistrationStorage)this.webAuthnCredentialRepository.getObject(), (SessionManager)this.webAuthnSessionManager.getObject());
    }

    @ConditionalOnMissingBean(name={"webAuthnValidateSessionCredentialTokenAction"})
    @Bean
    @RefreshScope
    public Action webAuthnValidateSessionCredentialTokenAction() {
        return new WebAuthnValidateSessionCredentialTokenAction((RegistrationStorage)this.webAuthnCredentialRepository.getObject(), (SessionManager)this.webAuthnSessionManager.getObject(), (PrincipalFactory)this.webAuthnPrincipalFactory.getObject());
    }

    @ConditionalOnMissingBean(name={"webAuthnAuthenticationWebflowEventResolver"})
    @Bean
    @RefreshScope
    public CasWebflowEventResolver webAuthnAuthenticationWebflowEventResolver() {
        return new WebAuthnAuthenticationWebflowEventResolver((CasWebflowEventResolutionConfigurationContext)this.casWebflowConfigurationContext.getObject());
    }

    @ConditionalOnMissingBean(name={"webAuthnCasWebflowExecutionPlanConfigurer"})
    @Bean
    @Autowired
    public CasWebflowExecutionPlanConfigurer webAuthnCasWebflowExecutionPlanConfigurer(@Qualifier(value="webAuthnMultifactorWebflowConfigurer") CasWebflowConfigurer webAuthnMultifactorWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(webAuthnMultifactorWebflowConfigurer);
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.web-authn", name={"trusted-device-enabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="webAuthnMultifactorTrustConfiguration")
    public class WebAuthnMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer webAuthnMultifactorTrustWebflowConfigurer() {
            WebAuthnMultifactorTrustWebflowConfigurer cfg = new WebAuthnMultifactorTrustWebflowConfigurer((FlowBuilderServices)WebAuthnWebflowConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)WebAuthnWebflowConfiguration.this.loginFlowDefinitionRegistry.getObject(), WebAuthnWebflowConfiguration.this.webAuthnFlowRegistry(), WebAuthnWebflowConfiguration.this.applicationContext, WebAuthnWebflowConfiguration.this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)WebAuthnWebflowConfiguration.this.applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @Bean
        public CasWebflowExecutionPlanConfigurer webAuthnMultifactorTrustCasWebflowExecutionPlanConfigurer() {
            return plan -> plan.registerWebflowConfigurer(this.webAuthnMultifactorTrustWebflowConfigurer());
        }
    }
}

