/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.yubico.core.DefaultSessionManager;
import com.yubico.core.InMemoryRegistrationStorage;
import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.core.WebAuthnServer;
import com.yubico.fido.metadata.FidoMetadataDownloader;
import com.yubico.fido.metadata.FidoMetadataService;
import com.yubico.fido.metadata.MetadataBLOB;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.attestation.AttestationTrustSource;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.YubicoJsonMetadataService;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.extension.appid.AppId;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.time.Clock;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.MultifactorAuthenticationProviderMetadataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAttestationTrustSourceFidoProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAttestationTrustSourceProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationCoreProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.webauthn.WebAuthnAuthenticationHandler;
import org.apereo.cas.webauthn.WebAuthnCredential;
import org.apereo.cas.webauthn.WebAuthnCredentialRegistrationCipherExecutor;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.apereo.cas.webauthn.metadata.CompositeAttestationTrustSource;
import org.apereo.cas.webauthn.storage.JsonResourceWebAuthnCredentialRepository;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.apereo.cas.webauthn.web.WebAuthnController;
import org.apereo.cas.webauthn.web.WebAuthnRegisteredDevicesEndpoint;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.access.expression.WebExpressionAuthorizationManager;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WebAuthn})
@AutoConfiguration
public class WebAuthnConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.web-authn.core.enabled").isTrue().evenIfMissing();
    private static final int CACHE_MAX_SIZE = 10000;

    private static <K, V> Cache<K, V> newCache() {
        return Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(Duration.ofMinutes(5L)).build();
    }

    @Configuration(value="WebAuthnRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnCredentialRepository"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebAuthnCredentialRepository webAuthnCredentialRepository(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="webAuthnCredentialRegistrationCipherExecutor") CipherExecutor webAuthnCredentialRegistrationCipherExecutor) throws Exception {
            return (WebAuthnCredentialRepository)BeanSupplier.of(WebAuthnCredentialRepository.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                WebAuthnMultifactorAuthenticationProperties webauthn = casProperties.getAuthn().getMfa().getWebAuthn();
                Resource location = webauthn.getJson().getLocation();
                return (WebAuthnCredentialRepository)FunctionUtils.doIfNotNull((Object)location, () -> new JsonResourceWebAuthnCredentialRepository(casProperties, location, webAuthnCredentialRegistrationCipherExecutor), () -> new InMemoryRegistrationStorage(casProperties, webAuthnCredentialRegistrationCipherExecutor)).get();
            }).otherwiseProxy().get();
        }

        @Configuration(value="WebAuthnSecurityConfiguration", proxyBeanMethods=false)
        @Order(value=999)
        public static class WebAuthnSecurityConfiguration {
            @Bean
            @ConditionalOnMissingBean(name={"webAuthnCsrfTokenRepository"})
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            public CsrfTokenRepository webAuthnCsrfTokenRepository() {
                return new HttpSessionCsrfTokenRepository();
            }

            @Bean
            @ConditionalOnMissingBean(name={"webAuthnProtocolEndpointConfigurer"})
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            public CasWebSecurityConfigurer<HttpSecurity> webAuthnProtocolEndpointConfigurer(final @Qualifier(value="webAuthnCsrfTokenRepository") ObjectProvider<CsrfTokenRepository> webAuthnCsrfTokenRepository) {
                return new CasWebSecurityConfigurer<HttpSecurity>(this){

                    @CanIgnoreReturnValue
                    public CasWebSecurityConfigurer<HttpSecurity> configure(HttpSecurity http) throws Exception {
                        http.csrf(customizer -> webAuthnCsrfTokenRepository.ifAvailable(repository -> {
                            AntPathRequestMatcher pattern = new AntPathRequestMatcher("/webauthn/**");
                            XorCsrfTokenRequestAttributeHandler delegate = new XorCsrfTokenRequestAttributeHandler();
                            delegate.setSecureRandom(RandomUtils.getNativeInstance());
                            customizer.requireCsrfProtectionMatcher((RequestMatcher)pattern).csrfTokenRequestHandler((arg_0, arg_1, arg_2) -> ((XorCsrfTokenRequestAttributeHandler)delegate).handle(arg_0, arg_1, arg_2)).csrfTokenRepository(repository);
                        }));
                        http.authorizeHttpRequests(customizer -> {
                            AntPathRequestMatcher regEndpoints = new AntPathRequestMatcher("/webauthn/register/**");
                            AntPathRequestMatcher authEndpoints = new AntPathRequestMatcher("/webauthn/authenticate/**");
                            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{regEndpoints})).access((AuthorizationManager)new WebExpressionAuthorizationManager("hasRole('USER') and isAuthenticated()"));
                            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{authEndpoints})).permitAll();
                        });
                        return this;
                    }
                };
            }
        }

        @Configuration(value="WebAuthnCryptoConfiguration", proxyBeanMethods=false)
        @EnableConfigurationProperties(value={CasConfigurationProperties.class})
        public static class WebAuthnCryptoConfiguration {
            @ConditionalOnMissingBean(name={"webAuthnCredentialRegistrationCipherExecutor"})
            @Bean
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            public CipherExecutor webAuthnCredentialRegistrationCipherExecutor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
                return (CipherExecutor)BeanSupplier.of(CipherExecutor.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                    EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getMfa().getWebAuthn().getCrypto();
                    if (crypto.isEnabled()) {
                        return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, WebAuthnCredentialRegistrationCipherExecutor.class);
                    }
                    LOGGER.trace("Web Authn credential registration records managed by CAS are not signed/encrypted.");
                    return CipherExecutor.noOp();
                }).otherwiseProxy().get();
            }
        }

        @Configuration(value="WebAuthnControllerConfiguration", proxyBeanMethods=false)
        @EnableConfigurationProperties(value={CasConfigurationProperties.class})
        public static class WebAuthnControllerConfiguration {
            @Bean
            @ConditionalOnAvailableEndpoint
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            public WebAuthnRegisteredDevicesEndpoint webAuthnRegisteredDevicesEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="webAuthnCredentialRepository") ObjectProvider<WebAuthnCredentialRepository> webAuthnCredentialRepository) {
                return new WebAuthnRegisteredDevicesEndpoint(casProperties, webAuthnCredentialRepository);
            }

            @ConditionalOnMissingBean(name={"webAuthnController"})
            @Bean
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            public WebAuthnController webAuthnController(@Qualifier(value="webAuthnServer") WebAuthnServer webAuthnServer) {
                return new WebAuthnController(webAuthnServer);
            }
        }

        @Configuration(value="WebAuthnMultifactorProviderConfiguration", proxyBeanMethods=false)
        @EnableConfigurationProperties(value={CasConfigurationProperties.class})
        public static class WebAuthnMultifactorProviderConfiguration {
            @ConditionalOnMissingBean(name={"webAuthnMultifactorAuthenticationProvider"})
            @Bean
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            public MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator, @Qualifier(value="webAuthnBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator webAuthnBypassEvaluator) throws Exception {
                return (MultifactorAuthenticationProvider)BeanSupplier.of(MultifactorAuthenticationProvider.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                    WebAuthnMultifactorAuthenticationProperties webauthn = casProperties.getAuthn().getMfa().getWebAuthn();
                    WebAuthnMultifactorAuthenticationProvider provider = new WebAuthnMultifactorAuthenticationProvider();
                    provider.setBypassEvaluator(webAuthnBypassEvaluator);
                    provider.setFailureMode(webauthn.getFailureMode());
                    provider.setFailureModeEvaluator(failureModeEvaluator);
                    provider.setOrder(webauthn.getRank());
                    provider.setId(webauthn.getId());
                    return provider;
                }).otherwiseProxy().get();
            }
        }
    }

    @Configuration(value="WebAuthnAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnAuthenticationPlanConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer webAuthnAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnMultifactorProviderAuthenticationMetadataPopulator") AuthenticationMetaDataPopulator webAuthnMultifactorProviderAuthenticationMetadataPopulator, @Qualifier(value="webAuthnAuthenticationHandler") AuthenticationHandler webAuthnAuthenticationHandler, @Qualifier(value="webAuthnAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator webAuthnAuthenticationMetaDataPopulator) {
            return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                plan.registerAuthenticationHandlerWithPrincipalResolver(webAuthnAuthenticationHandler, defaultPrincipalResolver);
                plan.registerAuthenticationMetadataPopulator(webAuthnAuthenticationMetaDataPopulator);
                plan.registerAuthenticationMetadataPopulator(webAuthnMultifactorProviderAuthenticationMetadataPopulator);
                plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{WebAuthnCredential.class}));
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnMetadataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnMetadataConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnMultifactorProviderAuthenticationMetadataPopulator"})
        public AuthenticationMetaDataPopulator webAuthnMultifactorProviderAuthenticationMetadataPopulator(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="webAuthnMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
            String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
            return new MultifactorAuthenticationProviderMetadataPopulator(authenticationContextAttribute, multifactorAuthenticationProvider, servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnAuthenticationMetaDataPopulator"})
        public AuthenticationMetaDataPopulator webAuthnAuthenticationMetaDataPopulator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="webAuthnAuthenticationHandler") AuthenticationHandler webAuthnAuthenticationHandler, @Qualifier(value="webAuthnMultifactorAuthenticationProvider") MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider) {
            return (AuthenticationMetaDataPopulator)BeanSupplier.of(AuthenticationMetaDataPopulator.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
                return new AuthenticationContextAttributeMetaDataPopulator(authenticationContextAttribute, webAuthnAuthenticationHandler, webAuthnMultifactorAuthenticationProvider.getId());
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnHandlerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnHandlerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnAuthenticationHandler"})
        public AuthenticationHandler webAuthnAuthenticationHandler(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="webAuthnPrincipalFactory") PrincipalFactory webAuthnPrincipalFactory, @Qualifier(value="webAuthnCredentialRepository") WebAuthnCredentialRepository webAuthnCredentialRepository, @Qualifier(value="webAuthnMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider, @Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (AuthenticationHandler)BeanSupplier.of(AuthenticationHandler.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
                return new WebAuthnAuthenticationHandler(webAuthn.getName(), servicesManager, webAuthnPrincipalFactory, (RegistrationStorage)webAuthnCredentialRepository, webAuthnSessionManager, Integer.valueOf(webAuthn.getOrder()), multifactorAuthenticationProvider);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnServerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnServerConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"webAuthnServer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebAuthnServer webAuthnServer(CasConfigurationProperties casProperties, @Qualifier(value="webAuthnCredentialRepository") WebAuthnCredentialRepository webAuthnCredentialRepository, @Qualifier(value="webAuthnMetadataService") AttestationTrustSource webAuthnMetadataService, @Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager) throws Exception {
            WebAuthnMultifactorAuthenticationCoreProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn().getCore();
            String serverName = casProperties.getServer().getName();
            RelyingPartyIdentity defaultRelyingPartyId = RelyingPartyIdentity.builder().id((String)StringUtils.defaultIfBlank((CharSequence)webAuthn.getRelyingPartyId(), (CharSequence)new URI(serverName).toURL().getHost())).name((String)StringUtils.defaultIfBlank((CharSequence)webAuthn.getRelyingPartyName(), (CharSequence)"CAS")).build();
            LinkedHashSet<String> origins = new LinkedHashSet<String>();
            origins.add(serverName);
            if (StringUtils.isNotBlank((CharSequence)webAuthn.getAllowedOrigins())) {
                origins.addAll(org.springframework.util.StringUtils.commaDelimitedListToSet((String)webAuthn.getAllowedOrigins()));
            }
            AttestationConveyancePreference conveyance = AttestationConveyancePreference.valueOf((String)webAuthn.getAttestationConveyancePreference().toUpperCase(Locale.ENGLISH));
            AppId appId = new AppId((String)StringUtils.defaultIfBlank((CharSequence)webAuthn.getApplicationId(), (CharSequence)serverName));
            RelyingParty relyingParty = RelyingParty.builder().identity(defaultRelyingPartyId).credentialRepository((CredentialRepository)webAuthnCredentialRepository).origins(origins).attestationConveyancePreference(conveyance).attestationTrustSource(webAuthnMetadataService).allowUntrustedAttestation(webAuthn.isAllowUntrustedAttestation()).validateSignatureCounter(webAuthn.isValidateSignatureCounter()).appId(appId).build();
            return new WebAuthnServer((RegistrationStorage)webAuthnCredentialRepository, WebAuthnConfiguration.newCache(), WebAuthnConfiguration.newCache(), relyingParty, webAuthnSessionManager, casProperties);
        }
    }

    public static class WebAuthnDeviceRepositoryCleanerScheduler
    implements Cleanable {
        private final WebAuthnCredentialRepository repository;

        @Scheduled(initialDelayString="${cas.authn.mfa.web-authn.cleaner.schedule.start-delay:PT20S}", fixedDelayString="${cas.authn.mfa.web-authn.cleaner.schedule.repeat-interval:PT5M}")
        public void clean() {
            LOGGER.debug("Starting to clean expired devices from repository");
            this.repository.clean();
        }

        @Generated
        public WebAuthnDeviceRepositoryCleanerScheduler(WebAuthnCredentialRepository repository) {
            this.repository = repository;
        }
    }

    @Configuration(value="WebAuthnSchedulerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnSchedulerConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnDeviceRepositoryCleanerScheduler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Cleanable webAuthnDeviceRepositoryCleanerScheduler(ConfigurableApplicationContext applicationContext, @Qualifier(value="webAuthnCredentialRepository") WebAuthnCredentialRepository webAuthnCredentialRepository) throws Exception {
            return (Cleanable)BeanSupplier.of(Cleanable.class).when(BeanCondition.on((String)"cas.authn.mfa.web-authn.cleaner.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new WebAuthnDeviceRepositoryCleanerScheduler(webAuthnCredentialRepository)).otherwiseProxy().get();
        }
    }

    @Configuration(value="WebAuthnCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnCoreConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnSessionManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public SessionManager webAuthnSessionManager(ConfigurableApplicationContext applicationContext) {
            return (SessionManager)BeanSupplier.of(SessionManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(DefaultSessionManager::new).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"webAuthnPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory webAuthnPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="WebAuthnMetadataServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnMetadataServiceConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"webAuthnMetadataService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public AttestationTrustSource webAuthnMetadataService(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (AttestationTrustSource)BeanSupplier.of(AttestationTrustSource.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                WebAuthnMultifactorAttestationTrustSourceFidoProperties fidoProperties;
                CompositeAttestationTrustSource composite = new CompositeAttestationTrustSource();
                WebAuthnMultifactorAttestationTrustSourceProperties trustSource = casProperties.getAuthn().getMfa().getWebAuthn().getCore().getTrustSource();
                Resource loc = trustSource.getTrustedDeviceMetadata().getLocation();
                if (ResourceUtils.doesResourceExist((Resource)loc)) {
                    LOGGER.debug("Loading FIDO trusted device metadata from location [{}]", (Object)loc);
                    MetadataObject metadata = MetadataObject.readMetadata((InputStream)loc.getInputStream());
                    YubicoJsonMetadataService jsonService = new YubicoJsonMetadataService(List.of(metadata));
                    composite.addAttestationTrustSource((AttestationTrustSource)jsonService);
                }
                if (StringUtils.isNotBlank((CharSequence)(fidoProperties = trustSource.getFido()).getLegalHeader()) && StringUtils.isNotBlank((CharSequence)fidoProperties.getMetadataBlobUrl()) && StringUtils.isNotBlank((CharSequence)fidoProperties.getTrustRootUrl())) {
                    URL trustRootUrl = new URI(fidoProperties.getTrustRootUrl()).toURL();
                    Set trustRootUrlHashes = org.springframework.util.StringUtils.commaDelimitedListToSet((String)fidoProperties.getTrustRootHash()).stream().map(Unchecked.function(ByteArray::fromHex)).collect(Collectors.toSet());
                    FidoMetadataDownloader downloader = FidoMetadataDownloader.builder().expectLegalHeader(new String[]{fidoProperties.getLegalHeader()}).downloadTrustRoot(trustRootUrl, trustRootUrlHashes).useTrustRootCacheFile(fidoProperties.getTrustRootCacheFile()).downloadBlob(new URI(fidoProperties.getMetadataBlobUrl()).toURL()).useBlobCacheFile(fidoProperties.getBlobCacheFile()).verifyDownloadsOnly(true).clock(Clock.systemUTC()).build();
                    LOGGER.info("You have chosen to accept the FIDO Alliance's legal terms & conditions for downloading metadata blobs");
                    LOGGER.info(fidoProperties.getLegalHeader());
                    LOGGER.debug("Starting to refresh/download FIDO metadata blob from [{}] and caching it at [{}]", (Object)fidoProperties.getMetadataBlobUrl(), (Object)fidoProperties.getBlobCacheFile());
                    MetadataBLOB blob = downloader.refreshBlob();
                    FidoMetadataService fidoService = FidoMetadataService.builder().useBlob(blob).build();
                    composite.addAttestationTrustSource((AttestationTrustSource)fidoService);
                }
                return composite;
            })).otherwiseProxy().get();
        }
    }
}

