/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Properties;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.CasConfiguration})
@AutoConfiguration
@Lazy(value=false)
public class CasPropertiesConfiguration {
    @Bean
    public InitializingBean casPropertiesInitializingBean(ConfigurableEnvironment environment) {
        return () -> {
            Properties sysProps = System.getProperties();
            Properties properties = new Properties();
            FunctionUtils.doIfNotNull((Object)CasVersion.getVersion(), value -> properties.put("info.cas.version", value));
            FunctionUtils.doIfNotNull((Object)sysProps.get("java.home"), value -> properties.put("info.cas.java.home", value));
            properties.put("info.cas.java.vendor", sysProps.get("java.vendor"));
            properties.put("info.cas.java.version", sysProps.get("java.version"));
            PropertiesPropertySource src = new PropertiesPropertySource(CasVersion.class.getName(), properties);
            environment.getPropertySources().addFirst((PropertySource)src);
        };
    }
}

