/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.web.extractcert.X509CertificateExtractor;
import org.apereo.cas.web.flow.X509CertificateCredentialsNonInteractiveAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class X509CertificateCredentialsRequestHeaderAction
extends X509CertificateCredentialsNonInteractiveAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CertificateCredentialsRequestHeaderAction.class);
    private final X509CertificateExtractor x509CertificateExtractor;

    public X509CertificateCredentialsRequestHeaderAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, X509CertificateExtractor x509CertificateExtractor) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.x509CertificateExtractor = x509CertificateExtractor;
    }

    @Override
    protected Credential constructCredentialsFromRequest(RequestContext context) {
        Credential x509Credential = super.constructCredentialsFromRequest(context);
        if (x509Credential != null) {
            return x509Credential;
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        if (this.x509CertificateExtractor != null) {
            X509Certificate[] certFromHeader = this.x509CertificateExtractor.extract(request);
            if (certFromHeader != null) {
                LOGGER.debug("Certificate found in HTTP request via {}", (Object)this.x509CertificateExtractor.getClass().getName());
                return new X509CertificateCredential(certFromHeader);
            }
            LOGGER.debug("Certificates not found in request header.");
        } else {
            LOGGER.debug("No X509CertificateExtractor was configured");
        }
        return null;
    }
}

