/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class X509WebflowConfigurer
extends AbstractCasWebflowConfigurer {
    private static final String EVENT_ID_START_X509 = "startX509Authenticate";

    public X509WebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ActionState actionState = this.createActionState(flow, EVENT_ID_START_X509, (Action)this.createEvaluateAction("x509Check"));
            TransitionSet transitionSet = actionState.getTransitionSet();
            transitionSet.add(this.createTransition("success", "createTicketGrantingTicket"));
            transitionSet.add(this.createTransition("warn", "warn"));
            transitionSet.add(this.createTransition("error", "viewLoginForm"));
            transitionSet.add(this.createTransition("authenticationFailure", "viewLoginForm"));
            actionState.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
            ActionState state = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
            this.createTransitionForState((TransitionableState)state, "success", EVENT_ID_START_X509, true);
        }
    }
}

