/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.security.CasWebSecurityConfigurerAdapter;
import org.apereo.cas.web.security.CasWebSecurityExpressionHandler;
import org.apereo.cas.web.security.CasWebSecurityJdbcConfigurerAdapter;
import org.apereo.cas.web.security.flow.PopulateSpringSecurityContextAction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.webflow.execution.Action;

@Configuration(value="casWebAppSecurityConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
public class CasWebAppSecurityConfiguration
implements WebMvcConfigurer {
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ObjectProvider<SecurityProperties> securityProperties;
    @Autowired
    private ObjectProvider<PathMappedEndpoints> pathMappedEndpoints;

    @Bean
    @ConditionalOnMissingBean(name={"casWebSecurityExpressionHandler"})
    public CasWebSecurityExpressionHandler casWebSecurityExpressionHandler() {
        return new CasWebSecurityExpressionHandler();
    }

    @Bean
    @ConditionalOnMissingBean(name={"casWebSecurityConfigurerAdapter"})
    public WebSecurityConfigurerAdapter casWebSecurityConfigurerAdapter() {
        return new CasWebSecurityConfigurerAdapter(this.casProperties, (SecurityProperties)this.securityProperties.getObject(), this.casWebSecurityExpressionHandler(), (PathMappedEndpoints)this.pathMappedEndpoints.getObject());
    }

    @ConditionalOnProperty(name={"cas.monitor.endpoints.jdbc.query"})
    @Bean
    @ConditionalOnMissingBean(name={"casWebSecurityConfigurerJdbcAdapter"})
    public CasWebSecurityJdbcConfigurerAdapter casWebSecurityConfigurerJdbcAdapter() {
        return new CasWebSecurityJdbcConfigurerAdapter(this.casProperties, (ApplicationContext)this.applicationContext);
    }

    @Bean
    public InitializingBean securityContextHolderInitialization() {
        return () -> SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
    }

    @Bean
    @ConditionalOnMissingBean(name={"populateSpringSecurityContextAction"})
    public Action populateSpringSecurityContextAction() {
        return new PopulateSpringSecurityContextAction();
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/adminlogin").setViewName("admin/casAdminLoginView");
        registry.setOrder(Integer.MIN_VALUE);
    }
}

