/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.monitor.JdbcSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.JdbcUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.password.PasswordEncoder;

@Order(value=999)
public class CasWebSecurityJdbcConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebSecurityJdbcConfigurerAdapter.class);
    private final CasConfigurationProperties casProperties;
    private final ApplicationContext applicationContext;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        JdbcSecurityActuatorEndpointsMonitorProperties jdbc = this.casProperties.getMonitor().getEndpoints().getJdbc();
        if (StringUtils.isNotBlank((CharSequence)jdbc.getQuery())) {
            this.configureJdbcAuthenticationProvider(auth, jdbc);
        } else {
            LOGGER.trace("No JDBC query is defined to enable JDBC authentication");
        }
        if (!auth.isConfigured()) {
            super.configure(auth);
        }
    }

    protected void configureJdbcAuthenticationProvider(AuthenticationManagerBuilder auth, JdbcSecurityActuatorEndpointsMonitorProperties jdbc) throws Exception {
        PasswordEncoder passwordEncoder = PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)jdbc.getPasswordEncoder(), (ApplicationContext)this.applicationContext);
        ((JdbcUserDetailsManagerConfigurer)auth.jdbcAuthentication().passwordEncoder(passwordEncoder)).usersByUsernameQuery(jdbc.getQuery()).rolePrefix(jdbc.getRolePrefix()).dataSource((DataSource)JpaBeans.newDataSource((AbstractJpaProperties)jdbc));
    }

    @Generated
    public CasWebSecurityJdbcConfigurerAdapter(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        this.casProperties = casProperties;
        this.applicationContext = applicationContext;
    }
}

