/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.ExtendedAccessLogValve;
import org.apache.catalina.valves.SSLValve;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apereo.cas.config.CasEmbeddedContainerTomcatConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.CasServerProperties;
import org.apereo.cas.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.SocketUtils;

@Configuration(value="casEmbeddedContainerTomcatConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(name={"CasEmbeddedContainerConfigurationActive"}, havingValue="true")
@AutoConfigureBefore(value={EmbeddedServletContainerAutoConfiguration.class})
@AutoConfigureOrder(value=-2147483648)
public class CasEmbeddedContainerTomcatConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEmbeddedContainerTomcatConfiguration.class);
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnClass(value={Tomcat.class, Http2Protocol.class})
    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        this.configureAjp(tomcat);
        this.configureHttp(tomcat);
        this.configureHttpProxy(tomcat);
        this.configureExtendedAccessLogValve(tomcat);
        this.configureRewriteValve(tomcat);
        this.configureSSLValve(tomcat);
        return tomcat;
    }

    private void configureRewriteValve(TomcatEmbeddedServletContainerFactory tomcat) {
        Resource res = this.casProperties.getServer().getRewriteValveConfigLocation();
        if (ResourceUtils.doesResourceExist((Resource)res)) {
            1 valve = new /* Unavailable Anonymous Inner Class!! */;
            valve.setAsyncSupported(true);
            valve.setEnabled(true);
            LOGGER.debug("Creating Rewrite valve configuration for the embedded tomcat container...");
            tomcat.addContextValves(new Valve[]{valve});
        }
    }

    private void configureExtendedAccessLogValve(TomcatEmbeddedServletContainerFactory tomcat) {
        CasServerProperties.ExtendedAccessLog ext = this.casProperties.getServer().getExtAccessLog();
        if (ext.isEnabled() && StringUtils.isNotBlank((CharSequence)ext.getPattern())) {
            LOGGER.debug("Creating extended access log valve configuration for the embedded tomcat container...");
            ExtendedAccessLogValve valve = new ExtendedAccessLogValve();
            valve.setPattern(ext.getPattern());
            if (StringUtils.isBlank((CharSequence)ext.getDirectory())) {
                valve.setDirectory(this.serverProperties.getTomcat().getAccesslog().getDirectory());
            } else {
                valve.setDirectory(ext.getDirectory());
            }
            valve.setPrefix(ext.getPrefix());
            valve.setSuffix(ext.getSuffix());
            valve.setAsyncSupported(true);
            valve.setEnabled(true);
            valve.setRotatable(true);
            valve.setBuffered(true);
            tomcat.addContextValves(new Valve[]{valve});
            tomcat.addEngineValves(new Valve[]{valve});
        }
    }

    private void configureHttp(TomcatEmbeddedServletContainerFactory tomcat) {
        CasServerProperties.Http http = this.casProperties.getServer().getHttp();
        if (http.isEnabled()) {
            LOGGER.debug("Creating HTTP configuration for the embedded tomcat container...");
            Connector connector = new Connector(http.getProtocol());
            int port = http.getPort();
            if (port <= 0) {
                LOGGER.warn("No explicit port configuration is provided to CAS. Scanning for available ports...");
                port = SocketUtils.findAvailableTcpPort();
            }
            LOGGER.info("Activated embedded tomcat container HTTP port to [{}]", (Object)port);
            connector.setPort(port);
            LOGGER.debug("Configuring embedded tomcat container for HTTP2 protocol support");
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            http.getAttributes().forEach((arg_0, arg_1) -> ((Connector)connector).setAttribute(arg_0, arg_1));
            tomcat.addAdditionalTomcatConnectors(new Connector[]{connector});
        }
    }

    private void configureHttpProxy(TomcatEmbeddedServletContainerFactory tomcat) {
        CasServerProperties.HttpProxy proxy = this.casProperties.getServer().getHttpProxy();
        if (proxy.isEnabled()) {
            LOGGER.debug("Customizing HTTP proxying for connector listening on port [{}]", (Object)tomcat.getPort());
            tomcat.getTomcatConnectorCustomizers().add(connector -> {
                connector.setSecure(proxy.isSecure());
                connector.setScheme(proxy.getScheme());
                if (StringUtils.isNotBlank((CharSequence)proxy.getProtocol())) {
                    LOGGER.debug("Setting HTTP proxying protocol to [{}]", (Object)proxy.getProtocol());
                    connector.setProtocol(proxy.getProtocol());
                }
                if (proxy.getRedirectPort() > 0) {
                    LOGGER.debug("Setting HTTP proxying redirect port to [{}]", (Object)proxy.getRedirectPort());
                    connector.setRedirectPort(proxy.getRedirectPort());
                }
                if (proxy.getProxyPort() > 0) {
                    LOGGER.debug("Setting HTTP proxying proxy port to [{}]", (Object)proxy.getProxyPort());
                    connector.setProxyPort(proxy.getProxyPort());
                }
                proxy.getAttributes().forEach((arg_0, arg_1) -> ((Connector)connector).setAttribute(arg_0, arg_1));
                LOGGER.info("Configured connector listening on port [{}]", (Object)tomcat.getPort());
            });
        } else {
            LOGGER.debug("HTTP proxying is not enabled for CAS; Connector configuration for port [{}] is not modified.", (Object)tomcat.getPort());
        }
    }

    private void configureAjp(TomcatEmbeddedServletContainerFactory tomcat) {
        CasServerProperties.Ajp ajp = this.casProperties.getServer().getAjp();
        if (ajp.isEnabled() && ajp.getPort() > 0) {
            LOGGER.debug("Creating AJP configuration for the embedded tomcat container...");
            Connector ajpConnector = new Connector(ajp.getProtocol());
            ajpConnector.setProtocol(ajp.getProtocol());
            ajpConnector.setPort(ajp.getPort());
            ajpConnector.setSecure(ajp.isSecure());
            ajpConnector.setAllowTrace(ajp.isAllowTrace());
            ajpConnector.setScheme(ajp.getScheme());
            if (ajp.getAsyncTimeout() > 0L) {
                ajpConnector.setAsyncTimeout(ajp.getAsyncTimeout());
            }
            ajpConnector.setEnableLookups(ajp.isEnableLookups());
            if (ajp.getMaxPostSize() > 0) {
                ajpConnector.setMaxPostSize(ajp.getMaxPostSize());
            }
            ajpConnector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            if (ajp.getProxyPort() > 0) {
                LOGGER.debug("Set AJP proxy port to [{}]", (Object)ajp.getProxyPort());
                ajpConnector.setProxyPort(ajp.getProxyPort());
            }
            if (ajp.getRedirectPort() > 0) {
                LOGGER.debug("Set AJP redirect port to [{}]", (Object)ajp.getRedirectPort());
                ajpConnector.setRedirectPort(ajp.getRedirectPort());
            }
            ajp.getAttributes().forEach((arg_0, arg_1) -> ((Connector)ajpConnector).setAttribute(arg_0, arg_1));
            tomcat.addAdditionalTomcatConnectors(new Connector[]{ajpConnector});
        }
    }

    private void configureSSLValve(TomcatEmbeddedServletContainerFactory tomcat) {
        CasServerProperties.SslValve valveConfig = this.casProperties.getServer().getSslValve();
        if (valveConfig.isEnabled()) {
            LOGGER.debug("Adding SSLValve to engine of the embedded tomcat container...");
            SSLValve valve = new SSLValve();
            valve.setSslCipherHeader(valveConfig.getSslCipherHeader());
            valve.setSslCipherUserKeySizeHeader(valveConfig.getSslCipherUserKeySizeHeader());
            valve.setSslClientCertHeader(valveConfig.getSslClientCertHeader());
            valve.setSslSessionIdHeader(valveConfig.getSslSessionIdHeader());
            tomcat.addEngineValves(new Valve[]{valve});
        }
    }
}

