/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apache.catalina.Cluster;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.session.BackupManager;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.ClusterSessionListener;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.session.JvmRouteBinderValve;
import org.apache.catalina.ha.tcp.ReplicationValve;
import org.apache.catalina.ha.tcp.SimpleTcpCluster;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.group.interceptors.TcpPingInterceptor;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.catalina.tribes.transport.nio.NioReceiver;
import org.apache.catalina.tribes.transport.nio.PooledParallelSender;
import org.apereo.cas.config.CasTomcatEmbeddedServletContainerFactory;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatClusteringProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;

public class CasTomcatEmbeddedServletContainerFactory
extends TomcatEmbeddedServletContainerFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasTomcatEmbeddedServletContainerFactory.class);
    private final CasEmbeddedApacheTomcatClusteringProperties clusteringProperties;

    public CasTomcatEmbeddedServletContainerFactory(CasEmbeddedApacheTomcatClusteringProperties clusteringProperties) {
        this.clusteringProperties = clusteringProperties;
        this.configureContextForSessionClustering();
    }

    protected TomcatEmbeddedServletContainer getTomcatEmbeddedServletContainer(Tomcat tomcat) {
        this.configureSessionClustering(tomcat);
        return super.getTomcatEmbeddedServletContainer(tomcat);
    }

    private void configureSessionClustering(Tomcat tomcat) {
        String[] memberSpecs;
        if (!this.clusteringProperties.isSessionClusteringEnabled()) {
            LOGGER.debug("Tomcat session clustering/replication is turned off");
            return;
        }
        SimpleTcpCluster cluster = new SimpleTcpCluster();
        cluster.setChannelSendOptions(this.clusteringProperties.getChannelSendOptions());
        ClusterManagerBase manager = this.getClusteringManagerInstance();
        cluster.setManagerTemplate((ClusterManager)manager);
        GroupChannel channel = new GroupChannel();
        NioReceiver receiver = new NioReceiver();
        receiver.setPort(this.clusteringProperties.getReceiverPort());
        receiver.setTimeout(this.clusteringProperties.getReceiverTimeout());
        receiver.setMaxThreads(this.clusteringProperties.getReceiverMaxThreads());
        receiver.setAddress(this.clusteringProperties.getReceiverAddress());
        receiver.setAutoBind(this.clusteringProperties.getReceiverAutoBind());
        channel.setChannelReceiver((ChannelReceiver)receiver);
        McastService membershipService = new McastService();
        membershipService.setPort(this.clusteringProperties.getMembershipPort());
        membershipService.setAddress(this.clusteringProperties.getMembershipAddress());
        membershipService.setFrequency((long)this.clusteringProperties.getMembershipFrequency());
        membershipService.setDropTime((long)this.clusteringProperties.getMembershipDropTime());
        membershipService.setRecoveryEnabled(this.clusteringProperties.isMembershipRecoveryEnabled());
        membershipService.setRecoveryCounter(this.clusteringProperties.getMembershipRecoveryCounter());
        membershipService.setLocalLoopbackDisabled(this.clusteringProperties.isMembershipLocalLoopbackDisabled());
        channel.setMembershipService((MembershipService)membershipService);
        ReplicationTransmitter sender = new ReplicationTransmitter();
        sender.setTransport((MultiPointSender)new PooledParallelSender());
        channel.setChannelSender((ChannelSender)sender);
        channel.addInterceptor((ChannelInterceptor)new TcpPingInterceptor());
        channel.addInterceptor((ChannelInterceptor)new TcpFailureDetector());
        channel.addInterceptor((ChannelInterceptor)new MessageDispatchInterceptor());
        StaticMembershipInterceptor membership = new StaticMembershipInterceptor();
        for (String spec : memberSpecs = this.clusteringProperties.getClusterMembers().split(",", -1)) {
            ClusterMemberDesc memberDesc = new ClusterMemberDesc(spec);
            StaticMember member = new StaticMember();
            member.setHost(memberDesc.getAddress());
            member.setPort(memberDesc.getPort());
            member.setDomain("CAS");
            member.setUniqueId(memberDesc.getUniqueId());
            membership.addStaticMember((Member)member);
            channel.addInterceptor((ChannelInterceptor)membership);
            cluster.setChannel((Channel)channel);
        }
        cluster.addValve((Valve)new ReplicationValve());
        cluster.addValve((Valve)new JvmRouteBinderValve());
        cluster.addClusterListener((ClusterListener)new ClusterSessionListener());
        tomcat.getEngine().setCluster((Cluster)cluster);
    }

    private void configureContextForSessionClustering() {
        if (!this.clusteringProperties.isSessionClusteringEnabled()) {
            LOGGER.debug("Tomcat session clustering/replication is turned off");
            return;
        }
        this.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
            ClusterManagerBase manager = this.getClusteringManagerInstance();
            context.setManager((Manager)manager);
            context.setDistributable(true);
        }});
    }

    private ClusterManagerBase getClusteringManagerInstance() {
        String type = this.clusteringProperties.getManagerType().toUpperCase();
        if ("DELTA".equalsIgnoreCase(type)) {
            DeltaManager manager = new DeltaManager();
            manager.setExpireSessionsOnShutdown(this.clusteringProperties.isExpireSessionsOnShutdown());
            manager.setNotifyListenersOnReplication(true);
            return manager;
        }
        BackupManager backupManager = new BackupManager();
        backupManager.setNotifyListenersOnReplication(true);
        return backupManager;
    }
}

