/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterAndDelegateAuditTrailManager
implements AuditTrailManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterAndDelegateAuditTrailManager.class);
    private final Collection<AuditTrailManager> auditTrailManagers;
    private final List<String> supportedActionsPerformed;
    private final List<String> excludedActionsPerformed;

    public FilterAndDelegateAuditTrailManager(Collection<AuditTrailManager> auditTrailManagers, List<String> supportedActionsPerformed, List<String> excludedActionsPerformed) {
        this.auditTrailManagers = auditTrailManagers;
        this.supportedActionsPerformed = supportedActionsPerformed;
        this.excludedActionsPerformed = excludedActionsPerformed;
    }

    @Override
    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditTrailManagers.forEach(mgr -> mgr.setAuditFormat(auditFormat));
    }

    @Override
    public void record(AuditActionContext auditActionContext) {
        boolean matched = this.supportedActionsPerformed.stream().anyMatch(action -> {
            String actionPerformed = auditActionContext.getActionPerformed();
            return "*".equals(action) || Pattern.compile(action).matcher(actionPerformed).find();
        });
        if (matched) {
            matched = this.excludedActionsPerformed.stream().noneMatch(action -> {
                String actionPerformed = auditActionContext.getActionPerformed();
                return "*".equals(action) || Pattern.compile(action).matcher(actionPerformed).find();
            });
        }
        if (matched) {
            LOGGER.trace("Recording audit action context [{}]", (Object)auditActionContext);
            this.auditTrailManagers.forEach(mgr -> mgr.record(auditActionContext));
        } else {
            LOGGER.trace("Skipping to record audit action context [{}] as it's not authorized as an audit action among [{}]", (Object)auditActionContext, this.supportedActionsPerformed);
        }
    }

    @Override
    public Set<? extends AuditActionContext> getAuditRecordsSince(LocalDate localDate) {
        return this.auditTrailManagers.stream().map(mgr -> mgr.getAuditRecordsSince(localDate)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public void removeAll() {
        this.auditTrailManagers.forEach(AuditTrailManager::removeAll);
    }
}

