/**
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apereo.inspektr.audit.support;

import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import org.apereo.inspektr.audit.AuditActionContext;

import java.io.File;
import java.util.HashMap;

/**
 * <code>AuditTrailManager</code> that dumps auditable information to a configured logger
 * prepped by a Groovy script and template.
 */
public class GroovyAuditTrailManager extends Slf4jLoggingAuditTrailManager {
    private final Template groovyTemplate;

    public GroovyAuditTrailManager(final String groovyTemplate) throws Exception {
        this.groovyTemplate = new SimpleTemplateEngine().createTemplate(groovyTemplate);
    }

    public GroovyAuditTrailManager(final File groovyTemplate) throws Exception {
        this.groovyTemplate = new SimpleTemplateEngine().createTemplate(groovyTemplate);
    }

    @Override
    protected String toString(final AuditActionContext auditActionContext) {
        var map = new HashMap<>(auditActionContext.getHeaders());
        map.putAll(getMappedAuditActionContext(auditActionContext));
        return groovyTemplate.make(map).toString();
    }
}
