/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.common.web;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.net.Inet4Address;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ClientInfo
implements Serializable {
    private static final long serialVersionUID = 7492721606084356617L;
    private final String serverIpAddress;
    private final String clientIpAddress;
    private final String geoLocation;
    private final String userAgent;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Locale locale;

    private ClientInfo() {
        this(null);
    }

    public ClientInfo(HttpServletRequest request) {
        this(request, null, null, false);
    }

    public ClientInfo(HttpServletRequest request, String alternateServerAddrHeaderName, String alternateLocalAddrHeaderName, boolean useServerHostAddress) {
        try {
            String clientIpAddress;
            Locale locale = this.locale = request != null ? request.getLocale() : Locale.getDefault();
            if (request != null) {
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    this.headers.put(headerName, request.getHeader(headerName));
                }
            }
            String serverIpAddress = request != null ? request.getLocalAddr() : null;
            String string = clientIpAddress = request != null ? request.getRemoteAddr() : null;
            if (request == null) {
                this.geoLocation = "unknown";
                this.userAgent = "unknown";
            } else {
                String header;
                if (useServerHostAddress) {
                    serverIpAddress = Inet4Address.getLocalHost().getHostAddress();
                } else if (alternateServerAddrHeaderName != null && !alternateServerAddrHeaderName.isEmpty()) {
                    String string2 = serverIpAddress = request.getHeader(alternateServerAddrHeaderName) != null ? request.getHeader(alternateServerAddrHeaderName) : request.getLocalAddr();
                }
                if (alternateLocalAddrHeaderName != null && !alternateLocalAddrHeaderName.isEmpty()) {
                    clientIpAddress = request.getHeader(alternateLocalAddrHeaderName) != null ? request.getHeader(alternateLocalAddrHeaderName) : request.getRemoteAddr();
                }
                this.userAgent = (header = request.getHeader("user-agent")) == null ? "unknown" : header;
                String geo = request.getParameter("geolocation");
                if (geo == null) {
                    geo = request.getHeader("geolocation");
                }
                this.geoLocation = geo == null ? "unknown" : geo;
            }
            this.serverIpAddress = serverIpAddress == null ? "unknown" : serverIpAddress;
            this.clientIpAddress = clientIpAddress == null ? "unknown" : clientIpAddress;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public String getGeoLocation() {
        return this.geoLocation;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static ClientInfo empty() {
        return new ClientInfo();
    }
}

