/**
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apereo.inspektr.audit.support;

import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * Produces a where clause to select audit records older than a given duration.
 *
 * @author Misagh Moayyed
 * @since 2.0
 */
public class DurationWhereClauseMatchCriteria extends AbstractWhereClauseMatchCriteria {

    private static final String DATE_COLUMN = "AUD_DATE";

    protected String duration;

    public DurationWhereClauseMatchCriteria(final String duration) {
        this.duration = duration;
        addCriteria(DATE_COLUMN, "<");
    }


    @Override
    public List<?> getParameterValues() {
        final Date currentTime = new Date();
        final long newTime = currentTime.getTime() + Duration.parse(duration).toMillis();
        return Collections.singletonList(newTime);
    }
}
