/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.Severity;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ObjectError;

public class MessageContextErrors
extends AbstractErrors {
    private static MessageCriteria GLOBAL_ERROR = message -> message.getSeverity() == Severity.ERROR && message.getSource() == null;
    private static MessageCriteria FIELD_ERROR = message -> message.getSeverity() == Severity.ERROR && message.getSource() instanceof String;
    private MessageContext messageContext;
    private String objectName;
    private Object boundObject;
    private ExpressionParser expressionParser;
    private MappingResults mappingResults;
    private MessageCodesResolver bindingErrorMessageCodesResolver;

    public MessageContextErrors(MessageContext messageContext, String objectName, Object boundObject, ExpressionParser expressionParser, MessageCodesResolver bindingErrorMessageCodesResolver, MappingResults mappingResults) {
        this.messageContext = messageContext;
        this.objectName = objectName;
        this.boundObject = boundObject;
        this.expressionParser = expressionParser;
        this.bindingErrorMessageCodesResolver = bindingErrorMessageCodesResolver;
        this.mappingResults = mappingResults;
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        String[] messageCodes = this.bindingErrorMessageCodesResolver.resolveMessageCodes(errorCode, this.objectName);
        this.messageContext.addMessage(new MessageBuilder().error().codes(messageCodes).args(errorArgs).defaultText(defaultMessage).build());
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        Class<?> fieldType;
        if (StringUtils.hasLength((String)(field = this.fixedField(field))) && this.expressionParser != null) {
            FluentParserContext parserContext = new FluentParserContext().evaluate(this.boundObject.getClass());
            fieldType = this.expressionParser.parseExpression(field, parserContext).getValueType(this.boundObject);
        } else {
            fieldType = null;
        }
        String[] messageCodes = StringUtils.hasLength((String)field) ? this.bindingErrorMessageCodesResolver.resolveMessageCodes(errorCode, this.objectName, field, fieldType) : this.bindingErrorMessageCodesResolver.resolveMessageCodes(errorCode, this.objectName);
        this.messageContext.addMessage(new MessageBuilder().error().source(field).codes(messageCodes).args(errorArgs).defaultText(defaultMessage).build());
    }

    public void addAllErrors(Errors errors) {
        for (ObjectError error : errors.getAllErrors()) {
            MessageBuilder builder = new MessageBuilder().error().codes(error.getCodes()).args(error.getArguments()).defaultText(error.getDefaultMessage());
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError)error;
                builder.source(fieldError.getField());
            }
            this.messageContext.addMessage(builder.build());
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public List<ObjectError> getGlobalErrors() {
        Message[] messages = this.messageContext.getMessagesByCriteria(GLOBAL_ERROR);
        if (messages.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ObjectError> errors = new ArrayList<ObjectError>(messages.length);
        for (Message message : messages) {
            errors.add(new ObjectError(this.objectName, message.getText()));
        }
        return Collections.unmodifiableList(errors);
    }

    public List<FieldError> getFieldErrors() {
        Message[] messages = this.messageContext.getMessagesByCriteria(FIELD_ERROR);
        if (messages.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FieldError> errors = new ArrayList<FieldError>(messages.length);
        for (Message message : messages) {
            errors.add(new FieldError(this.objectName, (String)message.getSource(), message.getText()));
        }
        return Collections.unmodifiableList(errors);
    }

    public Object getFieldValue(String field) {
        List<MappingResult> results;
        field = this.fixedField(field);
        if (this.mappingResults != null && !(results = this.mappingResults.getResults(new PropertyErrorMappingResult(field))).isEmpty()) {
            MappingResult fieldError = results.get(0);
            return fieldError.getOriginalValue();
        }
        return this.parseFieldExpression(field).getValue(this.boundObject);
    }

    private Expression parseFieldExpression(String field) {
        return this.expressionParser.parseExpression(field, new FluentParserContext().evaluate(this.boundObject.getClass()));
    }

    private static class PropertyErrorMappingResult
    implements MappingResultsCriteria {
        private String property;

        public PropertyErrorMappingResult(String property) {
            this.property = property;
        }

        @Override
        public boolean test(MappingResult result) {
            return result.isError() && this.property.equals(result.getMapping().getTargetExpression().getExpressionString());
        }
    }
}

