/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.ResultEventFactory;
import org.springframework.webflow.action.ResultEventFactorySelector;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class EvaluateAction
extends AbstractAction {
    private Expression expression;
    private Expression resultExpression;
    private ResultEventFactory resultEventFactory;

    public EvaluateAction(Expression expression, Expression resultExpression) {
        this.init(expression, resultExpression, null);
    }

    public EvaluateAction(Expression expression, Expression resultExpression, ResultEventFactory resultEventFactory) {
        this.init(expression, resultExpression, resultEventFactory);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("expression", (Object)this.expression).append("resultExpression", (Object)this.resultExpression).toString();
    }

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        Object result = this.expression.getValue((Object)context);
        if (result instanceof Action) {
            return ActionExecutor.execute((Action)result, context);
        }
        if (this.resultExpression != null) {
            this.resultExpression.setValue((Object)context, result);
        }
        return this.resultEventFactory.createResultEvent(this, result, context);
    }

    private void init(Expression expression, Expression resultExpression, ResultEventFactory resultEventFactory) {
        Assert.notNull((Object)expression, (String)"The expression this action should evaluate is required");
        this.expression = expression;
        this.resultExpression = resultExpression;
        this.resultEventFactory = resultEventFactory != null ? resultEventFactory : new DefaultResultEventFactory();
    }

    private class DefaultResultEventFactory
    implements ResultEventFactory {
        private ResultEventFactorySelector selector = new ResultEventFactorySelector();

        private DefaultResultEventFactory() {
        }

        @Override
        public Event createResultEvent(Object source, Object resultObject, RequestContext context) {
            return this.selector.forResult(resultObject).createResultEvent(source, resultObject, context);
        }
    }
}

