/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.webflow.action.DispatchMethodInvoker;
import org.springframework.webflow.action.FormObjectAccessor;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class FormAction
extends MultiAction
implements InitializingBean {
    public static final String DEFAULT_FORM_OBJECT_NAME = "formObject";
    public static final String VALIDATOR_METHOD_ATTRIBUTE = "validatorMethod";
    private String formObjectName = "formObject";
    private Class<?> formObjectClass;
    private ScopeType formObjectScope = ScopeType.FLOW;
    private ScopeType formErrorsScope = ScopeType.FLASH;
    private PropertyEditorRegistrar propertyEditorRegistrar;
    private Validator validator;
    private MessageCodesResolver messageCodesResolver;
    private DispatchMethodInvoker validateMethodInvoker;

    public FormAction() {
    }

    public FormAction(Class<?> formObjectClass) {
        this.setFormObjectClass(formObjectClass);
    }

    public String getFormObjectName() {
        return this.formObjectName;
    }

    public void setFormObjectName(String formObjectName) {
        this.formObjectName = formObjectName;
    }

    public Class<?> getFormObjectClass() {
        return this.formObjectClass;
    }

    public void setFormObjectClass(Class<?> formObjectClass) {
        this.formObjectClass = formObjectClass;
        if ((this.getFormObjectName() == null || this.getFormObjectName() == DEFAULT_FORM_OBJECT_NAME) && formObjectClass != null) {
            this.setFormObjectName(ClassUtils.getShortNameAsProperty(formObjectClass));
        }
    }

    public ScopeType getFormObjectScope() {
        return this.formObjectScope;
    }

    public void setFormObjectScope(ScopeType scopeType) {
        this.formObjectScope = scopeType;
    }

    public ScopeType getFormErrorsScope() {
        return this.formErrorsScope;
    }

    public void setFormErrorsScope(ScopeType errorsScope) {
        this.formErrorsScope = errorsScope;
    }

    public PropertyEditorRegistrar getPropertyEditorRegistrar() {
        return this.propertyEditorRegistrar;
    }

    public void setPropertyEditorRegistrar(PropertyEditorRegistrar propertyEditorRegistrar) {
        this.propertyEditorRegistrar = propertyEditorRegistrar;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public Event setupForm(RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing setupForm");
        }
        Object formObject = this.getFormObject(context);
        this.ensureFormErrorsExposed(context, formObject);
        return this.success();
    }

    public Event bindAndValidate(RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing bind");
        }
        Object formObject = this.getFormObject(context);
        DataBinder binder = this.createBinder(context, formObject);
        this.doBind(context, binder);
        if (this.getValidator() != null && this.validationEnabled(context)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Executing validation");
            }
            this.doValidate(context, formObject, (Errors)binder.getBindingResult());
        } else if (this.logger.isDebugEnabled()) {
            if (this.getValidator() == null) {
                this.logger.debug((Object)"No validator is configured, no validation will occur after binding");
            } else {
                this.logger.debug((Object)"Validation was disabled for this bindAndValidate request");
            }
        }
        this.putFormErrors(context, (Errors)binder.getBindingResult());
        return binder.getBindingResult().hasErrors() ? this.error() : this.success();
    }

    public Event bind(RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing bind");
        }
        Object formObject = this.getFormObject(context);
        DataBinder binder = this.createBinder(context, formObject);
        this.doBind(context, binder);
        this.putFormErrors(context, (Errors)binder.getBindingResult());
        return binder.getBindingResult().hasErrors() ? this.error() : this.success();
    }

    public Event validate(RequestContext context) throws Exception {
        if (this.getValidator() != null && this.validationEnabled(context)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Executing validation");
            }
            Object formObject = this.getFormObject(context);
            Errors errors = this.getFormErrors(context);
            this.doValidate(context, formObject, errors);
            return errors.hasErrors() ? this.error() : this.success();
        }
        if (this.logger.isDebugEnabled()) {
            if (this.getValidator() == null) {
                this.logger.debug((Object)"No validator is configured, no validation will occur");
            } else {
                this.logger.debug((Object)"Validation was disabled for this request");
            }
        }
        return this.success();
    }

    public Event resetForm(RequestContext context) throws Exception {
        Object formObject = this.initFormObject(context);
        this.initFormErrors(context, formObject);
        return this.success();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("formObjectName", (Object)this.formObjectName).append("formObjectClass", this.formObjectClass).append("formObjectScope", (Object)this.formObjectScope).toString();
    }

    @Override
    protected void initAction() {
        if (this.getValidator() != null) {
            if (this.getFormObjectClass() != null && !this.getValidator().supports(this.getFormObjectClass())) {
                throw new IllegalArgumentException("Validator [" + this.getValidator() + "] does not support form object class [" + this.getFormObjectClass() + "]");
            }
            this.validateMethodInvoker = new DispatchMethodInvoker(this.getValidator(), this.getFormObjectClass(), Errors.class);
        }
    }

    protected Object getFormObject(RequestContext context) throws Exception {
        FormObjectAccessor accessor = this.getFormObjectAccessor(context);
        Object formObject = accessor.getFormObject(this.getFormObjectName(), this.getFormObjectScope());
        if (formObject == null) {
            formObject = this.initFormObject(context);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found existing form object with name '" + this.getFormObjectName() + "' of type [" + formObject.getClass() + "] in scope " + this.getFormObjectScope()));
            }
            accessor.setCurrentFormObject(formObject, this.getFormObjectScope());
        }
        return formObject;
    }

    protected Errors getFormErrors(RequestContext context) throws Exception {
        Object formObject = this.getFormObject(context);
        this.ensureFormErrorsExposed(context, formObject);
        return this.getFormObjectAccessor(context).getFormErrors(this.getFormObjectName(), this.getFormErrorsScope());
    }

    protected DataBinder createBinder(RequestContext context, Object formObject) throws Exception {
        WebDataBinder binder = new WebDataBinder(formObject, this.getFormObjectName());
        if (this.getMessageCodesResolver() != null) {
            binder.setMessageCodesResolver(this.getMessageCodesResolver());
        }
        this.initBinder(context, (DataBinder)binder);
        this.registerPropertyEditors(context, (PropertyEditorRegistry)binder);
        return binder;
    }

    protected void doBind(RequestContext context, DataBinder binder) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Binding allowed request parameters in " + StylerUtils.style((Object)context.getExternalContext().getRequestParameterMap()) + " to form object with name '" + binder.getObjectName() + "', pre-bind formObject toString = " + binder.getTarget()));
            if (binder.getAllowedFields() != null && binder.getAllowedFields().length > 0) {
                this.logger.debug((Object)("(Allowed fields are " + StylerUtils.style((Object)binder.getAllowedFields()) + ")"));
            } else {
                this.logger.debug((Object)"(Any field is allowed)");
            }
        }
        binder.bind((PropertyValues)new MutablePropertyValues(context.getRequestParameters().asMap()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Binding completed for form object with name '" + binder.getObjectName() + "', post-bind formObject toString = " + binder.getTarget()));
            this.logger.debug((Object)("There are [" + binder.getBindingResult().getErrorCount() + "] errors, details: " + binder.getBindingResult().getAllErrors()));
        }
    }

    protected void doValidate(RequestContext context, Object formObject, Errors errors) throws Exception {
        Assert.notNull((Object)this.getValidator(), (String)"The validator must not be null when attempting validation -- programmer error");
        String validatorMethodName = context.getAttributes().getString(VALIDATOR_METHOD_ATTRIBUTE);
        if (StringUtils.hasText((String)validatorMethodName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking validation method '" + validatorMethodName + "' on validator " + this.getValidator()));
            }
            this.invokeValidatorMethod(validatorMethodName, formObject, errors);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking validator " + this.getValidator()));
            }
            this.getValidator().validate(formObject, errors);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Validation completed for form object");
            this.logger.debug((Object)("There are [" + errors.getErrorCount() + "] errors, details: " + errors.getAllErrors()));
        }
    }

    protected DispatchMethodInvoker getValidateMethodInvoker() {
        return this.validateMethodInvoker;
    }

    protected FormObjectAccessor getFormObjectAccessor(RequestContext context) {
        return new FormObjectAccessor(context);
    }

    protected Object createFormObject(RequestContext context) throws Exception {
        if (this.getFormObjectClass() == null) {
            throw new IllegalStateException("Cannot create form object without formObjectClass property being set -- either set formObjectClass or override createFormObject");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new instance of form object class [" + this.getFormObjectClass() + "]"));
        }
        return this.getFormObjectClass().newInstance();
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
    }

    protected void registerPropertyEditors(RequestContext context, PropertyEditorRegistry registry) {
        this.registerPropertyEditors(registry);
    }

    protected void registerPropertyEditors(PropertyEditorRegistry registry) {
        if (this.getPropertyEditorRegistrar() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Registering custom property editors using configured registrar");
            }
            this.getPropertyEditorRegistrar().registerCustomEditors(registry);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No property editor registrar set, no custom editors to register");
        }
    }

    protected boolean validationEnabled(RequestContext context) {
        return true;
    }

    private Object initFormObject(RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new form object with name '" + this.getFormObjectName() + "'"));
        }
        Object formObject = this.createFormObject(context);
        this.putFormObject(context, formObject);
        return formObject;
    }

    private void putFormObject(RequestContext context, Object formObject) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Putting form object of type [" + formObject.getClass() + "] in scope " + this.getFormObjectScope() + " with name '" + this.getFormObjectName() + "'"));
        }
        this.getFormObjectAccessor(context).putFormObject(formObject, this.getFormObjectName(), this.getFormObjectScope());
    }

    private Errors initFormErrors(RequestContext context, Object formObject) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new form errors for object with name '" + this.getFormObjectName() + "'"));
        }
        BindingResult errors = this.createBinder(context, formObject).getBindingResult();
        this.putFormErrors(context, (Errors)errors);
        return errors;
    }

    private void putFormErrors(RequestContext context, Errors errors) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Putting form errors instance in scope " + this.getFormErrorsScope()));
        }
        this.getFormObjectAccessor(context).putFormErrors(errors, this.getFormErrorsScope());
    }

    private void ensureFormErrorsExposed(RequestContext context, Object formObject) throws Exception {
        if (!this.formErrorsExposed(context)) {
            this.initFormErrors(context, formObject);
        } else if (this.formErrorsValid(context, formObject)) {
            this.reinstallPropertyEditors(context);
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Fixing inconsistent Errors instance: initializing a new Errors instance wrapping from object '" + formObject + "' in scope '" + this.getFormErrorsScope() + "' and copying over all existing error information."));
            }
            Errors invalidExistingErrors = this.getFormObjectAccessor(context).getFormErrors(this.getFormObjectName(), this.getFormErrorsScope());
            Errors newErrors = this.initFormErrors(context, formObject);
            newErrors.addAllErrors(invalidExistingErrors);
        }
    }

    private boolean formErrorsExposed(RequestContext context) {
        return this.getFormObjectAccessor(context).getFormErrors(this.getFormObjectName(), this.getFormErrorsScope()) != null;
    }

    private boolean formErrorsValid(RequestContext context, Object formObject) {
        Errors errors = this.getFormObjectAccessor(context).getFormErrors(this.getFormObjectName(), this.getFormErrorsScope());
        if (errors instanceof BindingResult) {
            BindingResult be = (BindingResult)errors;
            if (be.getTarget() != formObject) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Inconsistency detected: the Errors instance in '" + this.getFormErrorsScope() + "' does NOT wrap the current form object '" + formObject + "' of class " + formObject.getClass() + "; instead this Errors instance unexpectedly wraps the target object '" + be.getTarget() + "' of class: " + be.getTarget().getClass() + "."));
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private void reinstallPropertyEditors(RequestContext context) {
        BindingResult errors = (BindingResult)this.getFormObjectAccessor(context).getFormErrors(this.getFormObjectName(), this.getFormErrorsScope());
        this.registerPropertyEditors(context, errors.getPropertyEditorRegistry());
    }

    private void invokeValidatorMethod(String validatorMethod, Object formObject, Errors errors) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking piecemeal validator method '" + validatorMethod + "(" + this.getFormObjectClass() + ", Errors)'"));
        }
        this.getValidateMethodInvoker().invoke(validatorMethod, formObject, errors);
    }
}

