/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SetAction
extends AbstractAction {
    private Expression nameExpression;
    private Expression valueExpression;

    public SetAction(Expression nameExpression, Expression valueExpression) {
        Assert.notNull((Object)nameExpression, (String)"The name expression is required");
        Assert.notNull((Object)valueExpression, (String)"The value expression is required");
        this.nameExpression = nameExpression;
        this.valueExpression = valueExpression;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.nameExpression).append("value", (Object)this.valueExpression).toString();
    }

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        Object value = this.valueExpression.getValue((Object)context);
        this.nameExpression.setValue((Object)context, value);
        return this.success();
    }
}

