/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.Collections;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.config.FlowElementAttribute;

class FlowBuilderInfo {
    private String id;
    private String className;
    private Set<FlowElementAttribute> attributes;

    public FlowBuilderInfo(String id, String className, Set<FlowElementAttribute> attributes) {
        Assert.hasText((String)className, (String)"The fully-qualified FlowBuilder class name is required");
        this.className = className;
        this.setId(id);
        this.attributes = attributes != null ? attributes : Collections.emptySet();
    }

    public String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = StringUtils.hasText((String)id) ? id : StringUtils.uncapitalize((String)StringUtils.delete((String)ClassUtils.getShortName((String)this.className), (String)"FlowBuilder"));
    }

    public String getClassName() {
        return this.className;
    }

    public Set<FlowElementAttribute> getAttributes() {
        return this.attributes;
    }
}

