/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.binding.collection.MapAccessor;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;

public class LocalParameterMap
implements ParameterMap,
Serializable {
    private static final DefaultConversionService DEFAULT_CONVERSION_SERVICE = new DefaultConversionService();
    private Map<String, Object> parameters;
    private transient MapAccessor<String, Object> parameterAccessor;
    private transient ConversionService conversionService;

    public LocalParameterMap(Map<String, Object> parameters) {
        this(parameters, (ConversionService)DEFAULT_CONVERSION_SERVICE);
    }

    public LocalParameterMap(Map<String, Object> parameters, ConversionService conversionService) {
        this.initParameters(parameters);
        this.conversionService = conversionService;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalParameterMap)) {
            return false;
        }
        LocalParameterMap other = (LocalParameterMap)o;
        return this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.parameterAccessor.asMap());
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public boolean contains(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    @Override
    public String get(String parameterName) {
        return this.get(parameterName, (String)null);
    }

    @Override
    public String get(String parameterName, String defaultValue) {
        if (!this.parameters.containsKey(parameterName)) {
            return defaultValue;
        }
        Object value = this.parameters.get(parameterName);
        if (value.getClass().isArray()) {
            this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, String[].class);
            String[] array = (String[])value;
            if (array.length == 0) {
                return null;
            }
            String first = ((String[])value)[0];
            this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, (Object)first, String.class);
            return first;
        }
        this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, String.class);
        return (String)value;
    }

    @Override
    public String[] getArray(String parameterName) {
        if (!this.parameters.containsKey(parameterName)) {
            return null;
        }
        Object value = this.parameters.get(parameterName);
        if (value.getClass().isArray()) {
            this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, String[].class);
            return (String[])value;
        }
        this.parameterAccessor.assertKeyValueInstanceOf((Object)parameterName, value, String.class);
        return new String[]{(String)value};
    }

    @Override
    public <T> T[] getArray(String parameterName, Class<T> targetElementType) throws ConversionExecutionException {
        String[] parameters = this.getArray(parameterName);
        return parameters != null ? this.convert(parameters, targetElementType) : null;
    }

    @Override
    public <T> T get(String parameterName, Class<T> targetType) throws ConversionExecutionException {
        return this.get(parameterName, targetType, null);
    }

    @Override
    public <T> T get(String parameterName, Class<T> targetType, T defaultValue) throws ConversionExecutionException {
        String parameter;
        if (defaultValue != null) {
            this.assertAssignableTo(targetType, defaultValue.getClass());
        }
        return (parameter = this.get(parameterName)) != null ? this.convert(parameter, targetType) : defaultValue;
    }

    @Override
    public String getRequired(String parameterName) throws IllegalArgumentException {
        this.parameterAccessor.assertContainsKey((Object)parameterName);
        return this.get(parameterName);
    }

    @Override
    public String[] getRequiredArray(String parameterName) throws IllegalArgumentException {
        this.parameterAccessor.assertContainsKey((Object)parameterName);
        return this.getArray(parameterName);
    }

    @Override
    public <T> T[] getRequiredArray(String parameterName, Class<T> targetElementType) throws IllegalArgumentException, ConversionExecutionException {
        String[] parameters = this.getRequiredArray(parameterName);
        return this.convert(parameters, targetElementType);
    }

    @Override
    public <T> T getRequired(String parameterName, Class<T> targetType) throws IllegalArgumentException, ConversionExecutionException {
        return this.convert(this.getRequired(parameterName), targetType);
    }

    @Override
    public <T extends Number> T getNumber(String parameterName, Class<T> targetType) throws ConversionExecutionException {
        this.assertAssignableTo(Number.class, targetType);
        return (T)((Number)this.get(parameterName, targetType));
    }

    @Override
    public <T extends Number> T getNumber(String parameterName, Class<T> targetType, T defaultValue) throws ConversionExecutionException {
        this.assertAssignableTo(Number.class, targetType);
        return (T)((Number)this.get(parameterName, targetType, defaultValue));
    }

    @Override
    public <T extends Number> T getRequiredNumber(String parameterName, Class<T> targetType) throws IllegalArgumentException, ConversionExecutionException {
        this.assertAssignableTo(Number.class, targetType);
        return (T)((Number)this.getRequired(parameterName, targetType));
    }

    @Override
    public Integer getInteger(String parameterName) throws ConversionExecutionException {
        return this.get(parameterName, Integer.class);
    }

    @Override
    public Integer getInteger(String parameterName, Integer defaultValue) throws ConversionExecutionException {
        return this.get(parameterName, Integer.class, defaultValue);
    }

    @Override
    public Integer getRequiredInteger(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        return this.getRequired(parameterName, Integer.class);
    }

    @Override
    public Long getLong(String parameterName) throws ConversionExecutionException {
        return this.get(parameterName, Long.class);
    }

    @Override
    public Long getLong(String parameterName, Long defaultValue) throws ConversionExecutionException {
        return this.get(parameterName, Long.class, defaultValue);
    }

    @Override
    public Long getRequiredLong(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        return this.getRequired(parameterName, Long.class);
    }

    @Override
    public Boolean getBoolean(String parameterName) throws ConversionExecutionException {
        return this.get(parameterName, Boolean.class);
    }

    @Override
    public Boolean getBoolean(String parameterName, Boolean defaultValue) throws ConversionExecutionException {
        return this.get(parameterName, Boolean.class, defaultValue);
    }

    @Override
    public Boolean getRequiredBoolean(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        return this.getRequired(parameterName, Boolean.class);
    }

    @Override
    public MultipartFile getMultipartFile(String parameterName) {
        return (MultipartFile)this.parameterAccessor.get((Object)parameterName, MultipartFile.class);
    }

    @Override
    public MultipartFile getRequiredMultipartFile(String parameterName) throws IllegalArgumentException {
        return (MultipartFile)this.parameterAccessor.getRequired((Object)parameterName, MultipartFile.class);
    }

    @Override
    public AttributeMap<Object> asAttributeMap() {
        return new LocalAttributeMap<Object>(this.getMapInternal());
    }

    public String toString() {
        return StylerUtils.style(this.parameters);
    }

    protected void initParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        this.parameterAccessor = new MapAccessor(this.parameters);
    }

    protected Map<String, Object> getMapInternal() {
        return this.parameters;
    }

    private <T> T convert(String parameter, Class<T> targetType) throws ConversionExecutionException {
        return (T)this.conversionService.getConversionExecutor(String.class, targetType).execute((Object)parameter);
    }

    private <T> T[] convert(String[] parameters, Class<? extends T> targetElementType) throws ConversionExecutionException {
        ArrayList<Object> list = new ArrayList<Object>(parameters.length);
        ConversionExecutor converter = this.conversionService.getConversionExecutor(String.class, targetElementType);
        for (String parameter : parameters) {
            list.add(converter.execute((Object)parameter));
        }
        return list.toArray((Object[])Array.newInstance(targetElementType, parameters.length));
    }

    private void assertAssignableTo(Class<?> clazz, Class<?> requiredType) {
        Assert.isTrue((boolean)clazz.isAssignableFrom(requiredType), (String)("The provided required type must be assignable to [" + clazz + "]"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parameterAccessor = new MapAccessor(this.parameters);
        this.conversionService = DEFAULT_CONVERSION_SERVICE;
    }
}

