/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.definition.registry;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;
import org.springframework.webflow.definition.registry.StaticFlowDefinitionHolder;

public class FlowDefinitionRegistryImpl
implements FlowDefinitionRegistry {
    private static final Log logger = LogFactory.getLog(FlowDefinitionRegistryImpl.class);
    private Map<String, FlowDefinitionHolder> flowDefinitions = new TreeMap<String, FlowDefinitionHolder>();
    private FlowDefinitionRegistry parent;

    @Override
    public FlowDefinition getFlowDefinition(String id) throws NoSuchFlowDefinitionException, FlowDefinitionConstructionException {
        Assert.hasText((String)id, (String)"An id is required to lookup a FlowDefinition");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting FlowDefinition with id '" + id + "'"));
            }
            return this.getFlowDefinitionHolder(id).getFlowDefinition();
        }
        catch (NoSuchFlowDefinitionException e) {
            if (this.parent != null) {
                return this.parent.getFlowDefinition(id);
            }
            throw e;
        }
    }

    @Override
    public boolean containsFlowDefinition(String flowId) {
        boolean containsFlow = this.flowDefinitions.containsKey(flowId);
        if (!containsFlow && this.parent != null) {
            containsFlow = this.parent.containsFlowDefinition(flowId);
        }
        return containsFlow;
    }

    @Override
    public int getFlowDefinitionCount() {
        return this.flowDefinitions.size();
    }

    @Override
    public String[] getFlowDefinitionIds() {
        return this.flowDefinitions.keySet().toArray(new String[this.flowDefinitions.size()]);
    }

    @Override
    public FlowDefinitionRegistry getParent() {
        return this.parent;
    }

    @Override
    public void setParent(FlowDefinitionRegistry parent) {
        this.parent = parent;
    }

    @Override
    public void registerFlowDefinition(FlowDefinitionHolder definitionHolder) {
        Assert.notNull((Object)definitionHolder, (String)"The holder of the flow definition to register is required");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering flow definition '" + definitionHolder.getFlowDefinitionResourceString() + "' under id '" + definitionHolder.getFlowDefinitionId() + "'"));
        }
        this.flowDefinitions.put(definitionHolder.getFlowDefinitionId(), definitionHolder);
    }

    @Override
    public void registerFlowDefinition(FlowDefinition definition) {
        this.registerFlowDefinition(new StaticFlowDefinitionHolder(definition));
    }

    public void destroy() {
        for (FlowDefinitionHolder holder : this.flowDefinitions.values()) {
            holder.destroy();
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowIds", (Object)this.getFlowDefinitionIds()).append("parent", (Object)this.parent).toString();
    }

    private FlowDefinitionHolder getFlowDefinitionHolder(String id) throws NoSuchFlowDefinitionException {
        FlowDefinitionHolder holder = this.flowDefinitions.get(id);
        if (holder == null) {
            throw new NoSuchFlowDefinitionException(id);
        }
        return holder;
    }
}

