/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.support;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.FlowBuilderException;

public abstract class AbstractFlowBuilder
implements FlowBuilder {
    private Flow flow;
    private FlowBuilderContext context;

    @Override
    public void init(FlowBuilderContext context) throws FlowBuilderException {
        this.context = context;
        this.doInit();
        this.flow = this.createFlow();
    }

    @Override
    public void buildVariables() throws FlowBuilderException {
    }

    @Override
    public void buildInputMapper() throws FlowBuilderException {
    }

    @Override
    public void buildStartActions() throws FlowBuilderException {
    }

    @Override
    public abstract void buildStates() throws FlowBuilderException;

    @Override
    public void buildGlobalTransitions() throws FlowBuilderException {
    }

    @Override
    public void buildEndActions() throws FlowBuilderException {
    }

    @Override
    public void buildOutputMapper() throws FlowBuilderException {
    }

    @Override
    public void buildExceptionHandlers() throws FlowBuilderException {
    }

    @Override
    public Flow getFlow() throws FlowBuilderException {
        return this.flow;
    }

    @Override
    public void dispose() throws FlowBuilderException {
        this.flow = null;
        this.doDispose();
    }

    @Override
    public boolean hasFlowChanged() {
        return false;
    }

    @Override
    public String getFlowResourceString() {
        return this.getClass().getName();
    }

    protected void doInit() {
    }

    protected Flow createFlow() {
        String id = this.getContext().getFlowId();
        AttributeMap<Object> attributes = this.getContext().getFlowAttributes();
        return this.getContext().getFlowArtifactFactory().createFlow(id, attributes);
    }

    protected FlowBuilderContext getContext() {
        return this.context;
    }

    protected void doDispose() {
    }
}

