/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.springframework.binding.message.MessageContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.View;

class RequestControlContextImpl
implements RequestControlContext {
    private FlowExecutionImpl flowExecution;
    private ExternalContext externalContext;
    private MessageContext messageContext;
    private LocalAttributeMap<Object> requestScope = new LocalAttributeMap();
    private LocalAttributeMap<Object> attributes = new LocalAttributeMap();
    private Event currentEvent;
    private Transition currentTransition;
    private View currentView;

    public RequestControlContextImpl(FlowExecutionImpl flowExecution, ExternalContext externalContext, MessageContext messageContext) {
        this.flowExecution = flowExecution;
        this.externalContext = externalContext;
        this.messageContext = messageContext;
    }

    @Override
    public FlowDefinition getActiveFlow() {
        return this.flowExecution.getActiveSession().getDefinition();
    }

    @Override
    public StateDefinition getCurrentState() {
        return this.flowExecution.getActiveSession().getState();
    }

    @Override
    public void setCurrentState(State state) {
        this.flowExecution.setCurrentState(state, this);
    }

    @Override
    public TransitionDefinition getMatchingTransition(String eventId) throws IllegalStateException {
        return this.flowExecution.getMatchingTransition(eventId);
    }

    @Override
    public MutableAttributeMap<Object> getRequestScope() {
        return this.requestScope;
    }

    @Override
    public MutableAttributeMap<Object> getFlashScope() {
        return this.flowExecution.getFlashScope();
    }

    @Override
    public boolean inViewState() {
        return this.flowExecution.isActive() && this.getCurrentState() != null && this.getCurrentState().isViewState();
    }

    @Override
    public MutableAttributeMap<Object> getViewScope() throws IllegalStateException {
        return this.flowExecution.getActiveSession().getViewScope();
    }

    @Override
    public MutableAttributeMap<Object> getFlowScope() {
        return this.flowExecution.getActiveSession().getScope();
    }

    @Override
    public MutableAttributeMap<Object> getConversationScope() {
        return this.flowExecution.getConversationScope();
    }

    @Override
    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    @Override
    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    @Override
    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    @Override
    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecution;
    }

    @Override
    public Event getCurrentEvent() {
        return this.currentEvent;
    }

    @Override
    public TransitionDefinition getCurrentTransition() {
        return this.currentTransition;
    }

    @Override
    public void setCurrentTransition(Transition transition) {
        this.currentTransition = transition;
    }

    @Override
    public View getCurrentView() {
        return this.currentView;
    }

    @Override
    public void setCurrentView(View currentView) {
        this.currentView = currentView;
    }

    @Override
    public MutableAttributeMap<Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getFlowExecutionUrl() {
        String key;
        String string = key = this.flowExecution.getKey() != null ? this.flowExecution.getKey().toString() : null;
        if (key != null) {
            return this.externalContext.getFlowExecutionUrl(this.flowExecution.getDefinition().getId(), key);
        }
        return null;
    }

    public void sendFlowExecutionRedirect() {
        this.externalContext.requestFlowExecutionRedirect();
    }

    @Override
    public FlowExecutionKey assignFlowExecutionKey() {
        return this.flowExecution.assignKey();
    }

    @Override
    public void viewRendering(View view) {
        this.flowExecution.viewRendering(view, this);
    }

    @Override
    public void viewRendered(View view) {
        this.flowExecution.viewRendered(view, this);
    }

    @Override
    public boolean handleEvent(Event event) throws FlowExecutionException {
        this.currentEvent = event;
        return this.flowExecution.handleEvent(event, this);
    }

    @Override
    public boolean execute(Transition transition) {
        return this.flowExecution.execute(transition, this);
    }

    @Override
    public void updateCurrentFlowExecutionSnapshot() {
        this.flowExecution.updateCurrentFlowExecutionSnapshot();
    }

    @Override
    public void removeCurrentFlowExecutionSnapshot() {
        this.flowExecution.removeCurrentFlowExecutionSnapshot();
    }

    @Override
    public void removeAllFlowExecutionSnapshots() {
        this.flowExecution.removeAllFlowExecutionSnapshots();
    }

    @Override
    public void start(Flow flow, MutableAttributeMap<?> input) throws FlowExecutionException {
        this.flowExecution.start(flow, input, this);
    }

    @Override
    public void endActiveFlowSession(String outcome, MutableAttributeMap<Object> output) throws IllegalStateException {
        this.flowExecution.endActiveFlowSession(outcome, output, this);
    }

    @Override
    public boolean getRedirectOnPause() {
        if (!this.getExternalContext().isResponseAllowed()) {
            return true;
        }
        Boolean redirectOnPause = this.flowExecution.getAttributes().getBoolean("alwaysRedirectOnPause");
        return redirectOnPause == null ? false : redirectOnPause;
    }

    @Override
    public boolean getRedirectInSameState() {
        if (!this.getExternalContext().isResponseAllowed()) {
            return true;
        }
        Boolean redirectInSameState = this.flowExecution.getAttributes().getBoolean("redirectInSameState");
        return redirectInSameState != null ? redirectInSameState.booleanValue() : this.getRedirectOnPause();
    }

    @Override
    public boolean getEmbeddedMode() {
        return this.flowExecution.getActiveSession().isEmbeddedMode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("externalContext", (Object)this.externalContext).append("currentEvent", (Object)this.currentEvent).append("requestScope", this.requestScope).append("attributes", this.attributes).append("messageContext", (Object)this.messageContext).append("flowExecution", (Object)this.flowExecution).toString();
    }
}

