/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.Collections;
import java.util.LinkedList;
import org.springframework.webflow.engine.model.Model;

public abstract class AbstractModel
implements Model {
    protected Object merge(Object child, Object parent) {
        if (child == null) {
            return parent;
        }
        return child;
    }

    protected String merge(String child, String parent) {
        return (String)this.merge((Object)child, (Object)parent);
    }

    protected Model merge(Model child, Model parent) {
        if (child == null) {
            if (parent == null) {
                return null;
            }
            return parent.createCopy();
        }
        if (parent == null) {
            return child;
        }
        child.merge(parent);
        return child;
    }

    protected <T extends Model> LinkedList<T> merge(LinkedList<T> child, LinkedList<T> parent) {
        return this.merge(child, parent, true);
    }

    protected <T extends Model> LinkedList<T> merge(LinkedList<T> child, LinkedList<T> parent, boolean addAtEnd) {
        if (child == null) {
            return this.copyList(parent);
        }
        if (parent == null) {
            return child;
        }
        if (!addAtEnd) {
            parent = new LinkedList<T>(parent);
            Collections.reverse(parent);
        }
        for (Model parentModel : parent) {
            this.addOrMerge(child, parentModel, addAtEnd);
        }
        return child;
    }

    protected Model copy(Model model) {
        if (model == null) {
            return null;
        }
        return model.createCopy();
    }

    protected <T extends Model> LinkedList<T> copyList(LinkedList<T> list) {
        if (list == null) {
            return null;
        }
        LinkedList<Model> copy = new LinkedList<Model>();
        for (Model model : list) {
            copy.add(model.createCopy());
        }
        return copy;
    }

    private <T extends Model> void addOrMerge(LinkedList<T> list, T modelToMerge, boolean addAtEnd) {
        for (Model model : list) {
            if (!model.isMergeableWith(modelToMerge)) continue;
            model.merge(modelToMerge);
            return;
        }
        Model copy = modelToMerge.createCopy();
        if (addAtEnd) {
            list.addLast(copy);
        } else {
            list.addFirst(copy);
        }
    }
}

