/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.io.Serializable;
import java.util.Map;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class ActionExecutingViewFactory
implements ViewFactory {
    private Action action;

    public ActionExecutingViewFactory(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public View getView(RequestContext context) {
        return new ActionExecutingView(this.action, context);
    }

    private static class ActionExecutingView
    implements View {
        private Action action;
        private RequestContext requestContext;
        private String eventId;
        private boolean userEventProcessed;

        private ActionExecutingView(Action action, RequestContext requestContext) {
            this.action = action;
            this.requestContext = requestContext;
        }

        @Override
        public void render() {
            if (this.action != null) {
                ActionExecutor.execute(this.action, this.requestContext);
            }
        }

        @Override
        public boolean userEventQueued() {
            return this.getEventId() != null;
        }

        @Override
        public void processUserEvent() {
            this.userEventProcessed = true;
        }

        @Override
        public Serializable getUserEventState() {
            return null;
        }

        @Override
        public boolean hasFlowEvent() {
            return this.userEventProcessed && this.getEventId() != null;
        }

        @Override
        public Event getFlowEvent() {
            if (!this.hasFlowEvent()) {
                return null;
            }
            return new Event(this, this.eventId);
        }

        @Override
        public void saveState() {
        }

        protected String determineEventId(RequestContext context) {
            return WebUtils.findParameterValue((Map)context.getRequestParameters().asMap(), (String)"_eventId");
        }

        private String getEventId() {
            if (this.eventId == null) {
                this.eventId = this.determineEventId(this.requestContext);
            }
            return this.eventId;
        }
    }
}

