/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.builder;

import java.util.List;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.beanwrapper.BeanWrapperExpressionParser;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.mvc.builder.DelegatingFlowViewResolver;
import org.springframework.webflow.mvc.builder.FlowResourceFlowViewResolver;
import org.springframework.webflow.mvc.servlet.ServletMvcViewFactory;
import org.springframework.webflow.mvc.view.AbstractMvcViewFactory;
import org.springframework.webflow.mvc.view.FlowViewResolver;
import org.springframework.webflow.validation.ValidationHintResolver;
import org.springframework.webflow.validation.WebFlowMessageCodesResolver;

public class MvcViewFactoryCreator
implements ViewFactoryCreator {
    private FlowViewResolver flowViewResolver = new FlowResourceFlowViewResolver();
    private boolean useSpringBeanBinding;
    private String eventIdParameterName;
    private String fieldMarkerPrefix;
    private MessageCodesResolver messageCodesResolver = new WebFlowMessageCodesResolver();

    public void setDefaultViewSuffix(String defaultViewSuffix) {
        FlowResourceFlowViewResolver internalResourceResolver = new FlowResourceFlowViewResolver();
        internalResourceResolver.setDefaultViewSuffix(defaultViewSuffix);
        this.flowViewResolver = internalResourceResolver;
    }

    public void setEventIdParameterName(String eventIdParameterName) {
        this.eventIdParameterName = eventIdParameterName;
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public void setUseSpringBeanBinding(boolean useSpringBeanBinding) {
        this.useSpringBeanBinding = useSpringBeanBinding;
    }

    public void setFlowViewResolver(FlowViewResolver flowViewResolver) {
        this.flowViewResolver = flowViewResolver;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.flowViewResolver = new DelegatingFlowViewResolver(viewResolvers);
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    @Override
    public ViewFactory createViewFactory(Expression viewId, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration, Validator validator, ValidationHintResolver validationHintResolver) {
        if (this.useSpringBeanBinding) {
            expressionParser = new BeanWrapperExpressionParser(conversionService);
        }
        AbstractMvcViewFactory viewFactory = this.createMvcViewFactory(viewId, expressionParser, conversionService, binderConfiguration);
        if (StringUtils.hasText((String)this.eventIdParameterName)) {
            viewFactory.setEventIdParameterName(this.eventIdParameterName);
        }
        if (StringUtils.hasText((String)this.fieldMarkerPrefix)) {
            viewFactory.setFieldMarkerPrefix(this.fieldMarkerPrefix);
        }
        viewFactory.setValidator(validator);
        viewFactory.setValidationHintResolver(validationHintResolver);
        return viewFactory;
    }

    @Override
    public String getViewIdByConvention(String viewStateId) {
        return this.flowViewResolver.getViewIdByConvention(viewStateId);
    }

    protected AbstractMvcViewFactory createMvcViewFactory(Expression viewId, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration) {
        return new ServletMvcViewFactory(viewId, this.flowViewResolver, expressionParser, conversionService, binderConfiguration, this.messageCodesResolver);
    }
}

