/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.security;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.util.StringUtils;

public class SecurityRule {
    public static final String SECURITY_ATTRIBUTE_NAME = "secured";
    public static final short COMPARISON_ANY = 1;
    public static final short COMPARISON_ALL = 2;
    private Collection<String> attributes;
    private short comparisonType = 1;

    public static String securityAttributesToCommaDelimitedList(Collection<?> attributes) {
        return StringUtils.collectionToDelimitedString(attributes, (String)", ");
    }

    public static Collection<String> commaDelimitedListToSecurityAttributes(String attributes) {
        HashSet<String> attrs = new HashSet<String>();
        for (String attribute : attributes.split(",")) {
            if ((attribute = attribute.trim()).isEmpty()) continue;
            attrs.add(attribute);
        }
        return attrs;
    }

    public Collection<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<String> attributes) {
        this.attributes = attributes;
    }

    public short getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(short comparisonType) {
        this.comparisonType = comparisonType;
    }
}

