/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.validation;

import java.util.ArrayList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.validation.ValidationHintResolver;

public class BeanValidationHintResolver
implements ValidationHintResolver {
    public Class<?>[] resolveValidationHints(Object model, String flowId, String stateId, String[] hints) throws FlowExecutionException {
        if (ObjectUtils.isEmpty((Object[])hints)) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (String hint : hints) {
            Class<?> resolvedHint;
            if (hint.equalsIgnoreCase("Default")) {
                hint = "jakarta.validation.groups.Default";
            }
            if ((resolvedHint = this.toClass(hint)) == null && model != null) {
                resolvedHint = this.findInnerClass(model.getClass(), StringUtils.capitalize((String)hint));
            }
            if (resolvedHint == null) {
                resolvedHint = this.handleUnresolvedHint(model, flowId, stateId, hint);
            }
            if (resolvedHint == null) continue;
            result.add(resolvedHint);
        }
        return result.toArray(new Class[result.size()]);
    }

    protected Class<?> handleUnresolvedHint(Object model, String flowId, String stateId, String hint) throws FlowExecutionException {
        throw new FlowExecutionException(flowId, stateId, "Failed to resolve validation hint [" + hint + "]");
    }

    private Class<?> toClass(String hint) {
        try {
            return Class.forName(hint);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Class<?> findInnerClass(Class<?> targetClass, String hint) {
        try {
            return Class.forName(targetClass.getName() + "$" + hint);
        }
        catch (ClassNotFoundException e) {
            Class<?> superClass = targetClass.getSuperclass();
            if (superClass != null) {
                return this.findInnerClass(superClass, hint);
            }
            return null;
        }
    }
}

