/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import java.io.InputStream;
import org.apidesign.vm4brwsr.ClosureWrapper;
import org.apidesign.vm4brwsr.LdrRsrcs;
import org.apidesign.vm4brwsr.ObfuscationLevel;
import org.apidesign.vm4brwsr.StringArray;
import org.apidesign.vm4brwsr.VM;

public final class Bck2Brwsr {
    private static final boolean ignoreClosureCompiler = "false".equals(System.getProperty("bck2brwsr.closure.compiler"));
    private final ObfuscationLevel level;
    private final StringArray exported;
    private final StringArray classes;
    private final StringArray resources;
    private final Resources res;
    private final Boolean extension;
    private final StringArray classpath;

    private Bck2Brwsr(ObfuscationLevel level, StringArray exported, StringArray classes, StringArray resources, Resources res, Boolean extension, StringArray classpath) {
        this.level = level;
        this.exported = exported;
        this.classes = classes;
        this.resources = resources;
        this.res = res;
        this.extension = extension;
        this.classpath = classpath;
    }

    public static void generate(Appendable out, Resources resources, String ... classes) throws IOException {
        Bck2Brwsr.newCompiler().resources(resources).addRootClasses(classes).generate(out);
    }

    public static void generate(Appendable out, ClassLoader loader, String ... classes) throws IOException {
        Bck2Brwsr.newCompiler().resources(loader).addRootClasses(classes).generate(out);
    }

    public static Bck2Brwsr newCompiler() {
        return new Bck2Brwsr(ObfuscationLevel.NONE, new StringArray(), new StringArray(), new StringArray(), null, false, null);
    }

    public Bck2Brwsr addExported(String ... exported) {
        return new Bck2Brwsr(this.level, this.exported.addAndNew(exported), this.classes, this.resources, this.res, this.extension, this.classpath);
    }

    public Bck2Brwsr addRootClasses(String ... classes) {
        if (classes.length == 0) {
            return this;
        }
        return this.addExported(classes).addClasses(classes);
    }

    public Bck2Brwsr addClasses(String ... classes) {
        if (classes.length == 0) {
            return this;
        }
        return new Bck2Brwsr(this.level, this.exported, this.classes.addAndNew(classes), this.resources, this.res, this.extension, this.classpath);
    }

    public Bck2Brwsr addResources(String ... resources) {
        if (resources.length == 0) {
            return this;
        }
        return new Bck2Brwsr(this.level, this.exported, this.classes, this.resources.addAndNew(resources), this.res, this.extension, this.classpath);
    }

    public Bck2Brwsr obfuscation(ObfuscationLevel level) {
        return new Bck2Brwsr(level, this.exported, this.classes, this.resources, this.res, this.extension, this.classpath);
    }

    public Bck2Brwsr resources(Resources res) {
        return new Bck2Brwsr(this.level, this.exported, this.classes, this.resources, res, this.extension, this.classpath);
    }

    public Bck2Brwsr library(String ... classpath) {
        StringArray newCP = classpath == null ? this.classpath : StringArray.asList(classpath);
        return new Bck2Brwsr(this.level, this.exported, this.classes, this.resources, this.res, true, newCP);
    }

    public Bck2Brwsr standalone(boolean includeVM) {
        return new Bck2Brwsr(this.level, this.exported, this.classes, this.resources, this.res, includeVM ? Boolean.valueOf(false) : null, null);
    }

    public Bck2Brwsr resources(ClassLoader loader) {
        return this.resources(loader, false);
    }

    public Bck2Brwsr resources(ClassLoader loader, boolean ignoreBootClassPath) {
        return this.resources(new LdrRsrcs(loader, ignoreBootClassPath));
    }

    public void generate(Appendable out) throws IOException {
        if (!ignoreClosureCompiler && this.level != ObfuscationLevel.NONE) {
            try {
                ClosureWrapper.produceTo(out, this.level, this);
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                out.append("/* Failed to obfuscate: " + ex.getMessage() + " */\n");
            }
        }
        VM.compile(out, this);
    }

    Resources getResources() {
        return this.res != null ? this.res : new LdrRsrcs(Bck2Brwsr.class.getClassLoader(), false);
    }

    StringArray allResources() {
        return this.resources;
    }

    StringArray classes() {
        return this.classes;
    }

    StringArray exported() {
        return this.exported;
    }

    boolean isExtension() {
        return Boolean.TRUE.equals(this.extension);
    }

    boolean includeVM() {
        return this.extension != null;
    }

    StringArray classpath() {
        return this.classpath;
    }

    public static interface Resources {
        public InputStream get(String var1) throws IOException;
    }
}

