/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.SourceFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apidesign.bck2brwsr.core.ExtraJavaScript;
import org.apidesign.vm4brwsr.Bck2Brwsr;
import org.apidesign.vm4brwsr.ObfuscationLevel;
import org.apidesign.vm4brwsr.VM;

@ExtraJavaScript(processByteCode=false, resource="")
final class ClosureWrapper
extends CommandLineRunner {
    private static final String[] ARGS = new String[]{"--compilation_level", "SIMPLE_OPTIMIZATIONS", "--output_wrapper", "(function() {%output%})(this);", "--js", "bck2brwsr-raw.js"};
    private final Bck2Brwsr config;
    private String compiledCode;
    private String externsCode;
    private IOException compilerError;
    private static final String[] FIXED_EXTERNS = new String[]{"bck2brwsr", "bck2BrwsrThrwrbl", "register", "$class", "$lambda", "anno", "array", "access", "cls", "vm", "loadClass", "loadBytes", "jvmName", "primitive", "superclass", "interfaces", "cnstr", "add32", "sub32", "mul32", "neg32", "toInt8", "toInt16", "next32", "high32", "toInt32", "toFP", "toLong", "toJS", "toExactString", "add64", "sub64", "mul64", "and64", "or64", "xor64", "shl64", "shr64", "ushr64", "compare", "compare64", "neg64", "div32", "mod32", "div64", "mod64", "at", "cons__V", "getClass__Ljava_lang_Class_2", "clone__Ljava_lang_Object_2", "observable", "notify", "valueHasMutated"};

    private ClosureWrapper(Appendable out, String compilationLevel, Bck2Brwsr config, PrintStream err) {
        super(ClosureWrapper.generateArguments(compilationLevel), new PrintStream(new APS(out)), err);
        this.config = config;
    }

    protected List<SourceFile> createInputs(List<String> files, boolean allowStdIn) throws AbstractCommandLineRunner.FlagUsageException, IOException {
        if (files.size() != 1 || !"bck2brwsr-raw.js".equals(files.get(0))) {
            throw new IOException("Unexpected files: " + files);
        }
        return Collections.nCopies(1, SourceFile.fromGenerator((String)"bck2brwsr-raw.js", (SourceFile.Generator)new SourceFile.Generator(){

            public String getCode() {
                return ClosureWrapper.this.getCompiledCode();
            }
        }));
    }

    protected List<SourceFile> createExterns() throws AbstractCommandLineRunner.FlagUsageException, IOException {
        ArrayList<SourceFile> externsFiles = new ArrayList<SourceFile>(super.createExterns());
        externsFiles.add(SourceFile.fromGenerator((String)"bck2brwsr_externs.js", (SourceFile.Generator)new SourceFile.Generator(){

            public String getCode() {
                return ClosureWrapper.this.getExternsCode();
            }
        }));
        return externsFiles;
    }

    private String getCompiledCode() {
        if (this.compiledCode == null) {
            StringBuilder sb = new StringBuilder();
            try {
                VM.compile(sb, this.config);
                this.compiledCode = sb.toString();
            }
            catch (IOException ex) {
                this.compilerError = ex;
                return "// Error: " + ex.getMessage();
            }
        }
        return this.compiledCode;
    }

    private String getExternsCode() {
        if (this.externsCode == null) {
            this.getCompiledCode();
            StringBuilder sb = new StringBuilder("function RAW() {};\n");
            for (String extern : FIXED_EXTERNS) {
                sb.append("RAW.prototype.").append(extern).append(";\n");
            }
            this.externsCode = sb.toString();
        }
        return this.externsCode;
    }

    private static String[] generateArguments(String compilationLevel) {
        String[] finalArgs = (String[])ARGS.clone();
        finalArgs[1] = compilationLevel;
        return finalArgs;
    }

    static int produceTo(Appendable output, ObfuscationLevel obfuscationLevel, Bck2Brwsr config) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(out);
        ClosureWrapper cw = new ClosureWrapper(output, obfuscationLevel == ObfuscationLevel.FULL ? "ADVANCED_OPTIMIZATIONS" : "SIMPLE_OPTIMIZATIONS", config, err);
        try {
            int result = cw.doRun();
            if (cw.compilerError != null) {
                throw cw.compilerError;
            }
            if (result != 0) {
                throw new IOException(out.toString());
            }
            return result;
        }
        catch (AbstractCommandLineRunner.FlagUsageException ex) {
            throw new IOException(out.toString(), ex);
        }
    }

    private static final class APS
    extends OutputStream {
        private final Appendable out;

        public APS(Appendable out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.append((char)b);
        }
    }
}

