/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.ByteCodeToJavaScript;
import org.apidesign.vm4brwsr.LoopCode;
import org.apidesign.vm4brwsr.NumberOperations;

final class JsCallbackCode
extends LoopCode {
    private final StringBuilder sb;
    private Appendable dump;

    JsCallbackCode(ByteCodeToJavaScript b, Appendable out, NumberOperations n, ByteCodeParser.ClassData jc) {
        this(b, new StringBuilder(), out, n, jc);
    }

    private JsCallbackCode(ByteCodeToJavaScript b, StringBuilder sb, Appendable out, NumberOperations n, ByteCodeParser.ClassData jc) {
        super(b, sb, n, jc);
        this.sb = sb;
        this.dump = out;
    }

    @Override
    protected boolean beginCall(String[] mi, CharSequence[] vars, boolean isStatic) {
        if (this.dump != null && !JsCallbackCode.isSpecialHtmlJavaCall(mi)) {
            this.sb.setLength(0);
            if (!isStatic) {
                vars[0] = "lcA1";
            }
            this.sb.append("return ");
            return true;
        }
        return false;
    }

    @Override
    protected void endCall(boolean ok) throws IOException {
        if (ok) {
            this.dump.append(this.sb);
            this.dump = null;
        }
    }

    private static boolean isSpecialHtmlJavaCall(String[] mi) {
        return mi[0].startsWith("org/netbeans/html/boot/spi/Fn") || mi[0].startsWith("org/apidesign/html/boot/spi/Fn");
    }
}

