/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.ByteCodeToJavaScript;
import org.apidesign.vm4brwsr.IndyHandler;
import org.apidesign.vm4brwsr.LocalsMapper;
import org.apidesign.vm4brwsr.NumberOperations;
import org.apidesign.vm4brwsr.StackMapper;
import org.apidesign.vm4brwsr.TrackingAppendable;
import org.apidesign.vm4brwsr.VarType;
import org.apidesign.vm4brwsr.Variable;

class LoopCode
implements Runnable {
    private final Appendable out;
    private final ByteCodeToJavaScript byteCodeToJavaScript;
    private final NumberOperations numbers;
    private final ByteCodeParser.ClassData jc;
    private boolean modified;

    LoopCode(ByteCodeToJavaScript b, Appendable out, NumberOperations numbers, ByteCodeParser.ClassData jc) {
        this.out = new TrackingAppendable(out, this);
        this.jc = jc;
        this.numbers = numbers;
        this.byteCodeToJavaScript = b;
    }

    @Override
    public void run() {
        this.modified = true;
    }

    void loopCode(ByteCodeParser.StackMapIterator stackMapIterator, byte[] byteCodes, ByteCodeParser.TrapDataIterator trap, StackMapper smapper, LocalsMapper lmapper) throws IllegalStateException, NumberFormatException, IOException {
        int lastStackFrame;
        boolean didBranches;
        ByteCodeParser.TrapData[] previousTrap = null;
        boolean wide = false;
        if (stackMapIterator.isEmpty()) {
            didBranches = false;
            lastStackFrame = 0;
        } else {
            didBranches = true;
            lastStackFrame = -1;
            this.out.append("\n  var gt = 0;\n");
        }
        int openBraces = 0;
        int topMostLabel = 0;
        for (int i = 0; i < byteCodes.length; ++i) {
            int c;
            int prev = i;
            this.modified = false;
            stackMapIterator.advanceTo(i);
            boolean changeInCatch = trap.advanceTo(i);
            if ((changeInCatch || lastStackFrame != stackMapIterator.getFrameIndex()) && previousTrap != null) {
                this.byteCodeToJavaScript.generateCatch(this.out, previousTrap, i, topMostLabel);
                previousTrap = null;
            }
            if (lastStackFrame != stackMapIterator.getFrameIndex()) {
                smapper.flush(this.out);
                if (i != 0) {
                    this.out.append("    }\n");
                }
                if (openBraces > 64) {
                    for (c = 0; c < 64; ++c) {
                        this.out.append("break;}\n");
                    }
                    openBraces = 1;
                    topMostLabel = i;
                }
                lastStackFrame = stackMapIterator.getFrameIndex();
                lmapper.syncWithFrameLocals(stackMapIterator.getFrameLocals());
                smapper.syncWithFrameStack(stackMapIterator.getFrameStack());
                this.out.append("    X_" + i).append(": for (;;) { IF: if (gt <= " + i + ") {\n");
                ++openBraces;
                changeInCatch = true;
            } else {
                this.byteCodeToJavaScript.debug(this.out, "    /* " + i + " */ ");
            }
            if (changeInCatch && trap.useTry()) {
                this.out.append("try {");
                previousTrap = trap.current();
            }
            c = ByteCodeToJavaScript.readUByte(byteCodes, i);
            switch (c) {
                case 0: {
                    break;
                }
                case 42: {
                    smapper.assign(this.out, 4, lmapper.getA(0));
                    break;
                }
                case 26: {
                    smapper.assign(this.out, 0, lmapper.getI(0));
                    break;
                }
                case 30: {
                    smapper.assign(this.out, 1, lmapper.getL(0));
                    break;
                }
                case 34: {
                    smapper.assign(this.out, 2, lmapper.getF(0));
                    break;
                }
                case 38: {
                    smapper.assign(this.out, 3, lmapper.getD(0));
                    break;
                }
                case 43: {
                    smapper.assign(this.out, 4, lmapper.getA(1));
                    break;
                }
                case 27: {
                    smapper.assign(this.out, 0, lmapper.getI(1));
                    break;
                }
                case 31: {
                    smapper.assign(this.out, 1, lmapper.getL(1));
                    break;
                }
                case 35: {
                    smapper.assign(this.out, 2, lmapper.getF(1));
                    break;
                }
                case 39: {
                    smapper.assign(this.out, 3, lmapper.getD(1));
                    break;
                }
                case 44: {
                    smapper.assign(this.out, 4, lmapper.getA(2));
                    break;
                }
                case 28: {
                    smapper.assign(this.out, 0, lmapper.getI(2));
                    break;
                }
                case 32: {
                    smapper.assign(this.out, 1, lmapper.getL(2));
                    break;
                }
                case 36: {
                    smapper.assign(this.out, 2, lmapper.getF(2));
                    break;
                }
                case 40: {
                    smapper.assign(this.out, 3, lmapper.getD(2));
                    break;
                }
                case 45: {
                    smapper.assign(this.out, 4, lmapper.getA(3));
                    break;
                }
                case 29: {
                    smapper.assign(this.out, 0, lmapper.getI(3));
                    break;
                }
                case 33: {
                    smapper.assign(this.out, 1, lmapper.getL(3));
                    break;
                }
                case 37: {
                    smapper.assign(this.out, 2, lmapper.getF(3));
                    break;
                }
                case 41: {
                    smapper.assign(this.out, 3, lmapper.getD(3));
                    break;
                }
                case 21: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this.out, 0, lmapper.getI(indx));
                    break;
                }
                case 22: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this.out, 1, lmapper.getL(indx));
                    break;
                }
                case 23: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this.out, 2, lmapper.getF(indx));
                    break;
                }
                case 24: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this.out, 3, lmapper.getD(indx));
                    break;
                }
                case 25: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this.out, 4, lmapper.getA(indx));
                    break;
                }
                case 54: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setI(indx), smapper.popI());
                    break;
                }
                case 55: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setL(indx), smapper.popL());
                    break;
                }
                case 56: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setF(indx), smapper.popF());
                    break;
                }
                case 57: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setD(indx), smapper.popD());
                    break;
                }
                case 58: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setA(indx), smapper.popA());
                    break;
                }
                case 75: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setA(0), smapper.popA());
                    break;
                }
                case 59: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setI(0), smapper.popI());
                    break;
                }
                case 63: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setL(0), smapper.popL());
                    break;
                }
                case 67: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setF(0), smapper.popF());
                    break;
                }
                case 71: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setD(0), smapper.popD());
                    break;
                }
                case 76: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setA(1), smapper.popA());
                    break;
                }
                case 60: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setI(1), smapper.popI());
                    break;
                }
                case 64: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setL(1), smapper.popL());
                    break;
                }
                case 68: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setF(1), smapper.popF());
                    break;
                }
                case 72: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setD(1), smapper.popD());
                    break;
                }
                case 77: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setA(2), smapper.popA());
                    break;
                }
                case 61: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setI(2), smapper.popI());
                    break;
                }
                case 65: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setL(2), smapper.popL());
                    break;
                }
                case 69: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setF(2), smapper.popF());
                    break;
                }
                case 73: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setD(2), smapper.popD());
                    break;
                }
                case 78: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setA(3), smapper.popA());
                    break;
                }
                case 62: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setI(3), smapper.popI());
                    break;
                }
                case 66: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setL(3), smapper.popL());
                    break;
                }
                case 70: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setF(3), smapper.popF());
                    break;
                }
                case 74: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", lmapper.setD(3), smapper.popD());
                    break;
                }
                case 96: {
                    smapper.replace(this.out, 0, "(((@1) + (@2)) | 0)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 97: {
                    smapper.replace(this.out, 1, this.numbers.add64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 98: {
                    smapper.replace(this.out, 2, "(@1 + @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 99: {
                    smapper.replace(this.out, 3, "(@1 + @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 100: {
                    smapper.replace(this.out, 0, "(((@1) - (@2)) | 0)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 101: {
                    smapper.replace(this.out, 1, this.numbers.sub64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 102: {
                    smapper.replace(this.out, 2, "(@1 - @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 103: {
                    smapper.replace(this.out, 3, "(@1 - @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 104: {
                    smapper.replace(this.out, 0, this.numbers.mul32(), smapper.getI(1), smapper.popI());
                    break;
                }
                case 105: {
                    smapper.replace(this.out, 1, this.numbers.mul64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 106: {
                    smapper.replace(this.out, 2, "(@1 * @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 107: {
                    smapper.replace(this.out, 3, "(@1 * @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 108: {
                    smapper.replace(this.out, 0, this.numbers.div32(), smapper.getI(1), smapper.popI());
                    break;
                }
                case 109: {
                    smapper.replace(this.out, 1, this.numbers.div64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 110: {
                    smapper.replace(this.out, 2, "(@1 / @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 111: {
                    smapper.replace(this.out, 3, "(@1 / @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 112: {
                    smapper.replace(this.out, 0, this.numbers.mod32(), smapper.getI(1), smapper.popI());
                    break;
                }
                case 113: {
                    smapper.replace(this.out, 1, this.numbers.mod64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 114: {
                    smapper.replace(this.out, 2, "(@1 % @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 115: {
                    smapper.replace(this.out, 3, "(@1 % @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 126: {
                    smapper.replace(this.out, 0, "(@1 & @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 127: {
                    smapper.replace(this.out, 1, this.numbers.and64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 128: {
                    smapper.replace(this.out, 0, "(@1 | @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 129: {
                    smapper.replace(this.out, 1, this.numbers.or64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 130: {
                    smapper.replace(this.out, 0, "(@1 ^ @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 131: {
                    smapper.replace(this.out, 1, this.numbers.xor64(), smapper.getL(1), smapper.popL());
                    break;
                }
                case 116: {
                    smapper.replace(this.out, 0, "(-(@1) | 0)", smapper.getI(0));
                    break;
                }
                case 117: {
                    smapper.replace(this.out, 1, this.numbers.neg64(), smapper.getL(0));
                    break;
                }
                case 118: {
                    smapper.replace(this.out, 2, "(-@1)", smapper.getF(0));
                    break;
                }
                case 119: {
                    smapper.replace(this.out, 3, "(-@1)", smapper.getD(0));
                    break;
                }
                case 120: {
                    smapper.replace(this.out, 0, "(@1 << @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 121: {
                    smapper.replace(this.out, 1, this.numbers.shl64(), smapper.getL(1), smapper.popI());
                    break;
                }
                case 122: {
                    smapper.replace(this.out, 0, "(@1 >> @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 123: {
                    smapper.replace(this.out, 1, this.numbers.shr64(), smapper.getL(1), smapper.popI());
                    break;
                }
                case 124: {
                    smapper.replace(this.out, 0, "(@1 >>> @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 125: {
                    smapper.replace(this.out, 1, this.numbers.ushr64(), smapper.getL(1), smapper.popI());
                    break;
                }
                case 132: {
                    ++i;
                    int varIndx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    ++i;
                    int incrBy = wide ? ByteCodeToJavaScript.readShort(byteCodes, i++) : byteCodes[i];
                    wide = false;
                    if (incrBy == 1) {
                        ByteCodeToJavaScript.emit(this.out, smapper, "@1++;", lmapper.getI(varIndx));
                        break;
                    }
                    ByteCodeToJavaScript.emit(this.out, smapper, "@1 += @2;", lmapper.getI(varIndx), Integer.toString(incrBy));
                    break;
                }
                case 177: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "return;", new CharSequence[0]);
                    break;
                }
                case 172: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "return @1;", smapper.popI());
                    break;
                }
                case 173: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "return @1;", smapper.popL());
                    break;
                }
                case 174: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "return @1;", smapper.popF());
                    break;
                }
                case 175: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "return @1;", smapper.popD());
                    break;
                }
                case 176: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "return @1;", smapper.popA());
                    break;
                }
                case 133: {
                    smapper.replace(this.out, 1, "(@1).toLong()", smapper.getI(0));
                    break;
                }
                case 134: {
                    smapper.replace(this.out, 2, "@1", smapper.getI(0));
                    break;
                }
                case 135: {
                    smapper.replace(this.out, 3, "@1", smapper.getI(0));
                    break;
                }
                case 136: {
                    smapper.replace(this.out, 0, "((@1) | 0)", smapper.getL(0));
                    break;
                }
                case 137: {
                    smapper.replace(this.out, 2, this.numbers.toFP(), smapper.getL(0));
                    break;
                }
                case 138: {
                    smapper.replace(this.out, 3, this.numbers.toFP(), smapper.getL(0));
                    break;
                }
                case 141: {
                    smapper.replace(this.out, 3, "@1", smapper.getF(0));
                    break;
                }
                case 144: {
                    smapper.replace(this.out, 2, "@1", smapper.getD(0));
                    break;
                }
                case 139: {
                    smapper.replace(this.out, 0, "((@1) | 0)", smapper.getF(0));
                    break;
                }
                case 140: {
                    smapper.replace(this.out, 1, "(@1).toLong()", smapper.getF(0));
                    break;
                }
                case 142: {
                    smapper.replace(this.out, 0, "((@1)| 0)", smapper.getD(0));
                    break;
                }
                case 143: {
                    smapper.replace(this.out, 1, "(@1).toLong()", smapper.getD(0));
                    break;
                }
                case 145: {
                    smapper.replace(this.out, 0, "(((@1) << 24) >> 24)", smapper.getI(0));
                    break;
                }
                case 146: 
                case 147: {
                    smapper.replace(this.out, 0, "(((@1) << 16) >> 16)", smapper.getI(0));
                    break;
                }
                case 1: {
                    smapper.assign(this.out, 4, "null");
                    break;
                }
                case 2: {
                    smapper.assign(this.out, 0, "-1");
                    break;
                }
                case 3: {
                    smapper.assign(this.out, 0, "0");
                    break;
                }
                case 14: {
                    smapper.assign(this.out, 3, "0");
                    break;
                }
                case 9: {
                    smapper.assign(this.out, 1, "(0).toLong()");
                    break;
                }
                case 11: {
                    smapper.assign(this.out, 2, "0");
                    break;
                }
                case 4: {
                    smapper.assign(this.out, 0, "1");
                    break;
                }
                case 10: {
                    smapper.assign(this.out, 1, "1");
                    break;
                }
                case 12: {
                    smapper.assign(this.out, 2, "1");
                    break;
                }
                case 15: {
                    smapper.assign(this.out, 3, "1");
                    break;
                }
                case 5: {
                    smapper.assign(this.out, 0, "2");
                    break;
                }
                case 13: {
                    smapper.assign(this.out, 2, "2");
                    break;
                }
                case 6: {
                    smapper.assign(this.out, 0, "3");
                    break;
                }
                case 7: {
                    smapper.assign(this.out, 0, "4");
                    break;
                }
                case 8: {
                    smapper.assign(this.out, 0, "5");
                    break;
                }
                case 18: {
                    int indx = ByteCodeToJavaScript.readUByte(byteCodes, ++i);
                    String v = this.byteCodeToJavaScript.encodeConstant(this.out, indx);
                    int type = VarType.fromConstantType(this.jc.getTag(indx));
                    smapper.assign(this.out, type, v);
                    break;
                }
                case 19: 
                case 20: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    i += 2;
                    String v = this.byteCodeToJavaScript.encodeConstant(this.out, indx);
                    int type = VarType.fromConstantType(this.jc.getTag(indx));
                    if (type == 1) {
                        Long lv = new Long(v);
                        int low = (int)(lv & 0xFFFFFFFFFFFFFFFFL);
                        int hi = (int)(lv >> 32);
                        if (hi == 0) {
                            smapper.assign(this.out, 1, "0x" + Integer.toHexString(low) + ".toLong()");
                            break;
                        }
                        smapper.assign(this.out, 1, "0x" + Integer.toHexString(hi) + ".next32(0x" + Integer.toHexString(low) + ")");
                        break;
                    }
                    smapper.assign(this.out, type, v);
                    break;
                }
                case 148: {
                    smapper.replace(this.out, 0, this.numbers.compare64(), smapper.popL(), smapper.getL(0));
                    break;
                }
                case 149: 
                case 150: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @3 = (@2 == @1) ? 0 : ((@2 < @1) ? -1 : 1);", smapper.popF(), smapper.popF(), smapper.pushI());
                    break;
                }
                case 151: 
                case 152: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @3 = (@2 == @1) ? 0 : ((@2 < @1) ? -1 : 1);", smapper.popD(), smapper.popD(), smapper.pushI());
                    break;
                }
                case 165: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popA(), smapper.popA(), "===", topMostLabel);
                    break;
                }
                case 166: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popA(), smapper.popA(), "!==", topMostLabel);
                    break;
                }
                case 159: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popI(), smapper.popI(), "==", topMostLabel);
                    break;
                }
                case 153: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) == 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 154: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) != 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 155: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) < 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 158: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) <= 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 157: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) > 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 156: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) >= 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 199: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) !== null) ", smapper.popA(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 198: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(this.out, smapper, "if ((@1) === null) ", smapper.popA(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 160: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popI(), smapper.popI(), "!=", topMostLabel);
                    break;
                }
                case 161: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popI(), smapper.popI(), "<", topMostLabel);
                    break;
                }
                case 164: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popI(), smapper.popI(), "<=", topMostLabel);
                    break;
                }
                case 163: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popI(), smapper.popI(), ">", topMostLabel);
                    break;
                }
                case 162: {
                    i = ByteCodeToJavaScript.generateIf(this.out, smapper, byteCodes, i, smapper.popI(), smapper.popI(), ">=", topMostLabel);
                    break;
                }
                case 167: {
                    smapper.flush(this.out);
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.goTo(this.out, i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 171: {
                    i = this.byteCodeToJavaScript.generateLookupSwitch(this.out, i, byteCodes, smapper, topMostLabel);
                    break;
                }
                case 170: {
                    i = this.byteCodeToJavaScript.generateTableSwitch(this.out, i, byteCodes, smapper, topMostLabel);
                    break;
                }
                case 185: {
                    i = this.invokeVirtualMethod(this.out, byteCodes, i, smapper) + 2;
                    break;
                }
                case 182: {
                    i = this.invokeVirtualMethod(this.out, byteCodes, i, smapper);
                    break;
                }
                case 183: {
                    i = this.invokeStaticMethod(this.out, byteCodes, i, smapper, false);
                    break;
                }
                case 184: {
                    i = this.invokeStaticMethod(this.out, byteCodes, i, smapper, true);
                    break;
                }
                case 186: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    ByteCodeParser.CPX2 c2 = this.jc.getCpoolEntry(indx);
                    ByteCodeParser.BootMethodData bm = this.jc.getBootMethod(c2.cpx1);
                    String[] methodAndType = this.jc.getNameAndType(c2.cpx2);
                    ByteCodeParser.CPX2 methodHandle = this.jc.getCpoolEntry(bm.method);
                    String[] mi = this.jc.getFieldInfoName(methodHandle.cpx2);
                    this.handleIndy(indx, methodAndType, mi, bm, smapper);
                    i += 4;
                    break;
                }
                case 187: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String ci = this.jc.getClassName(indx);
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = new @2;", smapper.pushA(), this.byteCodeToJavaScript.accessClass(ByteCodeToJavaScript.mangleClassName(ci)));
                    this.byteCodeToJavaScript.addReference(this.out, ci);
                    i += 2;
                    break;
                }
                case 188: {
                    int atype = ByteCodeToJavaScript.readUByte(byteCodes, ++i);
                    this.byteCodeToJavaScript.generateNewArray(this.out, atype, smapper);
                    break;
                }
                case 189: {
                    int type = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    i += 2;
                    this.byteCodeToJavaScript.generateANewArray(this.out, type, smapper);
                    break;
                }
                case 197: {
                    int type = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    i += 2;
                    i = this.byteCodeToJavaScript.generateMultiANewArray(this.out, type, byteCodes, i, smapper);
                    break;
                }
                case 190: {
                    smapper.replace(this.out, 0, "(@1).length", smapper.getA(0));
                    break;
                }
                case 80: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "Array.at(@3, @2, @1);", smapper.popL(), smapper.popI(), smapper.popA());
                    break;
                }
                case 81: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "Array.at(@3, @2, @1);", smapper.popF(), smapper.popI(), smapper.popA());
                    break;
                }
                case 82: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "Array.at(@3, @2, @1);", smapper.popD(), smapper.popI(), smapper.popA());
                    break;
                }
                case 83: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "Array.at(@3, @2, @1);", smapper.popA(), smapper.popI(), smapper.popA());
                    break;
                }
                case 79: 
                case 84: 
                case 85: 
                case 86: {
                    ByteCodeToJavaScript.emit(this.out, smapper, "Array.at(@3, @2, @1);", smapper.popI(), smapper.popI(), smapper.popA());
                    break;
                }
                case 47: {
                    smapper.replace(this.out, 1, "(@2[@1] || Array.at(@2, @1))", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 48: {
                    smapper.replace(this.out, 2, "(@2[@1] || Array.at(@2, @1))", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 49: {
                    smapper.replace(this.out, 3, "(@2[@1] || Array.at(@2, @1))", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 50: {
                    smapper.replace(this.out, 4, "(@2[@1] || Array.at(@2, @1))", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 46: 
                case 51: 
                case 52: 
                case 53: {
                    smapper.replace(this.out, 0, "(@2[@1] || Array.at(@2, @1))", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 87: 
                case 88: {
                    smapper.pop(1);
                    this.byteCodeToJavaScript.debug(this.out, "/* pop */");
                    break;
                }
                case 89: {
                    Variable v = smapper.get(0);
                    if (smapper.isDirty()) {
                        ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", smapper.pushT(v.getType()), v);
                        break;
                    }
                    smapper.assign(this.out, v.getType(), v);
                    break;
                }
                case 92: {
                    Variable vi1 = smapper.get(0);
                    if (vi1.isCategory2()) {
                        ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2;", smapper.pushT(vi1.getType()), vi1);
                        break;
                    }
                    Variable vi2 = smapper.get(1);
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4;", smapper.pushT(vi2.getType()), vi2, smapper.pushT(vi1.getType()), vi1);
                    break;
                }
                case 90: {
                    Variable vi1 = smapper.pop(this.out);
                    Variable vi2 = smapper.pop(this.out);
                    Variable vo3 = smapper.pushT(vi1.getType());
                    Variable vo2 = smapper.pushT(vi2.getType());
                    Variable vo1 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6;", vo1, vi1, vo2, vi2, vo3, vo1);
                    break;
                }
                case 93: {
                    Variable vi1 = smapper.pop(this.out);
                    Variable vi2 = smapper.pop(this.out);
                    if (vi1.isCategory2()) {
                        Variable vo3 = smapper.pushT(vi1.getType());
                        Variable vo2 = smapper.pushT(vi2.getType());
                        Variable vo1 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6;", vo1, vi1, vo2, vi2, vo3, vo1);
                        break;
                    }
                    Variable vi3 = smapper.pop(this.out);
                    Variable vo5 = smapper.pushT(vi2.getType());
                    Variable vo4 = smapper.pushT(vi1.getType());
                    Variable vo3 = smapper.pushT(vi3.getType());
                    Variable vo22 = smapper.pushT(vi2.getType());
                    Variable vo12 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6,", vo12, vi1, vo22, vi2, vo3, vi3);
                    ByteCodeToJavaScript.emit(this.out, smapper, " @1 = @2, @3 = @4;", vo4, vo12, vo5, vo22);
                    break;
                }
                case 91: {
                    Variable vi1 = smapper.pop(this.out);
                    Variable vi2 = smapper.pop(this.out);
                    if (vi2.isCategory2()) {
                        Variable vo3 = smapper.pushT(vi1.getType());
                        Variable vo2 = smapper.pushT(vi2.getType());
                        Variable vo1 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6;", vo1, vi1, vo2, vi2, vo3, vo1);
                        break;
                    }
                    Variable vi3 = smapper.pop(this.out);
                    Variable vo4 = smapper.pushT(vi1.getType());
                    Variable vo3 = smapper.pushT(vi3.getType());
                    Variable vo2 = smapper.pushT(vi2.getType());
                    Variable vo1 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6, @7 = @8;", vo1, vi1, vo2, vi2, vo3, vi3, vo4, vo1);
                    break;
                }
                case 94: {
                    Variable vo1;
                    Variable vo2;
                    Variable vo12;
                    Variable vo22;
                    Variable vo3;
                    Variable vi1 = smapper.pop(this.out);
                    Variable vi2 = smapper.pop(this.out);
                    if (vi1.isCategory2()) {
                        if (vi2.isCategory2()) {
                            Variable vo32 = smapper.pushT(vi1.getType());
                            Variable vo23 = smapper.pushT(vi2.getType());
                            Variable vo13 = smapper.pushT(vi1.getType());
                            ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6;", vo13, vi1, vo23, vi2, vo32, vo13);
                            break;
                        }
                        Variable vi3 = smapper.pop(this.out);
                        Variable vo4 = smapper.pushT(vi1.getType());
                        Variable vo33 = smapper.pushT(vi3.getType());
                        vo2 = smapper.pushT(vi2.getType());
                        vo1 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6, @7 = @8;", vo1, vi1, vo2, vi2, vo33, vi3, vo4, vo1);
                        break;
                    }
                    Variable vi3 = smapper.pop(this.out);
                    if (vi3.isCategory2()) {
                        Variable vo5 = smapper.pushT(vi2.getType());
                        Variable vo4 = smapper.pushT(vi1.getType());
                        vo3 = smapper.pushT(vi3.getType());
                        vo22 = smapper.pushT(vi2.getType());
                        vo12 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6,", vo12, vi1, vo22, vi2, vo3, vi3);
                        ByteCodeToJavaScript.emit(this.out, smapper, " @1 = @2, @3 = @4;", vo4, vo12, vo5, vo22);
                        break;
                    }
                    Variable vi4 = smapper.pop(this.out);
                    Variable vo6 = smapper.pushT(vi2.getType());
                    Variable vo5 = smapper.pushT(vi1.getType());
                    Variable vo4 = smapper.pushT(vi4.getType());
                    Variable vo34 = smapper.pushT(vi3.getType());
                    Variable vo24 = smapper.pushT(vi2.getType());
                    Variable vo14 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @3 = @4, @5 = @6, @7 = @8,", vo14, vi1, vo24, vi2, vo34, vi3, vo4, vi4);
                    ByteCodeToJavaScript.emit(this.out, smapper, " @1 = @2, @3 = @4;", vo5, vo14, vo6, vo24);
                    break;
                }
                case 95: {
                    Variable vi1 = smapper.get(0);
                    Variable vi2 = smapper.get(1);
                    Variable tmp = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(this.out, smapper, "var @1 = @2, @2 = @3, @3 = @1;", tmp, vi1, vi2);
                    smapper.pop(1);
                    break;
                }
                case 16: {
                    smapper.assign(this.out, 0, "(" + Integer.toString(byteCodes[++i]) + ")");
                    break;
                }
                case 17: {
                    smapper.assign(this.out, 0, "(" + Integer.toString(ByteCodeToJavaScript.readShortArg(byteCodes, i)) + ")");
                    i += 2;
                    break;
                }
                case 180: {
                    String mangleClassAccess;
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    ByteCodeParser.FieldData field = this.byteCodeToJavaScript.findField(fi);
                    if (field == null) {
                        String mangleClass = ByteCodeToJavaScript.mangleClassName(fi[0]);
                        mangleClassAccess = this.byteCodeToJavaScript.accessClassFalse(mangleClass);
                        smapper.replace(this.out, type, "@2.call(@1)", smapper.getA(0), this.byteCodeToJavaScript.accessField(mangleClassAccess, null, fi));
                    } else {
                        String fieldOwner = ByteCodeToJavaScript.mangleClassName(field.cls.getClassName());
                        smapper.replace(this.out, type, "@1@2", smapper.getA(0), this.byteCodeToJavaScript.accessField(fieldOwner, field, fi));
                    }
                    i += 2;
                    this.byteCodeToJavaScript.addReference(this.out, fi[0]);
                    break;
                }
                case 181: {
                    String mangleClassAccess;
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    ByteCodeParser.FieldData field = this.byteCodeToJavaScript.findField(fi);
                    if (field == null) {
                        String mangleClass = ByteCodeToJavaScript.mangleClassName(fi[0]);
                        mangleClassAccess = this.byteCodeToJavaScript.accessClassFalse(mangleClass);
                        ByteCodeToJavaScript.emit(this.out, smapper, "@3.call(@2, @1);", smapper.popT(type), smapper.popA(), this.byteCodeToJavaScript.accessField(mangleClassAccess, null, fi));
                    } else {
                        String fieldOwner = ByteCodeToJavaScript.mangleClassName(field.cls.getClassName());
                        ByteCodeToJavaScript.emit(this.out, smapper, "@2@3 = @1;", smapper.popT(type), smapper.popA(), this.byteCodeToJavaScript.accessField(fieldOwner, field, fi));
                    }
                    i += 2;
                    this.byteCodeToJavaScript.addReference(this.out, fi[0]);
                    break;
                }
                case 178: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    String ac = this.byteCodeToJavaScript.accessClassFalse(ByteCodeToJavaScript.mangleClassName(fi[0]));
                    ByteCodeParser.FieldData field = this.byteCodeToJavaScript.findField(fi);
                    String af = this.byteCodeToJavaScript.accessField(ac, field, fi);
                    smapper.assign(this.out, type, af + "()");
                    i += 2;
                    this.byteCodeToJavaScript.addReference(this.out, fi[0]);
                    break;
                }
                case 179: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    ByteCodeToJavaScript.emit(this.out, smapper, "@1._@2(@3);", this.byteCodeToJavaScript.accessClassFalse(ByteCodeToJavaScript.mangleClassName(fi[0])), fi[1], smapper.popT(type));
                    i += 2;
                    this.byteCodeToJavaScript.addReference(this.out, fi[0]);
                    break;
                }
                case 192: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    this.byteCodeToJavaScript.generateCheckcast(this.out, indx, smapper);
                    i += 2;
                    break;
                }
                case 193: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    this.byteCodeToJavaScript.generateInstanceOf(this.out, indx, smapper);
                    i += 2;
                    break;
                }
                case 191: {
                    CharSequence v = smapper.popA();
                    smapper.clear();
                    ByteCodeToJavaScript.emit(this.out, smapper, "{ var @1 = @2; throw @2; }", smapper.pushA(), v);
                    break;
                }
                case 194: {
                    this.byteCodeToJavaScript.debug(null, "/* monitor enter */");
                    smapper.popA();
                    break;
                }
                case 195: {
                    this.byteCodeToJavaScript.debug(null, "/* monitor exit */");
                    smapper.popA();
                    break;
                }
                case 196: {
                    wide = true;
                    break;
                }
                default: {
                    wide = false;
                    ByteCodeToJavaScript.emit(this.out, smapper, "throw 'unknown bytecode @1';", Integer.toString(c));
                }
            }
            if (this.byteCodeToJavaScript.debug(this.out, " //")) {
                this.byteCodeToJavaScript.generateByteCodeComment(this.out, prev, i, byteCodes);
            }
            if (!this.modified) continue;
            this.out.append("\n");
        }
        if (previousTrap != null) {
            this.byteCodeToJavaScript.generateCatch(this.out, previousTrap, byteCodes.length, topMostLabel);
        }
        if (didBranches) {
            this.out.append("\n    }\n");
        }
        while (openBraces-- > 0) {
            this.out.append('}');
        }
    }

    private void handleIndy(int indx, String[] methodAndType, String[] mi, ByteCodeParser.BootMethodData bm, StackMapper mapper) throws IOException {
        for (IndyHandler h : this.byteCodeToJavaScript.getIndyHandlers()) {
            IndyHandler.Ctx ctx;
            if (!h.factoryClazz.equals(mi[0]) || !h.factoryMethod.equals(mi[1]) || !h.handle(ctx = new IndyHandler.Ctx(this.out, mapper, this.byteCodeToJavaScript, methodAndType, bm))) continue;
            return;
        }
        char[] returnType = new char[]{'V'};
        StringBuilder cnt = new StringBuilder();
        String mn = ByteCodeToJavaScript.findMethodName(mi, cnt, returnType);
        StringBuilder sb = new StringBuilder();
        sb.append("No invokedynamic handler for: ").append(mi[0]).append('.').append(mi[1]).append(mi[2]);
        sb.append("to call ").append(methodAndType[1]).append(".").append(methodAndType[0]);
        this.out.append("\n    throw '").append(sb.toString().replace('\'', ' ').replace("\n", "\\n")).append("';\n");
        String sig = methodAndType[1].substring(methodAndType[1].lastIndexOf(41) + 1);
        int type = VarType.fromFieldType(sig.charAt(0));
        mapper.pushT(type);
    }

    int invokeVirtualMethod(Appendable out, byte[] byteCodes, int i, StackMapper mapper) throws IOException {
        int methodIndex = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
        String[] mi = this.jc.getFieldInfoName(methodIndex);
        char[] returnType = new char[]{'V'};
        StringBuilder cnt = new StringBuilder();
        String mn = ByteCodeToJavaScript.findMethodName(mi, cnt, returnType);
        int numArguments = cnt.length() + 1;
        CharSequence[] vars = new CharSequence[numArguments];
        for (int j = numArguments - 1; j >= 0; --j) {
            vars[j] = mapper.popValue();
        }
        if (returnType[0] != 'V') {
            mapper.flush(out);
            out.append("var ").append(mapper.pushT(VarType.fromFieldType(returnType[0]))).append(" = ");
        }
        boolean callbacksFinished = this.beginCall(mi, vars, false);
        String[] sep = new String[]{""};
        out.append(this.byteCodeToJavaScript.accessVirtualMethod(this.jc, vars[0].toString(), mn, mi, numArguments, sep));
        for (int j = 1; j < numArguments; ++j) {
            out.append(sep[0]);
            out.append(vars[j]);
            sep[0] = ", ";
        }
        out.append(");");
        this.endCall(callbacksFinished);
        return i += 2;
    }

    int invokeStaticMethod(Appendable out, byte[] byteCodes, int i, StackMapper mapper, boolean isStatic) throws IOException {
        String field;
        int methodIndex = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
        String[] mi = this.jc.getFieldInfoName(methodIndex);
        char[] returnType = new char[]{'V'};
        StringBuilder cnt = new StringBuilder();
        String mn = ByteCodeToJavaScript.findMethodName(mi, cnt, returnType);
        int numArguments = isStatic ? cnt.length() : cnt.length() + 1;
        CharSequence[] vars = new CharSequence[numArguments];
        for (int j = numArguments - 1; j >= 0; --j) {
            vars[j] = mapper.popValue();
        }
        if ("java/lang/Object".equals(mi[0]) && "<init>".equals(mi[1])) {
            return i + 2;
        }
        if (("newUpdater__Ljava_util_concurrent_atomic_AtomicIntegerFieldUpdater_2Ljava_lang_Class_2Ljava_lang_String_2".equals(mn) && "java/util/concurrent/atomic/AtomicIntegerFieldUpdater".equals(mi[0]) || "newUpdater__Ljava_util_concurrent_atomic_AtomicLongFieldUpdater_2Ljava_lang_Class_2Ljava_lang_String_2".equals(mn) && "java/util/concurrent/atomic/AtomicLongFieldUpdater".equals(mi[0])) && vars[1] instanceof String && (field = vars[1].toString()).length() > 2 && field.charAt(0) == '\"' && field.charAt(field.length() - 1) == '\"') {
            vars[1] = "c._" + field.substring(1, field.length() - 1);
        }
        if ("newUpdater__Ljava_util_concurrent_atomic_AtomicReferenceFieldUpdater_2Ljava_lang_Class_2Ljava_lang_Class_2Ljava_lang_String_2".equals(mn) && "java/util/concurrent/atomic/AtomicReferenceFieldUpdater".equals(mi[0]) && vars[1] instanceof String && (field = vars[2].toString()).length() > 2 && field.charAt(0) == '\"' && field.charAt(field.length() - 1) == '\"') {
            vars[2] = "c._" + field.substring(1, field.length() - 1);
        }
        if (returnType[0] != 'V') {
            mapper.flush(out);
            out.append("var ").append(mapper.pushT(VarType.fromFieldType(returnType[0]))).append(" = ");
        }
        boolean callbacksFinished = this.beginCall(mi, vars, true);
        String in = mi[0];
        String mcn = ByteCodeToJavaScript.mangleClassName(in);
        String object = this.byteCodeToJavaScript.accessClassFalse(mcn);
        if (mn.startsWith("cons_")) {
            object = object + ".constructor";
        }
        out.append(this.byteCodeToJavaScript.accessStaticMethod(object, mn, mi));
        if (isStatic) {
            out.append('(');
        } else {
            out.append(".call(");
        }
        if (numArguments > 0) {
            out.append(vars[0]);
            for (int j = 1; j < numArguments; ++j) {
                out.append(", ");
                out.append(vars[j]);
            }
        }
        out.append(");");
        this.endCall(callbacksFinished);
        this.byteCodeToJavaScript.addReference(out, in);
        return i += 2;
    }

    protected boolean beginCall(String[] mi, CharSequence[] vars, boolean isStatic) throws IOException {
        return false;
    }

    protected void endCall(boolean callbacksFinished) throws IOException {
    }
}

