/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apidesign.bck2brwsr.core.ExtraJavaScript;
import org.apidesign.vm4brwsr.Bck2Brwsr;
import org.apidesign.vm4brwsr.LdrRsrcs;
import org.apidesign.vm4brwsr.ObfuscationLevel;
import org.apidesign.vm4brwsr.StringArray;

@ExtraJavaScript(processByteCode=false, resource="")
final class Main {
    private Main() {
    }

    public static void main(String ... args) throws IOException, URISyntaxException {
        String obfuscate = "--obfuscatelevel";
        String extension = "--createextension";
        if (args.length < 2) {
            System.err.println("Bck2Brwsr Translator from Java(tm) to JavaScript, (c) Jaroslav Tulach 2012");
            System.err.print("Usage: java -cp ... -jar ... [");
            System.err.print("--obfuscatelevel");
            System.err.print(" [");
            boolean first = true;
            for (ObfuscationLevel l : ObfuscationLevel.values()) {
                if (!first) {
                    System.err.print('|');
                }
                System.err.print(l.name());
                first = false;
            }
            System.err.print("]] [");
            System.err.print("--createextension");
            System.err.println("] <file_to_generate_js_code_to> java/lang/Class org/your/App ...");
            System.exit(9);
        }
        ClassLoader mainClassLoader = Main.class.getClassLoader();
        ObfuscationLevel obfLevel = ObfuscationLevel.NONE;
        boolean createExtension = false;
        StringArray classes = new StringArray();
        String generateTo = null;
        for (int i = 0; i < args.length; ++i) {
            if ("--obfuscatelevel".equals(args[i])) {
                ++i;
                try {
                    obfLevel = ObfuscationLevel.valueOf(args[i]);
                }
                catch (Exception e) {
                    System.err.print("--obfuscatelevel");
                    System.err.print(" parameter needs to be followed by one of ");
                    boolean first = true;
                    for (ObfuscationLevel l : ObfuscationLevel.values()) {
                        if (!first) {
                            System.err.print(", ");
                        }
                        System.err.print(l.name());
                        first = false;
                    }
                    System.err.println();
                    System.exit(1);
                }
                continue;
            }
            if ("--createextension".equals(args[i])) {
                createExtension = true;
                continue;
            }
            if (generateTo == null) {
                generateTo = args[i];
                continue;
            }
            Main.collectClasses(classes, mainClassLoader, args[i]);
        }
        File gt = new File(generateTo);
        if (Boolean.getBoolean("skip.if.exists") && gt.isFile()) {
            System.err.println("Skipping as " + gt + " exists.");
            System.exit(0);
        }
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(gt), "UTF-8"));){
            Bck2Brwsr c = Bck2Brwsr.newCompiler().obfuscation(obfLevel).addRootClasses(classes.toArray()).resources(new LdrRsrcs(Main.class.getClassLoader(), true));
            if (createExtension) {
                c = c.library(new String[0]);
            }
            c.generate(w);
        }
    }

    private static void collectClasses(StringArray dest, ClassLoader cl, String relativePath) throws IOException, URISyntaxException {
        Enumeration<URL> urls = cl.getResources(relativePath);
        if (!urls.hasMoreElements()) {
            dest.add(relativePath);
            return;
        }
        block13: do {
            URL url = urls.nextElement();
            switch (url.getProtocol()) {
                case "file": {
                    Main.collectClasses(dest, relativePath, new File(new URI(url.toString())));
                    break;
                }
                case "jar": {
                    String fullPath = url.getPath();
                    int sepIndex = fullPath.indexOf(33);
                    String jarFilePath = sepIndex != -1 ? fullPath.substring(0, sepIndex) : fullPath;
                    URI jarUri = new URI(jarFilePath);
                    if (jarUri.getScheme().equals("file")) {
                        try (JarFile jarFile = new JarFile(new File(jarUri));){
                            Main.collectClasses(dest, relativePath, jarFile);
                            continue block13;
                        }
                    }
                }
                default: {
                    dest.add(relativePath);
                }
            }
        } while (urls.hasMoreElements());
    }

    private static void collectClasses(StringArray dest, String relativePath, File file) {
        if (file.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = file.listFiles()) {
                Main.collectClasses(dest, Main.extendPath(relativePath, subFile.getName()), subFile);
            }
            return;
        }
        String filePath = file.getPath();
        if (filePath.endsWith(".class")) {
            Main.validateAndAddClass(dest, relativePath);
        }
    }

    private static void collectClasses(StringArray dest, String relativePath, JarFile jarFile) {
        if (relativePath.endsWith(".class")) {
            if (jarFile.getJarEntry(relativePath) != null) {
                Main.validateAndAddClass(dest, relativePath);
            }
            return;
        }
        String expectedPrefix = relativePath.endsWith("/") ? relativePath : relativePath + '/';
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(expectedPrefix) || !entryName.endsWith(".class")) continue;
            Main.validateAndAddClass(dest, entryName);
        }
    }

    private static String extendPath(String relativePath, String fileName) {
        return relativePath.endsWith("/") ? relativePath + fileName : relativePath + '/' + fileName;
    }

    private static void validateAndAddClass(StringArray dest, String relativePath) {
        String className = relativePath.substring(0, relativePath.length() - 6);
        dest.add(className);
    }
}

