/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import org.apidesign.vm4brwsr.ByteCodeToJavaScript;
import org.apidesign.vm4brwsr.IndyHandler;
import org.apidesign.vm4brwsr.Variable;

final class StringConcatHandler
extends IndyHandler {
    StringConcatHandler() {
        super("java/lang/invoke/StringConcatFactory", "makeConcatWithConstants");
    }

    @Override
    protected boolean handle(IndyHandler.Ctx ctx) throws IOException {
        String recipe = ctx.bm.clazz.StringValue(ctx.bm.args[0]);
        String sig = ctx.mt[1];
        StringBuilder sigB = new StringBuilder();
        StringBuilder cnt = new StringBuilder();
        char[] returnType = new char[]{'V'};
        ByteCodeToJavaScript.countArgs(sig, returnType, sigB, cnt);
        assert (returnType[0] == 'L');
        int fixedArgsCount = cnt.length();
        CharSequence[] vars = new CharSequence[fixedArgsCount];
        for (int j = fixedArgsCount - 1; j >= 0; --j) {
            vars[j] = ctx.stackMapper.popValue();
        }
        ctx.stackMapper.flush(ctx.out);
        Variable stringVar = ctx.stackMapper.pushA();
        ctx.out.append("\nvar ").append(stringVar).append(" = ");
        StringBuilder sep = new StringBuilder();
        sep.append("'");
        int atVar = 0;
        block10: for (int j = 0; j < recipe.length(); ++j) {
            char ch = recipe.charAt(j);
            switch (ch) {
                case '\u0001': {
                    ctx.out.append(sep).append("' + ");
                    ctx.out.append(vars[atVar++]);
                    sep = new StringBuilder(" + '");
                    continue block10;
                }
                case '\u0002': {
                    throw new IllegalStateException("#2 stackvalue not supported yet");
                }
                case '\n': {
                    sep.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sep.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sep.append("\\t");
                    continue block10;
                }
                case '\'': {
                    sep.append("\\'");
                    continue block10;
                }
                case '\\': {
                    sep.append("\\\\");
                    continue block10;
                }
                default: {
                    if (ch < ' ') {
                        String four = "0000" + Integer.toHexString(ch);
                        sep.append("\\u").append(four.substring(four.length() - 4));
                        continue block10;
                    }
                    sep.append(ch);
                }
            }
        }
        ctx.out.append(sep).append("';");
        return true;
    }
}

