/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.core.JavaScriptPrototype;
import org.apidesign.vm4brwsr.VarType;

final class ByteCodeParser {
    public static final int JAVA_MAGIC = -889275714;
    public static final int JAVA_VERSION = 45;
    public static final int JAVA_MINOR_VERSION = 3;
    public static final int CONSTANT_UTF8 = 1;
    public static final int CONSTANT_UNICODE = 2;
    public static final int CONSTANT_INTEGER = 3;
    public static final int CONSTANT_FLOAT = 4;
    public static final int CONSTANT_LONG = 5;
    public static final int CONSTANT_DOUBLE = 6;
    public static final int CONSTANT_CLASS = 7;
    public static final int CONSTANT_STRING = 8;
    public static final int CONSTANT_FIELD = 9;
    public static final int CONSTANT_METHOD = 10;
    public static final int CONSTANT_INTERFACEMETHOD = 11;
    public static final int CONSTANT_NAMEANDTYPE = 12;
    public static final int CONSTANT_METHODHANDLE = 15;
    public static final int CONSTANT_METHODTYPE = 16;
    public static final int CONSTANT_INVOKEDYNAMIC = 18;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_SUPER = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_EXPLICIT = 4096;
    public static final int ACC_SYNTHETIC = 65536;
    private static final int ACC_ANNOTATION = 131072;
    public static final int ITEM_Bogus = 0;
    public static final int ITEM_Integer = 1;
    public static final int ITEM_Float = 2;
    public static final int ITEM_Double = 3;
    public static final int ITEM_Long = 4;
    public static final int ITEM_Null = 5;
    public static final int ITEM_InitObject = 6;
    public static final int ITEM_Object = 7;
    public static final int ITEM_NewObject = 8;
    public static final int SAME_FRAME_BOUND = 64;
    public static final int SAME_LOCALS_1_STACK_ITEM_BOUND = 128;
    public static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    public static final int SAME_FRAME_EXTENDED = 251;
    public static final int FULL_FRAME = 255;
    public static final int opc_dead = -2;
    public static final int opc_label = -1;
    public static final int opc_nop = 0;
    public static final int opc_aconst_null = 1;
    public static final int opc_iconst_m1 = 2;
    public static final int opc_iconst_0 = 3;
    public static final int opc_iconst_1 = 4;
    public static final int opc_iconst_2 = 5;
    public static final int opc_iconst_3 = 6;
    public static final int opc_iconst_4 = 7;
    public static final int opc_iconst_5 = 8;
    public static final int opc_lconst_0 = 9;
    public static final int opc_lconst_1 = 10;
    public static final int opc_fconst_0 = 11;
    public static final int opc_fconst_1 = 12;
    public static final int opc_fconst_2 = 13;
    public static final int opc_dconst_0 = 14;
    public static final int opc_dconst_1 = 15;
    public static final int opc_bipush = 16;
    public static final int opc_sipush = 17;
    public static final int opc_ldc = 18;
    public static final int opc_ldc_w = 19;
    public static final int opc_ldc2_w = 20;
    public static final int opc_iload = 21;
    public static final int opc_lload = 22;
    public static final int opc_fload = 23;
    public static final int opc_dload = 24;
    public static final int opc_aload = 25;
    public static final int opc_iload_0 = 26;
    public static final int opc_iload_1 = 27;
    public static final int opc_iload_2 = 28;
    public static final int opc_iload_3 = 29;
    public static final int opc_lload_0 = 30;
    public static final int opc_lload_1 = 31;
    public static final int opc_lload_2 = 32;
    public static final int opc_lload_3 = 33;
    public static final int opc_fload_0 = 34;
    public static final int opc_fload_1 = 35;
    public static final int opc_fload_2 = 36;
    public static final int opc_fload_3 = 37;
    public static final int opc_dload_0 = 38;
    public static final int opc_dload_1 = 39;
    public static final int opc_dload_2 = 40;
    public static final int opc_dload_3 = 41;
    public static final int opc_aload_0 = 42;
    public static final int opc_aload_1 = 43;
    public static final int opc_aload_2 = 44;
    public static final int opc_aload_3 = 45;
    public static final int opc_iaload = 46;
    public static final int opc_laload = 47;
    public static final int opc_faload = 48;
    public static final int opc_daload = 49;
    public static final int opc_aaload = 50;
    public static final int opc_baload = 51;
    public static final int opc_caload = 52;
    public static final int opc_saload = 53;
    public static final int opc_istore = 54;
    public static final int opc_lstore = 55;
    public static final int opc_fstore = 56;
    public static final int opc_dstore = 57;
    public static final int opc_astore = 58;
    public static final int opc_istore_0 = 59;
    public static final int opc_istore_1 = 60;
    public static final int opc_istore_2 = 61;
    public static final int opc_istore_3 = 62;
    public static final int opc_lstore_0 = 63;
    public static final int opc_lstore_1 = 64;
    public static final int opc_lstore_2 = 65;
    public static final int opc_lstore_3 = 66;
    public static final int opc_fstore_0 = 67;
    public static final int opc_fstore_1 = 68;
    public static final int opc_fstore_2 = 69;
    public static final int opc_fstore_3 = 70;
    public static final int opc_dstore_0 = 71;
    public static final int opc_dstore_1 = 72;
    public static final int opc_dstore_2 = 73;
    public static final int opc_dstore_3 = 74;
    public static final int opc_astore_0 = 75;
    public static final int opc_astore_1 = 76;
    public static final int opc_astore_2 = 77;
    public static final int opc_astore_3 = 78;
    public static final int opc_iastore = 79;
    public static final int opc_lastore = 80;
    public static final int opc_fastore = 81;
    public static final int opc_dastore = 82;
    public static final int opc_aastore = 83;
    public static final int opc_bastore = 84;
    public static final int opc_castore = 85;
    public static final int opc_sastore = 86;
    public static final int opc_pop = 87;
    public static final int opc_pop2 = 88;
    public static final int opc_dup = 89;
    public static final int opc_dup_x1 = 90;
    public static final int opc_dup_x2 = 91;
    public static final int opc_dup2 = 92;
    public static final int opc_dup2_x1 = 93;
    public static final int opc_dup2_x2 = 94;
    public static final int opc_swap = 95;
    public static final int opc_iadd = 96;
    public static final int opc_ladd = 97;
    public static final int opc_fadd = 98;
    public static final int opc_dadd = 99;
    public static final int opc_isub = 100;
    public static final int opc_lsub = 101;
    public static final int opc_fsub = 102;
    public static final int opc_dsub = 103;
    public static final int opc_imul = 104;
    public static final int opc_lmul = 105;
    public static final int opc_fmul = 106;
    public static final int opc_dmul = 107;
    public static final int opc_idiv = 108;
    public static final int opc_ldiv = 109;
    public static final int opc_fdiv = 110;
    public static final int opc_ddiv = 111;
    public static final int opc_irem = 112;
    public static final int opc_lrem = 113;
    public static final int opc_frem = 114;
    public static final int opc_drem = 115;
    public static final int opc_ineg = 116;
    public static final int opc_lneg = 117;
    public static final int opc_fneg = 118;
    public static final int opc_dneg = 119;
    public static final int opc_ishl = 120;
    public static final int opc_lshl = 121;
    public static final int opc_ishr = 122;
    public static final int opc_lshr = 123;
    public static final int opc_iushr = 124;
    public static final int opc_lushr = 125;
    public static final int opc_iand = 126;
    public static final int opc_land = 127;
    public static final int opc_ior = 128;
    public static final int opc_lor = 129;
    public static final int opc_ixor = 130;
    public static final int opc_lxor = 131;
    public static final int opc_iinc = 132;
    public static final int opc_i2l = 133;
    public static final int opc_i2f = 134;
    public static final int opc_i2d = 135;
    public static final int opc_l2i = 136;
    public static final int opc_l2f = 137;
    public static final int opc_l2d = 138;
    public static final int opc_f2i = 139;
    public static final int opc_f2l = 140;
    public static final int opc_f2d = 141;
    public static final int opc_d2i = 142;
    public static final int opc_d2l = 143;
    public static final int opc_d2f = 144;
    public static final int opc_i2b = 145;
    public static final int opc_int2byte = 145;
    public static final int opc_i2c = 146;
    public static final int opc_int2char = 146;
    public static final int opc_i2s = 147;
    public static final int opc_int2short = 147;
    public static final int opc_lcmp = 148;
    public static final int opc_fcmpl = 149;
    public static final int opc_fcmpg = 150;
    public static final int opc_dcmpl = 151;
    public static final int opc_dcmpg = 152;
    public static final int opc_ifeq = 153;
    public static final int opc_ifne = 154;
    public static final int opc_iflt = 155;
    public static final int opc_ifge = 156;
    public static final int opc_ifgt = 157;
    public static final int opc_ifle = 158;
    public static final int opc_if_icmpeq = 159;
    public static final int opc_if_icmpne = 160;
    public static final int opc_if_icmplt = 161;
    public static final int opc_if_icmpge = 162;
    public static final int opc_if_icmpgt = 163;
    public static final int opc_if_icmple = 164;
    public static final int opc_if_acmpeq = 165;
    public static final int opc_if_acmpne = 166;
    public static final int opc_goto = 167;
    public static final int opc_jsr = 168;
    public static final int opc_ret = 169;
    public static final int opc_tableswitch = 170;
    public static final int opc_lookupswitch = 171;
    public static final int opc_ireturn = 172;
    public static final int opc_lreturn = 173;
    public static final int opc_freturn = 174;
    public static final int opc_dreturn = 175;
    public static final int opc_areturn = 176;
    public static final int opc_return = 177;
    public static final int opc_getstatic = 178;
    public static final int opc_putstatic = 179;
    public static final int opc_getfield = 180;
    public static final int opc_putfield = 181;
    public static final int opc_invokevirtual = 182;
    public static final int opc_invokenonvirtual = 183;
    public static final int opc_invokespecial = 183;
    public static final int opc_invokestatic = 184;
    public static final int opc_invokeinterface = 185;
    public static final int opc_invokedynamic = 186;
    public static final int opc_new = 187;
    public static final int opc_newarray = 188;
    public static final int opc_anewarray = 189;
    public static final int opc_arraylength = 190;
    public static final int opc_athrow = 191;
    public static final int opc_checkcast = 192;
    public static final int opc_instanceof = 193;
    public static final int opc_monitorenter = 194;
    public static final int opc_monitorexit = 195;
    public static final int opc_wide = 196;
    public static final int opc_multianewarray = 197;
    public static final int opc_ifnull = 198;
    public static final int opc_ifnonnull = 199;
    public static final int opc_goto_w = 200;
    public static final int opc_jsr_w = 201;
    public static final int opc_bytecode = 203;
    public static final int opc_try = 204;
    public static final int opc_endtry = 205;
    public static final int opc_catch = 206;
    public static final int opc_var = 207;
    public static final int opc_endvar = 208;
    public static final int opc_localsmap = 209;
    public static final int opc_stackmap = 210;
    public static final int opc_nonpriv = 254;
    public static final int opc_priv = 255;

    private ByteCodeParser() {
    }

    @JavaScriptPrototype(prototype="new Array")
    private static final class Vector {
        private Object[] arr;

        Vector() {
        }

        Vector(int i) {
        }

        void add(Object objectType) {
            this.addElement(objectType);
        }

        @JavaScriptBody(args={"obj"}, body="this.push(obj);")
        void addElement(Object obj) {
            int s = this.size();
            this.setSize(s + 1);
            this.setElementAt(obj, s);
        }

        @JavaScriptBody(args={}, body="return this.length;")
        int size() {
            return this.arr == null ? 0 : this.arr.length;
        }

        @JavaScriptBody(args={"newArr"}, body="for (var i = 0; i < this.length; i++) {\n  newArr[i] = this[i];\n}\n")
        void copyInto(Object[] newArr) {
            if (this.arr == null) {
                return;
            }
            int min = Math.min(newArr.length, this.arr.length);
            for (int i = 0; i < min; ++i) {
                newArr[i] = this.arr[i];
            }
        }

        @JavaScriptBody(args={"index"}, body="return this[index];")
        Object elementAt(int index) {
            return this.arr[index];
        }

        private void setSize(int len) {
            Object[] newArr = new Object[len];
            this.copyInto(newArr);
            this.arr = newArr;
        }

        @JavaScriptBody(args={"val", "index"}, body="this[index] = val;")
        void setElementAt(Object val, int index) {
            this.arr[index] = val;
        }
    }

    static final class TypeArray {
        private static final int CAPACITY_INCREMENT = 16;
        private int[] types;
        private int size;

        public TypeArray() {
        }

        public TypeArray(TypeArray initialTypes) {
            this.setAll(initialTypes);
        }

        public void add(int newType) {
            this.ensureCapacity(this.size + 1);
            this.types[this.size++] = newType;
        }

        public void addAll(TypeArray newTypes) {
            this.addAll(newTypes.types, 0, newTypes.size);
        }

        public void addAll(int[] newTypes) {
            this.addAll(newTypes, 0, newTypes.length);
        }

        public void addAll(int[] newTypes, int offset, int count) {
            if (count > 0) {
                this.ensureCapacity(this.size + count);
                this.arraycopy(newTypes, offset, this.types, this.size, count);
                this.size += count;
            }
        }

        public void set(int index, int newType) {
            this.types[index] = newType;
        }

        public void setAll(TypeArray newTypes) {
            this.setAll(newTypes.types, 0, newTypes.size);
        }

        public void setAll(int[] newTypes) {
            this.setAll(newTypes, 0, newTypes.length);
        }

        public void setAll(int[] newTypes, int offset, int count) {
            if (count > 0) {
                this.ensureCapacity(count);
                this.arraycopy(newTypes, offset, this.types, 0, count);
                this.size = count;
            } else {
                this.clear();
            }
        }

        public void setSize(int newSize) {
            if (this.size != newSize) {
                this.ensureCapacity(newSize);
                for (int i = this.size; i < newSize; ++i) {
                    this.types[i] = 0;
                }
                this.size = newSize;
            }
        }

        public void clear() {
            this.size = 0;
        }

        public int getSize() {
            return this.size;
        }

        public int get(int index) {
            return this.types[index];
        }

        public static String typeString(int type) {
            switch (type & 0xFF) {
                case 0: {
                    return "_top_";
                }
                case 1: {
                    return "_int_";
                }
                case 2: {
                    return "_float_";
                }
                case 3: {
                    return "_double_";
                }
                case 4: {
                    return "_long_";
                }
                case 5: {
                    return "_null_";
                }
                case 6: {
                    return "_init_";
                }
                case 7: {
                    return "_object_";
                }
                case 8: {
                    return "_new_";
                }
            }
            throw new IllegalArgumentException("Unknown type");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            String sep = "";
            for (int i = 0; i < this.size; ++i) {
                sb.append(sep).append(VarType.toString(this.types[i] & 0xFF));
                sep = ", ";
            }
            return sb.append(']').toString();
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity == 0 || this.types != null && minCapacity <= this.types.length) {
                return;
            }
            int newCapacity = (minCapacity + 16 - 1) / 16 * 16;
            int[] newTypes = new int[newCapacity];
            if (this.size > 0) {
                this.arraycopy(this.types, 0, newTypes, 0, this.size);
            }
            this.types = newTypes;
        }

        private void arraycopy(int[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos + i];
            }
        }
    }

    static final class TrapDataIterator {
        private final Hashtable exStart = new Hashtable();
        private final Hashtable exStop = new Hashtable();
        private TrapData[] current = new TrapData[10];
        private int currentCount;

        TrapDataIterator(Vector exceptionTable) {
            for (int i = 0; i < exceptionTable.size(); ++i) {
                TrapData td = (TrapData)exceptionTable.elementAt(i);
                TrapDataIterator.put(this.exStart, td.start_pc, td);
                TrapDataIterator.put(this.exStop, td.end_pc, td);
            }
        }

        private static void put(Hashtable h, short key, TrapData td) {
            Short s = key;
            Vector v = (Vector)h.get(s);
            if (v == null) {
                v = new Vector(1);
                h.put(s, v);
            }
            v.add(td);
        }

        private boolean processAll(Hashtable h, Short key, boolean add) {
            boolean change = false;
            Vector v = (Vector)h.get(key);
            if (v != null) {
                int s = v.size();
                for (int i = 0; i < s; ++i) {
                    TrapData td = (TrapData)v.elementAt(i);
                    if (add) {
                        this.add(td);
                        change = true;
                        continue;
                    }
                    this.remove(td);
                    change = true;
                }
            }
            return change;
        }

        public boolean advanceTo(int i) {
            Short s = (short)i;
            boolean ch1 = this.processAll(this.exStart, s, true);
            boolean ch2 = this.processAll(this.exStop, s, false);
            return ch1 || ch2;
        }

        public boolean useTry() {
            return this.currentCount > 0;
        }

        public TrapData[] current() {
            TrapData[] copy = new TrapData[this.currentCount];
            for (int i = 0; i < this.currentCount; ++i) {
                copy[i] = this.current[i];
            }
            return copy;
        }

        private void add(TrapData e) {
            if (this.currentCount == this.current.length) {
                TrapData[] data = new TrapData[this.currentCount * 2];
                for (int i = 0; i < this.currentCount; ++i) {
                    data[i] = this.current[i];
                }
                this.current = data;
            }
            this.current[this.currentCount++] = e;
        }

        private void remove(TrapData e) {
            if (this.currentCount == 0) {
                return;
            }
            int from = 0;
            while (from < this.currentCount && e != this.current[from++]) {
            }
            while (from < this.currentCount) {
                this.current[from - 1] = this.current[from];
                this.current[from] = null;
                ++from;
            }
            --this.currentCount;
        }
    }

    static final class TrapData {
        public final short start_pc;
        public final short end_pc;
        public final short handler_pc;
        public final short catch_cpx;
        final int num;

        TrapData(DataInputStream in, int num) throws IOException {
            this.num = num;
            this.start_pc = in.readShort();
            this.end_pc = in.readShort();
            this.handler_pc = in.readShort();
            this.catch_cpx = in.readShort();
        }

        public String ident() {
            return "t" + this.num;
        }
    }

    private static abstract class StackMapTableData {
        final int frameType;
        int offsetDelta;

        StackMapTableData(int frameType) {
            this.frameType = frameType;
        }

        abstract void applyTo(TypeArray var1, TypeArray var2);

        protected static String toString(String frameType, int offset, int[] localTypes, int[] stackTypes) {
            StringBuilder sb = new StringBuilder(frameType);
            sb.append("(off: +").append(offset);
            if (localTypes != null) {
                sb.append(", locals: ");
                StackMapTableData.appendTypes(sb, localTypes);
            }
            if (stackTypes != null) {
                sb.append(", stack: ");
                StackMapTableData.appendTypes(sb, stackTypes);
            }
            sb.append(')');
            return sb.toString();
        }

        private static void appendTypes(StringBuilder sb, int[] types) {
            sb.append('[');
            if (types.length > 0) {
                sb.append(TypeArray.typeString(types[0]));
                for (int i = 1; i < types.length; ++i) {
                    sb.append(", ");
                    sb.append(TypeArray.typeString(types[i]));
                }
            }
            sb.append(']');
        }

        static StackMapTableData getInstance(DataInputStream in, MethodData method) throws IOException {
            int frameType = in.readUnsignedByte();
            if (frameType < 64) {
                return new SameFrame(frameType, frameType);
            }
            if (64 <= frameType && frameType < 128) {
                return new SameLocals1StackItem(frameType, frameType - 64, StackMapData.readTypeArray(in, 1, method));
            }
            if (frameType == 247) {
                return new SameLocals1StackItem(frameType, in.readUnsignedShort(), StackMapData.readTypeArray(in, 1, method));
            }
            if (247 < frameType && frameType < 251) {
                return new ChopFrame(frameType, in.readUnsignedShort());
            }
            if (frameType == 251) {
                return new SameFrame(frameType, in.readUnsignedShort());
            }
            if (251 < frameType && frameType < 255) {
                return new AppendFrame(frameType, in.readUnsignedShort(), StackMapData.readTypeArray(in, frameType - 251, method));
            }
            if (frameType == 255) {
                int offsetDelta = in.readUnsignedShort();
                int locals_size = in.readUnsignedShort();
                int[] locals = StackMapData.readTypeArray(in, locals_size, method);
                int stack_size = in.readUnsignedShort();
                int[] stack = StackMapData.readTypeArray(in, stack_size, method);
                return new FullFrame(offsetDelta, locals, stack);
            }
            throw new ClassFormatError("unrecognized frame_type in StackMapTable");
        }

        private static class SameFrame
        extends StackMapTableData {
            SameFrame(int frameType, int offsetDelta) {
                super(frameType);
                this.offsetDelta = offsetDelta;
            }

            @Override
            void applyTo(TypeArray localTypes, TypeArray stackTypes) {
                stackTypes.clear();
            }

            public String toString() {
                return SameFrame.toString("SAME" + (this.frameType == 251 ? "_FRAME_EXTENDED" : ""), this.offsetDelta, null, null);
            }
        }

        private static class SameLocals1StackItem
        extends StackMapTableData {
            final int[] stack;

            SameLocals1StackItem(int frameType, int offsetDelta, int[] stack) {
                super(frameType);
                this.offsetDelta = offsetDelta;
                this.stack = stack;
            }

            @Override
            void applyTo(TypeArray localTypes, TypeArray stackTypes) {
                stackTypes.setAll(this.stack);
            }

            public String toString() {
                return SameLocals1StackItem.toString("SAME_LOCALS_1_STACK_ITEM" + (this.frameType == 247 ? "_EXTENDED" : ""), this.offsetDelta, null, this.stack);
            }
        }

        private static class ChopFrame
        extends StackMapTableData {
            ChopFrame(int frameType, int offsetDelta) {
                super(frameType);
                this.offsetDelta = offsetDelta;
            }

            @Override
            void applyTo(TypeArray localTypes, TypeArray stackTypes) {
                localTypes.setSize(localTypes.getSize() - (251 - this.frameType));
                stackTypes.clear();
            }

            public String toString() {
                return ChopFrame.toString("CHOP", this.offsetDelta, null, null);
            }
        }

        private static class AppendFrame
        extends StackMapTableData {
            final int[] locals;

            AppendFrame(int frameType, int offsetDelta, int[] locals) {
                super(frameType);
                this.offsetDelta = offsetDelta;
                this.locals = locals;
            }

            @Override
            void applyTo(TypeArray localTypes, TypeArray stackTypes) {
                localTypes.addAll(this.locals);
                stackTypes.clear();
            }

            public String toString() {
                return AppendFrame.toString("APPEND", this.offsetDelta, this.locals, null);
            }
        }

        private static class FullFrame
        extends StackMapTableData {
            final int[] locals;
            final int[] stack;

            FullFrame(int offsetDelta, int[] locals, int[] stack) {
                super(255);
                this.offsetDelta = offsetDelta;
                this.locals = locals;
                this.stack = stack;
            }

            @Override
            void applyTo(TypeArray localTypes, TypeArray stackTypes) {
                localTypes.setAll(this.locals);
                stackTypes.setAll(this.stack);
            }

            public String toString() {
                return FullFrame.toString("FULL", this.offsetDelta, this.locals, this.stack);
            }
        }
    }

    static final class StackMapIterator {
        private final StackMapTableData[] stackMapTable;
        private final TypeArray argTypes;
        private final TypeArray localTypes;
        private final TypeArray stackTypes;
        private int nextFrameIndex;
        private int lastFrameByteCodeOffset;
        private int byteCodeOffset;

        StackMapIterator(MethodData methodData) {
            this(methodData.getStackMapTable(), methodData.getInternalSig(), methodData.isStatic());
        }

        StackMapIterator(StackMapTableData[] stackMapTable, String methodSignature, boolean isStaticMethod) {
            this.stackMapTable = stackMapTable != null ? stackMapTable : new StackMapTableData[]{};
            this.argTypes = StackMapIterator.getArgTypes(methodSignature, isStaticMethod);
            this.localTypes = new TypeArray();
            this.stackTypes = new TypeArray();
            this.localTypes.addAll(this.argTypes);
            this.lastFrameByteCodeOffset = -1;
            this.advanceBy(0);
        }

        public boolean isEmpty() {
            return this.stackMapTable.length == 0;
        }

        public String getFrameAsString() {
            return this.nextFrameIndex == 0 ? StackMapTableData.toString("INITIAL", 0, null, null) : this.stackMapTable[this.nextFrameIndex - 1].toString();
        }

        public int getFrameIndex() {
            return this.nextFrameIndex;
        }

        public TypeArray getFrameStack() {
            return this.stackTypes;
        }

        public TypeArray getFrameLocals() {
            return this.localTypes;
        }

        public TypeArray getArguments() {
            return this.argTypes;
        }

        public void advanceBy(int numByteCodes) {
            if (numByteCodes < 0) {
                throw new IllegalStateException("Forward only iterator");
            }
            this.byteCodeOffset += numByteCodes;
            while (this.nextFrameIndex < this.stackMapTable.length && this.byteCodeOffset - this.lastFrameByteCodeOffset >= this.stackMapTable[this.nextFrameIndex].offsetDelta + 1) {
                StackMapTableData nextFrame = this.stackMapTable[this.nextFrameIndex];
                this.lastFrameByteCodeOffset += nextFrame.offsetDelta + 1;
                nextFrame.applyTo(this.localTypes, this.stackTypes);
                ++this.nextFrameIndex;
            }
        }

        public void advanceTo(int nextByteCodeOffset) {
            this.advanceBy(nextByteCodeOffset - this.byteCodeOffset);
        }

        private static TypeArray getArgTypes(String methodSignature, boolean isStaticMethod) {
            TypeArray argTypes = new TypeArray();
            if (!isStaticMethod) {
                argTypes.add(7);
            }
            if (methodSignature.charAt(0) != '(') {
                throw new IllegalArgumentException("Invalid method signature");
            }
            int length = methodSignature.length();
            boolean skipType = false;
            block9: for (int i = 1; i < length; ++i) {
                int argType;
                switch (methodSignature.charAt(i)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        argType = 1;
                        break;
                    }
                    case 'J': {
                        argType = 4;
                        break;
                    }
                    case 'F': {
                        argType = 2;
                        break;
                    }
                    case 'D': {
                        argType = 3;
                        break;
                    }
                    case 'L': {
                        i = methodSignature.indexOf(59, i + 1);
                        if (i == -1) {
                            throw new IllegalArgumentException("Invalid method signature");
                        }
                        argType = 7;
                        break;
                    }
                    case ')': {
                        return argTypes;
                    }
                    case '[': {
                        if (skipType) continue block9;
                        argTypes.add(7);
                        skipType = true;
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid method signature");
                    }
                }
                if (!skipType) {
                    argTypes.add(argType);
                    continue;
                }
                skipType = false;
            }
            return argTypes;
        }
    }

    private static class StackMapData {
        final int offset;
        final int[] locals;
        final int[] stack;

        StackMapData(int offset, int[] locals, int[] stack) {
            this.offset = offset;
            this.locals = locals;
            this.stack = stack;
        }

        StackMapData(DataInputStream in, MethodData method) throws IOException {
            this.offset = in.readUnsignedShort();
            int local_size = in.readUnsignedShort();
            this.locals = StackMapData.readTypeArray(in, local_size, method);
            int stack_size = in.readUnsignedShort();
            this.stack = StackMapData.readTypeArray(in, stack_size, method);
        }

        static final int[] readTypeArray(DataInputStream in, int length, MethodData method) throws IOException {
            int[] types = new int[length];
            for (int i = 0; i < length; ++i) {
                types[i] = StackMapData.readType(in, method);
            }
            return types;
        }

        static final int readType(DataInputStream in, MethodData method) throws IOException {
            int type = in.readUnsignedByte();
            if (type == 7 || type == 8) {
                type |= in.readUnsignedShort() << 8;
            }
            return type;
        }
    }

    static class MethodData {
        ClassData cls;
        int access;
        int name_index;
        int descriptor_index;
        int attributes_count;
        byte[] code;
        Vector exception_table = new Vector(0);
        Vector lin_num_tb = new Vector(0);
        Vector loc_var_tb = new Vector(0);
        StackMapTableData[] stackMapTable;
        StackMapData[] stackMap;
        int[] exc_index_table = null;
        Vector attrs = new Vector(0);
        Vector code_attrs = new Vector(0);
        int max_stack;
        int max_locals;
        boolean isSynthetic = false;
        boolean isDeprecated = false;
        private AttrData annotationDefault;

        public MethodData(ClassData cls) {
            this.cls = cls;
        }

        public void read(DataInputStream in) throws IOException {
            this.access = in.readUnsignedShort();
            this.name_index = in.readUnsignedShort();
            this.descriptor_index = in.readUnsignedShort();
            int attributes_count = in.readUnsignedShort();
            for (int i = 0; i < attributes_count; ++i) {
                int attr_name_index = in.readUnsignedShort();
                if (this.cls.getTag(attr_name_index) == 1) {
                    AttrData attr;
                    String attr_name = this.cls.getString(attr_name_index);
                    if (attr_name.equals("Code")) {
                        this.readCode(in);
                        attr = new AttrData(this.cls);
                        attr.read(attr_name_index);
                        this.attrs.addElement(attr);
                        continue;
                    }
                    if (attr_name.equals("Exceptions")) {
                        this.readExceptions(in);
                        attr = new AttrData(this.cls);
                        attr.read(attr_name_index);
                        this.attrs.addElement(attr);
                        continue;
                    }
                    if (attr_name.equals("Synthetic")) {
                        if (in.readInt() != 0) {
                            throw new ClassFormatError("invalid Synthetic attr length");
                        }
                        this.isSynthetic = true;
                        attr = new AttrData(this.cls);
                        attr.read(attr_name_index);
                        this.attrs.addElement(attr);
                        continue;
                    }
                    if (attr_name.equals("Deprecated")) {
                        if (in.readInt() != 0) {
                            throw new ClassFormatError("invalid Synthetic attr length");
                        }
                        this.isDeprecated = true;
                        attr = new AttrData(this.cls);
                        attr.read(attr_name_index);
                        this.attrs.addElement(attr);
                        continue;
                    }
                    if (attr_name.equals("AnnotationDefault")) {
                        attr = new AttrData(this.cls);
                        attr.read(attr_name_index, in);
                        this.attrs.addElement(attr);
                        this.annotationDefault = attr;
                        continue;
                    }
                }
                AttrData attr = new AttrData(this.cls);
                attr.read(attr_name_index, in);
                this.attrs.addElement(attr);
            }
        }

        public void readCode(DataInputStream in) throws IOException {
            int attr_length = in.readInt();
            this.max_stack = in.readUnsignedShort();
            this.max_locals = in.readUnsignedShort();
            int codelen = in.readInt();
            this.code = new byte[codelen];
            for (int totalread = 0; totalread < codelen; totalread += in.read(this.code, totalread, codelen - totalread)) {
            }
            boolean clen = false;
            this.readExceptionTable(in);
            int code_attributes_count = in.readUnsignedShort();
            for (int k = 0; k < code_attributes_count; ++k) {
                int table_name_index = in.readUnsignedShort();
                byte table_name_tag = this.cls.getTag(table_name_index);
                AttrData attr = new AttrData(this.cls);
                if (table_name_tag == 1) {
                    String table_name_tstr = this.cls.getString(table_name_index);
                    if (table_name_tstr.equals("LineNumberTable")) {
                        this.readLineNumTable(in);
                        attr.read(table_name_index);
                    } else if (table_name_tstr.equals("LocalVariableTable")) {
                        this.readLocVarTable(in);
                        attr.read(table_name_index);
                    } else if (table_name_tstr.equals("StackMapTable")) {
                        this.readStackMapTable(in);
                        attr.read(table_name_index);
                    } else if (table_name_tstr.equals("StackMap")) {
                        this.readStackMap(in);
                        attr.read(table_name_index);
                    } else {
                        attr.read(table_name_index, in);
                    }
                    this.code_attrs.addElement(attr);
                    continue;
                }
                attr.read(table_name_index, in);
                this.code_attrs.addElement(attr);
            }
        }

        void readExceptionTable(DataInputStream in) throws IOException {
            int exception_table_len = in.readUnsignedShort();
            this.exception_table = new Vector(exception_table_len);
            for (int l = 0; l < exception_table_len; ++l) {
                this.exception_table.addElement(new TrapData(in, l));
            }
        }

        void readLineNumTable(DataInputStream in) throws IOException {
            int attr_len = in.readInt();
            int lin_num_tb_len = in.readUnsignedShort();
            this.lin_num_tb = new Vector(lin_num_tb_len);
            for (int l = 0; l < lin_num_tb_len; ++l) {
                this.lin_num_tb.addElement(new LineNumData(in));
            }
        }

        void readLocVarTable(DataInputStream in) throws IOException {
            int attr_len = in.readInt();
            int loc_var_tb_len = in.readUnsignedShort();
            this.loc_var_tb = new Vector(loc_var_tb_len);
            for (int l = 0; l < loc_var_tb_len; ++l) {
                this.loc_var_tb.addElement(new LocVarData(in));
            }
        }

        public void readExceptions(DataInputStream in) throws IOException {
            int attr_len = in.readInt();
            int num_exceptions = in.readUnsignedShort();
            this.exc_index_table = new int[num_exceptions];
            for (int l = 0; l < num_exceptions; ++l) {
                short exc = in.readShort();
                this.exc_index_table[l] = exc;
            }
        }

        void readStackMapTable(DataInputStream in) throws IOException {
            int attr_len = in.readInt();
            int stack_map_tb_len = in.readUnsignedShort();
            this.stackMapTable = new StackMapTableData[stack_map_tb_len];
            for (int i = 0; i < stack_map_tb_len; ++i) {
                this.stackMapTable[i] = StackMapTableData.getInstance(in, this);
            }
        }

        void readStackMap(DataInputStream in) throws IOException {
            int attr_len = in.readInt();
            int stack_map_len = in.readUnsignedShort();
            this.stackMap = new StackMapData[stack_map_len];
            for (int i = 0; i < stack_map_len; ++i) {
                this.stackMap[i] = new StackMapData(in, this);
            }
        }

        public int getAccess() {
            return this.access;
        }

        public String getName() {
            return this.cls.getStringValue(this.name_index);
        }

        public String getInternalSig() {
            return this.cls.getStringValue(this.descriptor_index);
        }

        public byte[] getCode() {
            return this.code;
        }

        public int getnumlines() {
            return this.lin_num_tb.size();
        }

        public Vector getlin_num_tb() {
            return this.lin_num_tb;
        }

        public int getloc_var_tbsize() {
            return this.loc_var_tb.size();
        }

        public Vector getloc_var_tb() {
            return this.loc_var_tb;
        }

        public StackMapData[] getStackMap() {
            return this.stackMap;
        }

        public StackMapTableData[] getStackMapTable() {
            return this.stackMapTable;
        }

        public StackMapIterator createStackMapIterator() {
            return new StackMapIterator(this);
        }

        public boolean isStatic() {
            return (this.access & 8) != 0;
        }

        public int getMaxStack() {
            return this.max_stack;
        }

        public int getMaxLocals() {
            return this.max_locals;
        }

        public int[] get_exc_index_table() {
            return this.exc_index_table;
        }

        public TrapDataIterator getTrapDataIterator() {
            return new TrapDataIterator(this.exception_table);
        }

        public Vector getAttributes() {
            return this.attrs;
        }

        public Vector getCodeAttributes() {
            return this.code_attrs;
        }

        byte[] getDefaultAttribute() {
            return this.annotationDefault == null ? null : this.annotationDefault.getData();
        }

        public boolean isSynthetic() {
            return this.isSynthetic;
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public byte[] findAnnotationData(boolean classRetention) {
            String n = classRetention ? "RuntimeInvisibleAnnotations" : "RuntimeVisibleAnnotations";
            Object[] arr = new AttrData[this.attrs.size()];
            this.attrs.copyInto(arr);
            return ClassData.findAttr(n, (AttrData[])arr);
        }

        public boolean isConstructor() {
            return "<init>".equals(this.getName());
        }
    }

    private static class LocVarData {
        short start_pc;
        short length;
        short name_cpx;
        short sig_cpx;
        short slot;

        public LocVarData() {
        }

        public LocVarData(DataInputStream in) throws IOException {
            this.start_pc = in.readShort();
            this.length = in.readShort();
            this.name_cpx = in.readShort();
            this.sig_cpx = in.readShort();
            this.slot = in.readShort();
        }
    }

    private static class LineNumData {
        short start_pc;
        short line_number;

        public LineNumData() {
        }

        public LineNumData(DataInputStream in) throws IOException {
            this.start_pc = in.readShort();
            this.line_number = in.readShort();
        }
    }

    static class BootMethodData {
        final ClassData clazz;
        final int method;
        final int[] args;

        private BootMethodData(ClassData clazz, int method, int[] args) {
            this.clazz = clazz;
            this.method = method;
            this.args = args;
        }

        int getArguments() {
            return this.args.length;
        }

        String getArgument(int index) {
            return this.clazz.stringValue(this.args[index], false);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.clazz.stringValue(this.method, true));
            sb.append('(');
            for (int i = 0; i < this.getArguments(); ++i) {
                sb.append("\n  ");
                sb.append(this.getArgument(i));
            }
            sb.append(')');
            return sb.toString();
        }
    }

    private static class InnerClassData {
        ClassData cls;
        int inner_class_info_index;
        int outer_class_info_index;
        int inner_name_index;
        int access;

        public InnerClassData(ClassData cls) {
            this.cls = cls;
        }

        public void read(DataInputStream in) throws IOException {
            this.inner_class_info_index = in.readUnsignedShort();
            this.outer_class_info_index = in.readUnsignedShort();
            this.inner_name_index = in.readUnsignedShort();
            this.access = in.readUnsignedShort();
        }

        public String[] getAccess() {
            Vector v = new Vector();
            if ((this.access & 1) != 0) {
                v.addElement("public");
            }
            if ((this.access & 0x10) != 0) {
                v.addElement("final");
            }
            if ((this.access & 0x400) != 0) {
                v.addElement("abstract");
            }
            Object[] accflags = new String[v.size()];
            v.copyInto(accflags);
            return accflags;
        }
    }

    private static final class Hashtable {
        private Object[] keys;
        private Object[] values;

        Hashtable(int i) {
            this();
        }

        Hashtable(int i, double d) {
            this();
        }

        Hashtable() {
        }

        synchronized void put(Object key, Object val) {
            int[] where = new int[]{-1, -1};
            Object found = this.get(key, where);
            if (where[0] != -1) {
                this.values[where[0]] = val;
            } else if (where[1] != -1) {
                this.keys[where[1]] = key;
                this.values[where[1]] = val;
            } else if (this.keys == null) {
                this.keys = new Object[11];
                this.values = new Object[11];
                this.keys[0] = key;
                this.values[0] = val;
            } else {
                Object[] newKeys = new Object[this.keys.length * 2];
                Object[] newValues = new Object[this.values.length * 2];
                for (int i = 0; i < this.keys.length; ++i) {
                    newKeys[i] = this.keys[i];
                    newValues[i] = this.values[i];
                }
                newKeys[this.keys.length] = key;
                newValues[this.keys.length] = val;
                this.keys = newKeys;
                this.values = newValues;
            }
        }

        Object get(Object key) {
            return this.get(key, null);
        }

        private synchronized Object get(Object key, int[] foundAndNull) {
            if (this.keys == null) {
                return null;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null) {
                    if (foundAndNull == null) continue;
                    foundAndNull[1] = i;
                    continue;
                }
                if (!this.keys[i].equals(key)) continue;
                if (foundAndNull != null) {
                    foundAndNull[0] = i;
                }
                return this.values[i];
            }
            return null;
        }
    }

    static class FieldData {
        ClassData cls;
        int access;
        int name_index;
        int descriptor_index;
        int attributes_count;
        int value_cpx = -1;
        boolean isSynthetic = false;
        boolean isDeprecated = false;
        Vector attrs;

        public FieldData(ClassData cls) {
            this.cls = cls;
        }

        public void read(DataInputStream in) throws IOException {
            this.access = in.readUnsignedShort();
            this.name_index = in.readUnsignedShort();
            this.descriptor_index = in.readUnsignedShort();
            int attributes_count = in.readUnsignedShort();
            this.attrs = new Vector(attributes_count);
            for (int i = 0; i < attributes_count; ++i) {
                AttrData attr;
                int attr_name_index = in.readUnsignedShort();
                if (this.cls.getTag(attr_name_index) != 1) continue;
                String attr_name = this.cls.getString(attr_name_index);
                if (attr_name.equals("ConstantValue")) {
                    if (in.readInt() != 2) {
                        throw new ClassFormatError("invalid ConstantValue attr length");
                    }
                    this.value_cpx = in.readUnsignedShort();
                    attr = new AttrData(this.cls);
                    attr.read(attr_name_index);
                    this.attrs.addElement(attr);
                    continue;
                }
                if (attr_name.equals("Synthetic")) {
                    if (in.readInt() != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isSynthetic = true;
                    attr = new AttrData(this.cls);
                    attr.read(attr_name_index);
                    this.attrs.addElement(attr);
                    continue;
                }
                if (attr_name.equals("Deprecated")) {
                    if (in.readInt() != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isDeprecated = true;
                    attr = new AttrData(this.cls);
                    attr.read(attr_name_index);
                    this.attrs.addElement(attr);
                    continue;
                }
                attr = new AttrData(this.cls);
                attr.read(attr_name_index, in);
                this.attrs.addElement(attr);
            }
        }

        public boolean isStatic() {
            return (this.access & 8) != 0;
        }

        public String[] getAccess() {
            Vector v = new Vector();
            if ((this.access & 1) != 0) {
                v.addElement("public");
            }
            if ((this.access & 2) != 0) {
                v.addElement("private");
            }
            if ((this.access & 4) != 0) {
                v.addElement("protected");
            }
            if ((this.access & 8) != 0) {
                v.addElement("static");
            }
            if ((this.access & 0x10) != 0) {
                v.addElement("final");
            }
            if ((this.access & 0x40) != 0) {
                v.addElement("volatile");
            }
            if ((this.access & 0x80) != 0) {
                v.addElement("transient");
            }
            Object[] accflags = new String[v.size()];
            v.copyInto(accflags);
            return accflags;
        }

        public String getName() {
            return this.cls.getStringValue(this.name_index);
        }

        public String getInternalSig() {
            return this.cls.getStringValue(this.descriptor_index);
        }

        public boolean isSynthetic() {
            return this.isSynthetic;
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public boolean hasConstantValue() {
            return this.value_cpx != -1;
        }

        public Vector getAttributes() {
            return this.attrs;
        }

        public byte[] findAnnotationData(boolean classRetention) {
            String n = classRetention ? "RuntimeInvisibleAnnotations" : "RuntimeVisibleAnnotations";
            Object[] arr = new AttrData[this.attrs.size()];
            this.attrs.copyInto(arr);
            return ClassData.findAttr(n, (AttrData[])arr);
        }
    }

    static final class ClassData {
        private int magic;
        private int minor_version;
        private int major_version;
        private int cpool_count;
        private Object[] cpool;
        private int access;
        private int this_class = 0;
        private int super_class;
        private int interfaces_count;
        private int[] interfaces = new int[0];
        private FieldData[] fields;
        private MethodData[] methods;
        private InnerClassData[] innerClasses;
        private BootMethodData[] bootMethods;
        private int attributes_count;
        private AttrData[] attrs;
        private int source_cpx = 0;
        private byte[] tags;
        private Hashtable indexHashAscii = new Hashtable();
        private String pkgPrefix = "";
        private int pkgPrefixLen = 0;
        private boolean hasEnclosingMethod;
        static final String hexString = "0123456789ABCDEF";
        public static char[] hexTable = "0123456789ABCDEF".toCharArray();

        public ClassData(InputStream infile) throws IOException {
            this.read(new DataInputStream(infile));
        }

        public void read(DataInputStream in) throws IOException {
            this.magic = in.readInt();
            if (this.magic != -889275714) {
                throw new ClassFormatError("wrong magic: " + ClassData.toHex(this.magic) + ", expected " + ClassData.toHex(-889275714));
            }
            this.minor_version = in.readShort();
            this.major_version = in.readShort();
            if (this.major_version != 45) {
                // empty if block
            }
            this.readCP(in);
            this.access = in.readUnsignedShort();
            this.this_class = in.readUnsignedShort();
            this.super_class = in.readUnsignedShort();
            this.interfaces_count = in.readUnsignedShort();
            if (this.interfaces_count > 0) {
                this.interfaces = new int[this.interfaces_count];
            }
            for (int i = 0; i < this.interfaces_count; ++i) {
                this.interfaces[i] = in.readShort();
            }
            this.readFields(in);
            this.readMethods(in);
            this.attributes_count = in.readUnsignedShort();
            this.attrs = new AttrData[this.attributes_count];
            for (int k = 0; k < this.attributes_count; ++k) {
                AttrData attr;
                int name_cpx = in.readUnsignedShort();
                if (this.getTag(name_cpx) != 1) continue;
                String attrName = this.getString(name_cpx);
                if (attrName.equals("SourceFile")) {
                    if (in.readInt() != 2) {
                        throw new ClassFormatError("invalid attr length");
                    }
                    this.source_cpx = in.readUnsignedShort();
                    attr = new AttrData(this);
                    attr.read(name_cpx);
                    this.attrs[k] = attr;
                    continue;
                }
                if (attrName.equals("InnerClasses")) {
                    int length = in.readInt();
                    int num = in.readUnsignedShort();
                    if (2 + num * 8 != length) {
                        throw new ClassFormatError("invalid attr length");
                    }
                    this.innerClasses = new InnerClassData[num];
                    for (int j = 0; j < num; ++j) {
                        InnerClassData innerClass = new InnerClassData(this);
                        innerClass.read(in);
                        this.innerClasses[j] = innerClass;
                    }
                    AttrData attr2 = new AttrData(this);
                    attr2.read(name_cpx);
                    this.attrs[k] = attr2;
                    continue;
                }
                if (attrName.equals("BootstrapMethods")) {
                    attr = new AttrData(this);
                    this.bootMethods = this.readBootstrapMethods(in);
                    attr.read(name_cpx);
                    this.attrs[k] = attr;
                    continue;
                }
                if (attrName.equals("EnclosingMethod")) {
                    this.hasEnclosingMethod = true;
                }
                attr = new AttrData(this);
                attr.read(name_cpx, in);
                this.attrs[k] = attr;
            }
            in.close();
        }

        BootMethodData[] readBootstrapMethods(DataInputStream in) throws IOException {
            int attr_len = in.readInt();
            int number = in.readShort();
            BootMethodData[] arr = new BootMethodData[number];
            for (int i = 0; i < number; ++i) {
                short ref = in.readShort();
                int len = in.readShort();
                int[] args = new int[len];
                for (int j = 0; j < len; ++j) {
                    args[j] = in.readShort();
                }
                arr[i] = new BootMethodData(this, ref, args);
            }
            return arr;
        }

        void readCP(DataInputStream in) throws IOException {
            this.cpool_count = in.readUnsignedShort();
            this.tags = new byte[this.cpool_count];
            this.cpool = new Object[this.cpool_count];
            block12: for (int i = 1; i < this.cpool_count; ++i) {
                byte tag;
                this.tags[i] = tag = in.readByte();
                switch (this.tags[i]) {
                    case 1: {
                        String str = in.readUTF();
                        this.cpool[i] = str;
                        this.indexHashAscii.put(this.cpool[i], new Integer(i));
                        continue block12;
                    }
                    case 3: {
                        this.cpool[i] = new Integer(in.readInt());
                        continue block12;
                    }
                    case 4: {
                        this.cpool[i] = new Float(in.readFloat());
                        continue block12;
                    }
                    case 5: {
                        this.cpool[i++] = new Long(in.readLong());
                        continue block12;
                    }
                    case 6: {
                        this.cpool[i++] = new Double(in.readDouble());
                        continue block12;
                    }
                    case 7: 
                    case 8: {
                        this.cpool[i] = new CPX(in.readUnsignedShort());
                        continue block12;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.cpool[i] = new CPX2(in.readUnsignedShort(), in.readUnsignedShort());
                        continue block12;
                    }
                    case 15: {
                        this.cpool[i] = new CPX2(in.readByte(), in.readUnsignedShort());
                        continue block12;
                    }
                    case 16: {
                        this.cpool[i] = new CPX(in.readUnsignedShort());
                        continue block12;
                    }
                    case 18: {
                        this.cpool[i] = new CPX2(in.readUnsignedShort(), in.readUnsignedShort());
                        continue block12;
                    }
                    default: {
                        throw new IOException("invalid constant type: " + this.tags[i]);
                    }
                }
            }
        }

        protected void readFields(DataInputStream in) throws IOException {
            int fields_count = in.readUnsignedShort();
            this.fields = new FieldData[fields_count];
            for (int k = 0; k < fields_count; ++k) {
                FieldData field = new FieldData(this);
                field.read(in);
                this.fields[k] = field;
            }
        }

        protected void readMethods(DataInputStream in) throws IOException {
            int methods_count = in.readUnsignedShort();
            this.methods = new MethodData[methods_count];
            for (int k = 0; k < methods_count; ++k) {
                MethodData method = new MethodData(this);
                method.read(in);
                this.methods[k] = method;
            }
        }

        public String getString(int n) {
            if (n == 0) {
                return null;
            }
            return (String)this.cpool[n];
        }

        public byte getTag(int n) {
            try {
                return this.tags[n];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return 100;
            }
        }

        static String toHex(long val, int width) {
            StringBuffer s = new StringBuffer();
            for (int i = width - 1; i >= 0; --i) {
                s.append(hexTable[(int)(val >> 4 * i) & 0xF]);
            }
            return "0x" + s.toString();
        }

        static String toHex(long val) {
            int width;
            for (width = 16; width > 0 && val >> (width - 1) * 4 == 0L; --width) {
            }
            return ClassData.toHex(val, width);
        }

        static String toHex(int val) {
            int width;
            for (width = 8; width > 0 && val >> (width - 1) * 4 == 0; --width) {
            }
            return ClassData.toHex(val, width);
        }

        public String getClassName() {
            int tcpx;
            String res = null;
            if (this.this_class == 0) {
                return res;
            }
            try {
                if (this.tags[this.this_class] != 7) {
                    return res;
                }
                tcpx = ((CPX)this.cpool[this.this_class]).cpx;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return res;
            }
            catch (Throwable e) {
                return res;
            }
            try {
                return (String)this.cpool[tcpx];
            }
            catch (ArrayIndexOutOfBoundsException e) {}
            catch (ClassCastException e) {}
            finally {
                return res;
            }
        }

        public String getClassName(int cpx) {
            int scpx;
            String res = "#" + cpx;
            if (cpx == 0) {
                return res;
            }
            try {
                if (this.tags[cpx] != 7) {
                    return res;
                }
                scpx = ((CPX)this.cpool[cpx]).cpx;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return res;
            }
            catch (Throwable e) {
                return res;
            }
            res = "#" + scpx;
            try {
                return (String)this.cpool[scpx];
            }
            catch (ArrayIndexOutOfBoundsException e) {}
            catch (ClassCastException e) {}
            finally {
                return res;
            }
        }

        public int getAccessFlags() {
            return this.access;
        }

        public boolean hasEnclosingMethod() {
            return this.hasEnclosingMethod;
        }

        public boolean isClass() {
            return (this.access & 0x200) == 0;
        }

        public boolean isInterface() {
            return (this.access & 0x200) != 0;
        }

        public boolean isAnnotation() {
            return (this.access & 0x20000) != 0;
        }

        public boolean isPublic() {
            return (this.access & 1) != 0;
        }

        public String[] getAccess() {
            Vector v = new Vector();
            if ((this.access & 1) != 0) {
                v.addElement("public");
            }
            if ((this.access & 0x10) != 0) {
                v.addElement("final");
            }
            if ((this.access & 0x400) != 0) {
                v.addElement("abstract");
            }
            Object[] accflags = new String[v.size()];
            v.copyInto(accflags);
            return accflags;
        }

        public InnerClassData[] getInnerClasses() {
            return this.innerClasses;
        }

        final AttrData[] getAttributes() {
            return this.attrs;
        }

        public byte[] findAnnotationData(boolean classRetention) {
            String n = classRetention ? "RuntimeInvisibleAnnotations" : "RuntimeVisibleAnnotations";
            return ClassData.findAttr(n, this.attrs);
        }

        public boolean isSuperSet() {
            return (this.access & 0x20) != 0;
        }

        public String getSuperClassName() {
            int scpx;
            String res = null;
            if (this.super_class == 0) {
                return res;
            }
            try {
                if (this.tags[this.super_class] != 7) {
                    return res;
                }
                scpx = ((CPX)this.cpool[this.super_class]).cpx;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return res;
            }
            catch (Throwable e) {
                return res;
            }
            try {
                return (String)this.cpool[scpx];
            }
            catch (ArrayIndexOutOfBoundsException e) {}
            catch (ClassCastException e) {}
            finally {
                return res;
            }
        }

        public String[] getSuperInterfaces() {
            String[] interfacenames = new String[this.interfaces.length];
            int interfacecpx = -1;
            for (int i = 0; i < this.interfaces.length; ++i) {
                interfacecpx = ((CPX)this.cpool[this.interfaces[i]]).cpx;
                interfacenames[i] = (String)this.cpool[interfacecpx];
            }
            return interfacenames;
        }

        public String getStringValue(int cpoolx) {
            try {
                return (String)this.cpool[cpoolx];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return "//invalid constant pool index:" + cpoolx;
            }
            catch (ClassCastException e) {
                return "//invalid constant pool ref:" + cpoolx;
            }
        }

        public FieldData[] getFields() {
            return this.fields;
        }

        public MethodData[] getMethods() {
            return this.methods;
        }

        public CPX2 getCpoolEntry(int cpx) {
            return (CPX2)this.cpool[cpx];
        }

        public Object getCpoolEntryobj(int cpx) {
            return this.cpool[cpx];
        }

        public int getthis_cpx() {
            return this.this_class;
        }

        public String StringValue(int cpx) {
            return this.stringValue(cpx, false);
        }

        public String stringValue(int cpx, boolean textual) {
            return this.stringValue(cpx, textual, null);
        }

        public String stringValue(int cpx, String[] classRefs) {
            return this.stringValue(cpx, true, classRefs);
        }

        private String stringValue(int cpx, boolean textual, String[] refs) {
            Object x;
            byte tag;
            if (cpx == 0) {
                return "#0";
            }
            String suffix = "";
            try {
                tag = this.tags[cpx];
                x = this.cpool[cpx];
            }
            catch (IndexOutOfBoundsException e) {
                return "<Incorrect CP index:" + cpx + ">";
            }
            if (x == null) {
                return "<NULL>";
            }
            switch (tag) {
                case 1: {
                    if (!textual) {
                        return (String)x;
                    }
                    StringBuilder sb = new StringBuilder();
                    String s = (String)x;
                    block24: for (int k = 0; k < s.length(); ++k) {
                        char c = s.charAt(k);
                        switch (c) {
                            case '\\': {
                                sb.append('\\').append('\\');
                                continue block24;
                            }
                            case '\t': {
                                sb.append('\\').append('t');
                                continue block24;
                            }
                            case '\n': {
                                sb.append('\\').append('n');
                                continue block24;
                            }
                            case '\r': {
                                sb.append('\\').append('r');
                                continue block24;
                            }
                            case '\"': {
                                sb.append('\\').append('\"');
                                continue block24;
                            }
                            case '\u2028': {
                                sb.append("\\u2028");
                                continue block24;
                            }
                            case '\u2029': {
                                sb.append("\\u2029");
                                continue block24;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                    }
                    return sb.toString();
                }
                case 6: {
                    Double d = (Double)x;
                    String sd = d.toString();
                    if (textual) {
                        return sd;
                    }
                    return sd + "d";
                }
                case 4: {
                    Float f = (Float)x;
                    String sf = f.toString();
                    if (textual) {
                        return sf;
                    }
                    return sf + "f";
                }
                case 5: {
                    Long ln = (Long)x;
                    if (textual) {
                        return ln.toString();
                    }
                    return ln.toString() + 'l';
                }
                case 3: {
                    Integer in = (Integer)x;
                    return in.toString();
                }
                case 7: {
                    String jn = this.getClassName(cpx);
                    if (textual) {
                        if (refs != null) {
                            refs[0] = jn;
                        }
                        return jn;
                    }
                    return this.javaName(jn);
                }
                case 8: {
                    String sv = this.stringValue(((CPX)x).cpx, textual);
                    if (textual) {
                        return '\"' + sv + '\"';
                    }
                    return sv;
                }
                case 9: 
                case 10: 
                case 11: {
                    return this.javaName(this.getClassName(((CPX2)x).cpx1)) + "." + this.StringValue(((CPX2)x).cpx2);
                }
                case 12: {
                    return this.getName(((CPX2)x).cpx1) + ":" + this.StringValue(((CPX2)x).cpx2);
                }
                case 15: {
                    return "K" + ((CPX2)x).cpx1 + "@" + this.stringValue(((CPX2)x).cpx2, textual);
                }
                case 16: {
                    return this.stringValue(((CPX)x).cpx, true);
                }
            }
            return "UnknownTag" + tag;
        }

        public String javaName(String name) {
            block4: {
                int cp;
                if (name == null) {
                    return "null";
                }
                int len = name.length();
                if (len == 0) {
                    return "\"\"";
                }
                int cc = 47;
                for (int k = 0; k < len; k += Character.charCount(cp)) {
                    cp = name.codePointAt(k);
                    if (!(cc == 47 ? !this.isJavaIdentifierStart(cp) : cp != 47 && !this.isJavaIdentifierPart(cp))) {
                        cc = cp;
                        continue;
                    }
                    break block4;
                }
                return name;
            }
            return "\"" + name + "\"";
        }

        public String getName(int cpx) {
            try {
                return this.javaName((String)this.cpool[cpx]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return "<invalid constant pool index:" + cpx + ">";
            }
            catch (ClassCastException e) {
                return "<invalid constant pool ref:" + cpx + ">";
            }
        }

        public String getShortClassName(int cpx) {
            String classname = this.javaName(this.getClassName(cpx));
            this.pkgPrefixLen = classname.lastIndexOf("/") + 1;
            if (this.pkgPrefixLen != 0) {
                this.pkgPrefix = classname.substring(0, this.pkgPrefixLen);
                if (classname.startsWith(this.pkgPrefix)) {
                    return classname.substring(this.pkgPrefixLen);
                }
            }
            return classname;
        }

        public String getSourceName() {
            return this.getName(this.source_cpx);
        }

        public String getPkgName() {
            String classname = this.getClassName(this.this_class);
            this.pkgPrefixLen = classname.lastIndexOf("/") + 1;
            if (this.pkgPrefixLen != 0) {
                this.pkgPrefix = classname.substring(0, this.pkgPrefixLen);
                return this.pkgPrefix.substring(0, this.pkgPrefixLen - 1);
            }
            return null;
        }

        public BootMethodData getBootMethod(int indx) {
            return this.bootMethods != null ? this.bootMethods[indx] : null;
        }

        public int getCpoolCount() {
            return this.cpool_count;
        }

        public int getMinor_version() {
            return this.minor_version;
        }

        public int getMajor_version() {
            return this.major_version;
        }

        private boolean isJavaIdentifierStart(int cp) {
            return 97 <= cp && cp <= 122 || 65 <= cp && cp <= 90;
        }

        private boolean isJavaIdentifierPart(int cp) {
            return this.isJavaIdentifierStart(cp) || 48 <= cp && cp <= 57;
        }

        public String[] getNameAndType(int indx) {
            return this.getNameAndType(indx, 0, new String[2]);
        }

        private String[] getNameAndType(int indx, int at, String[] arr) {
            CPX2 c2 = this.getCpoolEntry(indx);
            arr[at] = this.StringValue(c2.cpx1);
            arr[at + 1] = this.StringValue(c2.cpx2);
            return arr;
        }

        public String[] getFieldInfoName(int indx) {
            CPX2 c2 = this.getCpoolEntry(indx);
            String[] arr = new String[3];
            arr[0] = this.getClassName(c2.cpx1);
            return this.getNameAndType(c2.cpx2, 1, arr);
        }

        public MethodData findMethod(String name, String signature) {
            for (MethodData md : this.methods) {
                if (!md.getName().equals(name) || !md.getInternalSig().equals(signature)) continue;
                return md;
            }
            return null;
        }

        public FieldData findField(String name, String signature) {
            for (FieldData fd : this.fields) {
                if (!fd.getName().equals(name) || !fd.getInternalSig().equals(signature)) continue;
                return fd;
            }
            return null;
        }

        static byte[] findAttr(String n, AttrData[] attrs) {
            for (AttrData ad : attrs) {
                if (!n.equals(ad.getAttrName())) continue;
                return ad.getData();
            }
            return null;
        }
    }

    static class CPX2 {
        final int cpx1;
        final int cpx2;

        CPX2(int cpx1, int cpx2) {
            this.cpx1 = cpx1;
            this.cpx2 = cpx2;
        }
    }

    private static class CPX {
        final int cpx;

        CPX(int cpx) {
            this.cpx = cpx;
        }
    }

    private static class AttrData {
        ClassData cls;
        int name_cpx;
        int datalen;
        byte[] data;

        public AttrData(ClassData cls) {
            this.cls = cls;
        }

        public void read(int name_cpx, DataInputStream in) throws IOException {
            this.name_cpx = name_cpx;
            this.datalen = in.readInt();
            this.data = new byte[this.datalen];
            in.readFully(this.data);
        }

        public void read(int name_cpx) {
            this.name_cpx = name_cpx;
        }

        public String getAttrName() {
            return this.cls.getString(this.name_cpx);
        }

        public byte[] getData() {
            return this.data;
        }
    }

    static class AnnotationParser {
        private final boolean textual;
        private final boolean iterateArray;

        protected AnnotationParser(boolean textual, boolean iterateArray) {
            this.textual = textual;
            this.iterateArray = iterateArray;
        }

        protected void visitAnnotationStart(String type, boolean top) throws IOException {
        }

        protected void visitAnnotationEnd(String type, boolean top) throws IOException {
        }

        protected void visitValueStart(String attrName, char type) throws IOException {
        }

        protected void visitValueEnd(String attrName, char type) throws IOException {
        }

        protected void visitAttr(String annoType, String attr, String attrType, String value) throws IOException {
        }

        protected void visitEnumAttr(String annoType, String attr, String attrType, String value) throws IOException {
            this.visitAttr(annoType, attr, attrType, value);
        }

        protected void visitClassAttr(String annoType, String attr, String className) throws IOException {
            this.visitAttr(annoType, attr, className, className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void parse(byte[] attr, ClassData cd) throws IOException {
            ByteArrayInputStream is = new ByteArrayInputStream(attr);
            DataInputStream dis = new DataInputStream(is);
            try {
                this.read(dis, cd);
            }
            finally {
                is.close();
            }
        }

        private void read(DataInputStream dis, ClassData cd) throws IOException {
            int cnt = dis.readUnsignedShort();
            for (int i = 0; i < cnt; ++i) {
                this.readAnno(dis, cd, true);
            }
        }

        private void readAnno(DataInputStream dis, ClassData cd, boolean top) throws IOException {
            int type = dis.readUnsignedShort();
            String typeName = cd.StringValue(type);
            this.visitAnnotationStart(typeName, top);
            int cnt = dis.readUnsignedShort();
            for (int i = 0; i < cnt; ++i) {
                String attrName = cd.StringValue(dis.readUnsignedShort());
                this.readValue(dis, cd, typeName, attrName);
            }
            this.visitAnnotationEnd(typeName, top);
            if (cnt == 0) {
                this.visitAttr(typeName, null, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseDefault(byte[] defaultAttribute, ClassData cd) throws IOException {
            ByteArrayInputStream is = new ByteArrayInputStream(defaultAttribute);
            DataInputStream dis = new DataInputStream(is);
            try {
                this.readValue(dis, cd, null, null);
            }
            finally {
                is.close();
            }
        }

        private void readValue(DataInputStream dis, ClassData cd, String typeName, String attrName) throws IOException {
            char type = (char)dis.readByte();
            this.visitValueStart(attrName, type);
            if (type == '@') {
                this.readAnno(dis, cd, false);
            } else if ("CFJZsSIDB".indexOf(type) >= 0) {
                String attrType;
                int primitive = dis.readUnsignedShort();
                String val = cd.stringValue(primitive, this.textual);
                if (type == 's') {
                    attrType = "Ljava_lang_String_2";
                    if (this.textual) {
                        val = '\"' + val + '\"';
                    }
                } else {
                    attrType = "" + type;
                }
                this.visitAttr(typeName, attrName, attrType, val);
            } else if (type == 'c') {
                int cls = dis.readUnsignedShort();
                String attrType = cd.stringValue(cls, this.textual);
                this.visitClassAttr(typeName, attrName, attrType);
            } else if (type == '[') {
                int cnt = dis.readUnsignedShort();
                for (int i = 0; i < cnt; ++i) {
                    this.readValue(dis, cd, typeName, this.iterateArray ? attrName : null);
                }
            } else if (type == 'e') {
                int enumT = dis.readUnsignedShort();
                String attrType = cd.stringValue(enumT, this.textual);
                int enumN = dis.readUnsignedShort();
                String val = cd.stringValue(enumN, this.textual);
                this.visitEnumAttr(typeName, attrName, attrType, val);
            } else {
                throw new IOException("Unknown type " + type);
            }
            this.visitValueEnd(attrName, type);
        }
    }
}

