/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import java.io.InputStream;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.vm4brwsr.AltMetafactoryHandler;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.ExportedSymbols;
import org.apidesign.vm4brwsr.IndyHandler;
import org.apidesign.vm4brwsr.InternalSig;
import org.apidesign.vm4brwsr.JsCallbackCode;
import org.apidesign.vm4brwsr.LocalsMapper;
import org.apidesign.vm4brwsr.LoopCode;
import org.apidesign.vm4brwsr.MetafactoryHandler;
import org.apidesign.vm4brwsr.NumberOperations;
import org.apidesign.vm4brwsr.StackMapper;
import org.apidesign.vm4brwsr.StringArray;
import org.apidesign.vm4brwsr.StringConcatHandler;

abstract class ByteCodeToJavaScript {
    private ByteCodeParser.ClassData jc;
    private final StringArray classRefs = new StringArray();
    private final NumberOperations numbers = new NumberOperations();
    private final Appendable output;
    private final IndyHandler[] indyHandlers;
    private boolean callbacks;

    protected ByteCodeToJavaScript(Appendable out) {
        this.output = out;
        this.indyHandlers = new IndyHandler[]{new MetafactoryHandler(), new AltMetafactoryHandler(), new StringConcatHandler()};
    }

    protected abstract boolean requireReference(String var1);

    protected abstract void requireScript(String var1) throws IOException;

    protected abstract void requireResource(Appendable var1, String var2) throws IOException;

    String assignClass(String className) {
        return className + " = ";
    }

    String accessClass(String classOperation) {
        return classOperation;
    }

    final String accessClassFalse(String classOperation) {
        if (InternalSig.mangleClassName(this.jc.getClassName()).equals(classOperation)) {
            return "c";
        }
        this.classRefs.addIfMissing(classOperation);
        return "(refs_" + classOperation + " || (refs_" + classOperation + " = " + this.accessClass(classOperation) + "(false)))";
    }

    protected ByteCodeParser.FieldData findField(String[] fieldInfoName) throws IOException {
        return null;
    }

    protected String accessField(String object, ByteCodeParser.FieldData data, String[] fieldInfoName) throws IOException {
        String mangledName = "_" + fieldInfoName[1];
        return object + "." + mangledName;
    }

    protected String accessStaticMethod(String object, String mangledName, String[] fieldInfoName) throws IOException {
        return object + "." + mangledName;
    }

    protected String accessVirtualMethod(ByteCodeParser.ClassData caller, String object, String mangledName, String[] fieldInfoName, int params, String[] sep) throws IOException {
        return object + "." + mangledName + '(';
    }

    protected void declareClass(Appendable out, ByteCodeParser.ClassData classData, String mangledName) throws IOException {
        out.append(mangledName);
    }

    protected void declaredField(Appendable out, ByteCodeParser.FieldData fieldData, String destObject, String mangledName) throws IOException {
    }

    protected void declaredMethod(Appendable out, ByteCodeParser.MethodData methodData, String destObject, String mangledName) throws IOException {
    }

    boolean debug(Appendable out, String msg) throws IOException {
        out.append(msg);
        return true;
    }

    public String compile(InputStream classFile) throws IOException {
        return this.compile(new ByteCodeParser.ClassData(classFile));
    }

    protected String compile(ByteCodeParser.ClassData classData) throws IOException {
        this.jc = classData;
        String cn = this.jc.getClassName();
        try {
            return this.compileImpl(this.output, cn);
        }
        catch (IOException ex) {
            throw new IOException("Cannot compile " + cn + ":", ex);
        }
    }

    private String compileImpl(Appendable out, String cn) throws IOException {
        Object[] sc;
        this.numbers.reset();
        this.callbacks = cn.endsWith("/$JsCallbacks$");
        String className = ByteCodeToJavaScript.className(this.jc);
        byte[] arrData = this.jc.findAnnotationData(true);
        String[] arr = ByteCodeToJavaScript.findAnnotation(arrData, this.jc, "org.apidesign.bck2brwsr.core.ExtraJavaScript", "resource", "processByteCode");
        if (arr != null) {
            boolean scriptLoaded = false;
            if (!arr[0].isEmpty()) {
                this.requireScript(arr[0]);
                scriptLoaded = true;
            }
            if ("0".equals(arr[1])) {
                if (!scriptLoaded) {
                    out.append("\nfunction ").append(className).append("() {\n");
                    this.debug(out, "  throw '@ExtraJavaScript(" + className + ");\n");
                    out.append("}\n");
                }
                return null;
            }
        }
        StringArray jsResources = this.findJavaScriptResources(arrData, cn);
        String[] proto = ByteCodeToJavaScript.findAnnotation(arrData, this.jc, "org.apidesign.bck2brwsr.core.JavaScriptPrototype", "container", "prototype");
        StringArray toInitilize = new StringArray();
        out.append("\n\n");
        out.append("function ").append(className).append("() {");
        out.append("\n  var m;");
        out.append("\n  var CLS = ").append(className).append(';');
        out.append("\n  if (!CLS.$class) {");
        if (proto == null) {
            sc = this.jc.getSuperClassName();
            out.append("\n    var pp = ").append(this.accessClass(InternalSig.mangleClassName((String)sc))).append("(true);");
            out.append("\n    var p = CLS.prototype = pp;");
            out.append("\n    var c = p;");
            out.append("\n    var sprcls = pp.constructor.$class;");
        } else if (proto[1].isEmpty()) {
            out.append("\n    var c = ").append(proto[0]).append(";");
            out.append("\n    var p = c;");
            out.append("\n    var sprcls = null");
        } else {
            out.append("\n    var p = CLS.prototype = ").append(proto[1]).append(";");
            if (proto[0] == null) {
                proto[0] = "p";
            }
            out.append("\n    var c = ").append(proto[0]).append(";");
            out.append("\n    var sprcls = null;");
        }
        for (ByteCodeParser.FieldData fieldData : this.jc.getFields()) {
            if (fieldData.isStatic()) {
                if ((fieldData.access & 0x10) != 0 && fieldData.hasConstantValue() && (fieldData.getInternalSig().length() == 1 || fieldData.getInternalSig().equals("Ljava/lang/String;"))) continue;
                out.append("\n  CLS['fld_").append(fieldData.getName()).append("']").append(this.initField(fieldData));
                out.append("\n  m = c._").append(fieldData.getName()).append(" = function (v) {").append("  if (arguments.length == 1) CLS['fld_").append(fieldData.getName()).append("'] = v; return CLS['fld_").append(fieldData.getName()).append("']; };");
            } else {
                out.append("\n  m = c._").append(fieldData.getName()).append(" = function (v) {").append("  if (arguments.length == 1) this['fld_").append(className).append('_').append(fieldData.getName()).append("'] = v; return this['fld_").append(className).append('_').append(fieldData.getName()).append("']; };");
            }
            this.declaredField(out, fieldData, "c", "_" + fieldData.getName());
        }
        sc = this.jc.getMethods();
        int n = sc.length;
        for (int i = 0; i < n; ++i) {
            String mn;
            String destObject;
            Object object = sc[i];
            byte[] onlyArr = ((ByteCodeParser.MethodData)object).findAnnotationData(true);
            if (this.javaScriptOnly(out, onlyArr)) continue;
            out.append("\n    ");
            if (((ByteCodeParser.MethodData)object).isStatic()) {
                destObject = "c";
                mn = this.generateStaticMethod(out, destObject, (ByteCodeParser.MethodData)object, toInitilize);
            } else if (((ByteCodeParser.MethodData)object).isConstructor()) {
                destObject = "CLS";
                mn = this.generateInstanceMethod(out, destObject, (ByteCodeParser.MethodData)object);
            } else {
                destObject = "c";
                mn = this.generateInstanceMethod(out, destObject, (ByteCodeParser.MethodData)object);
            }
            this.declaredMethod(out, (ByteCodeParser.MethodData)object, destObject, mn);
            byte[] runAnno = ((ByteCodeParser.MethodData)object).findAnnotationData(false);
            if (runAnno != null) {
                out.append("\n    m.anno = {");
                GenerateAnno ap = new GenerateAnno(out, true, false);
                ap.parse(runAnno, this.jc);
                out.append("\n    };");
            }
            out.append("\n    m.access = " + ((ByteCodeParser.MethodData)object).getAccess()).append(";");
            out.append("\n    m.cls = CLS;");
        }
        out.append(this.numbers.generate());
        if (proto == null || proto[0] == null || !proto[1].isEmpty()) {
            out.append("\n    c.constructor = CLS;");
            out.append("\n    function ").append(className).append("fillInstOf(x) {");
            String instOfName = "$instOf_" + className;
            out.append("\n        Object.defineProperty(x, '").append(instOfName).append("', { value : true });");
            ByteCodeParser.MethodData functionalInterfaceMethod = null;
            if (this.jc.isInterface()) {
                int cnt = 0;
                for (ByteCodeParser.MethodData m : this.jc.getMethods()) {
                    if ((m.getAccess() & 0x400) == 0) {
                        if ((m.getAccess() & 8) == 0 && (m.getAccess() & 2) == 0) {
                            String mn = InternalSig.findMethodName(m, new StringBuilder());
                            out.append("\n        if (!x['").append(mn).append("']) Object.defineProperty(x, '").append(mn).append("', { value : c['").append(mn).append("']});");
                        }
                    } else {
                        String name = m.getName();
                        if (name.equals("equals") && m.getInternalSig().equals("(Ljava/lang/Object;)Z") || name.equals("hashCode") && m.getInternalSig().equals("()I") || name.equals("toString") && m.getInternalSig().equals("()Ljava/lang/String;")) continue;
                        functionalInterfaceMethod = m;
                        ++cnt;
                    }
                    if (cnt == true) continue;
                    functionalInterfaceMethod = null;
                }
            }
            for (String superInterface : this.jc.getSuperInterfaces()) {
                String intrfc = InternalSig.mangleClassName(superInterface);
                out.append("\n      vm.").append(intrfc).append("(false)['fillInstOf'](x);");
                this.requireReference(superInterface);
            }
            out.append("\n    }");
            out.append("\n    if (!c.hasOwnProperty('fillInstOf')) Object.defineProperty(c, 'fillInstOf', { value: ").append(className).append("fillInstOf });");
            out.append("\n    ").append(className).append("fillInstOf(c);");
            out.append("\n    CLS.$class = 'temp';");
            out.append("\n    CLS.$class = ");
            out.append(this.accessClass("java_lang_Class")).append("(true);");
            out.append("\n    CLS.$class.jvmName = '").append(cn).append("';");
            out.append("\n    CLS.$class.superclass = sprcls;");
            if (functionalInterfaceMethod != null) {
                char[] returnType = new char[]{'V'};
                String string = InternalSig.findMethodName(functionalInterfaceMethod, new StringBuilder(), returnType);
                out.append("\n    CLS.$class.$lambda = function(arr, fn) {");
                out.append("\n      var inst = new CLS();");
                out.append("\n      inst['").append(string).append("'] = function() {");
                out.append("\n          var ret = fn(arr, arguments);");
                switch (returnType[0]) {
                    case 'V': {
                        break;
                    }
                    case 'L': {
                        out.append("\n      return ret;");
                        break;
                    }
                    default: {
                        out.append("\n      return ret.valueOf();");
                    }
                }
                out.append("\n      };");
                out.append("\n      return inst;");
                out.append("\n    };");
            }
            out.append("\n    CLS.$class.interfaces = function() { return [");
            boolean first = true;
            for (String intrfc : this.jc.getSuperInterfaces()) {
                if (!first) {
                    out.append(",");
                }
                this.requireReference(intrfc);
                String mangledIface = InternalSig.mangleClassName(intrfc);
                out.append("\n        ");
                out.append(this.accessClass(mangledIface)).append("(false).constructor.$class");
                first = false;
            }
            out.append("\n    ]; };");
            int flags = this.jc.getAccessFlags();
            if (this.jc.hasEnclosingMethod()) {
                flags |= 0x10000;
            }
            out.append("\n    CLS.$class.access = ").append(flags + ";");
            out.append("\n    CLS.$class.cnstr = CLS;");
            byte[] byArray = this.jc.findAnnotationData(false);
            if (byArray != null) {
                out.append("\n    CLS.$class.anno = {");
                GenerateAnno ap = new GenerateAnno(out, true, false);
                ap.parse(byArray, this.jc);
                out.append("\n    };");
            }
        }
        for (String string : toInitilize.toArray()) {
            out.append("\n    ").append(string).append("();");
        }
        for (String string : this.classRefs.toArray()) {
            out.append("\n    var refs_").append(string).append(";");
        }
        this.classRefs.clear();
        if (jsResources != null) {
            for (String string : jsResources.toArray()) {
                this.requireResource(out, string);
            }
        }
        out.append("\n  }");
        out.append("\n  if (arguments.length === 0) {");
        out.append("\n    if (!(this instanceof CLS)) {");
        out.append("\n      return new CLS();");
        out.append("\n    }");
        for (ByteCodeParser.FieldData fieldData : this.jc.getFields()) {
            byte[] onlyArr = fieldData.findAnnotationData(true);
            if (this.javaScriptOnly(out, onlyArr) || fieldData.isStatic()) continue;
            out.append("\n    this['fld_").append(className).append('_').append(fieldData.getName()).append("']").append(this.initField(fieldData));
        }
        out.append("\n    return this;");
        out.append("\n  }");
        out.append("\n  return arguments[0] ? new CLS() : CLS.prototype;");
        out.append("\n};");
        out.append("\n").append(this.assignClass(className));
        this.declareClass(out, this.jc, className);
        out.append(";\n");
        return "";
    }

    private StringArray findJavaScriptResources(byte[] arr, final String cn) throws IOException {
        if (arr == null) {
            return null;
        }
        final StringArray values = StringArray.asList(new String[0]);
        String simple = "Lnet/java/html/js/JavaScriptResource;";
        String multi = "Lnet/java/html/js/JavaScriptResource$Group;";
        ByteCodeParser.AnnotationParser ap = new ByteCodeParser.AnnotationParser(false, true){

            @Override
            protected void visitAttr(String type, String attr, String at, String value) {
                if (!"value".equals(attr)) {
                    return;
                }
                if (type.equals("Lnet/java/html/js/JavaScriptResource;") || type.equals("Lnet/java/html/js/JavaScriptResource$Group;")) {
                    if (!value.startsWith("/")) {
                        int last = cn.lastIndexOf(47);
                        value = cn.substring(0, last + 1).replace('.', '/') + value;
                    }
                    values.add(value);
                }
            }
        };
        ap.parse(arr, this.jc);
        return values;
    }

    private boolean javaScriptOnly(Appendable out, byte[] anno) throws IOException {
        String[] only = ByteCodeToJavaScript.findAnnotation(anno, this.jc, "org.apidesign.bck2brwsr.core.JavaScriptOnly", "name", "value");
        if (only != null) {
            if (only[0] != null && only[1] != null) {
                out.append("\n    p.").append(only[0]).append(" = ").append(only[1]).append(";");
            }
            if (ExportedSymbols.isMarkedAsExported(anno, this.jc)) {
                out.append("\n    p['").append(only[0]).append("'] = p.").append(only[0]).append(";");
            }
            return true;
        }
        return false;
    }

    private String generateStaticMethod(Appendable out, String destObject, ByteCodeParser.MethodData m, StringArray toInitilize) throws IOException {
        String jsb = this.javaScriptBody(out, destObject, m, true);
        if (jsb != null) {
            return jsb;
        }
        String mn = InternalSig.findMethodName(m, new StringBuilder());
        boolean defineProp = this.generateMethod(out, destObject, mn, m);
        if (mn.equals("class__V")) {
            if (defineProp) {
                toInitilize.add(this.accessClassFalse(ByteCodeToJavaScript.className(this.jc)) + "['" + mn + "']");
            } else {
                toInitilize.add(this.accessClassFalse(ByteCodeToJavaScript.className(this.jc)) + "." + mn);
            }
        }
        return mn;
    }

    private String generateInstanceMethod(Appendable out, String destObject, ByteCodeParser.MethodData m) throws IOException {
        String jsb = this.javaScriptBody(out, destObject, m, false);
        if (jsb != null) {
            return jsb;
        }
        String mn = InternalSig.findMethodName(m, new StringBuilder());
        this.generateMethod(out, destObject, mn, m);
        return mn;
    }

    private boolean generateMethod(Appendable out, String destObject, String name, ByteCodeParser.MethodData m) throws IOException {
        LoopCode loop;
        boolean defineProp;
        ByteCodeParser.StackMapIterator stackMapIterator = m.createStackMapIterator();
        ByteCodeParser.TrapDataIterator trap = m.getTrapDataIterator();
        LocalsMapper lmapper = new LocalsMapper(stackMapIterator.getArguments());
        boolean bl = defineProp = "java/lang/Object".equals(this.jc.getClassName()) || "java/lang/reflect/Array".equals(this.jc.getClassName());
        if (defineProp) {
            out.append("Object.defineProperty(").append(destObject).append(", '").append(name).append("', { configurable: true, writable: true, value: m = function(");
        } else {
            out.append("m = ").append(destObject).append(".").append(name).append(" = function(");
        }
        lmapper.outputArguments(out, m.isStatic());
        out.append(") {").append("\n");
        byte[] byteCodes = m.getCode();
        if (byteCodes == null || this.jc.getMajor_version() < 50) {
            if (byteCodes == null) {
                byte[] defaultAttr = m.getDefaultAttribute();
                if (defaultAttr != null) {
                    out.append("  return ");
                    GenerateAnno ap = new GenerateAnno(out, true, false);
                    ap.parseDefault(defaultAttr, this.jc);
                    out.append(";\n");
                } else if (this.debug(out, "  throw 'no code found for ")) {
                    out.append(this.jc.getClassName()).append('.').append(m.getName()).append("';\n");
                }
            } else {
                out.append("  throw 'Class file version for " + this.jc.getClassName() + " is " + this.jc.getMajor_version() + "." + this.jc.getMinor_version() + " - recompile with -target 1.6 (at least)';\n");
            }
            if (defineProp) {
                out.append("}});");
            } else {
                out.append("};");
            }
            return defineProp;
        }
        StackMapper smapper = new StackMapper();
        if (!m.isStatic()) {
            out.append("  var ").append(" lcA0 = this;\n");
        }
        if (this.callbacks && !name.equals("class__V")) {
            lmapper.outputUndefinedCheck(out);
            loop = new JsCallbackCode(this, out, this.numbers, this.jc, m);
        } else {
            loop = new LoopCode(this, this.output, this.numbers, this.jc);
        }
        loop.loopCode(stackMapIterator, byteCodes, trap, smapper, lmapper);
        if (defineProp) {
            out.append("\n}});");
        } else {
            out.append("\n};");
        }
        return defineProp;
    }

    static int generateIf(Appendable out, StackMapper mapper, byte[] byteCodes, int i, CharSequence v2, CharSequence v1, String test, int topMostLabel) throws IOException {
        mapper.flush(out);
        int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
        out.append("if ((").append(v1).append(") ").append(test).append(" (").append(v2).append(")) ");
        ByteCodeToJavaScript.goTo(out, i, indx, topMostLabel);
        return i + 2;
    }

    int readInt4(byte[] byteCodes, int offset) {
        int d = byteCodes[offset + 0] << 24;
        int c = byteCodes[offset + 1] << 16;
        int b = byteCodes[offset + 2] << 8;
        byte a = byteCodes[offset + 3];
        return d & 0xFF000000 | c & 0xFF0000 | b & 0xFF00 | a & 0xFF;
    }

    static int readUByte(byte[] byteCodes, int offset) {
        return byteCodes[offset] & 0xFF;
    }

    static int readUShort(byte[] byteCodes, int offset) {
        return (byteCodes[offset] & 0xFF) << 8 | byteCodes[offset + 1] & 0xFF;
    }

    static int readUShortArg(byte[] byteCodes, int offsetInstruction) {
        return ByteCodeToJavaScript.readUShort(byteCodes, offsetInstruction + 1);
    }

    static int readShort(byte[] byteCodes, int offset) {
        byte signed = byteCodes[offset];
        byte b0 = signed;
        return b0 << 8 | byteCodes[offset + 1] & 0xFF;
    }

    static int readShortArg(byte[] byteCodes, int offsetInstruction) {
        return ByteCodeToJavaScript.readShort(byteCodes, offsetInstruction + 1);
    }

    void addReference(Appendable out, String cn) throws IOException {
        if (this.requireReference(cn)) {
            this.debug(out, " /* needs " + cn + " */");
        }
    }

    void outType(String d, StringBuilder out) {
        while (d.charAt(0) == '[') {
            out.append('A');
            d = d.substring(1);
        }
        if (d.charAt(0) == 'L') {
            assert (d.charAt(d.length() - 1) == ';');
            out.append(InternalSig.mangleClassName(d).substring(0, d.length() - 1));
        } else {
            out.append(d);
        }
    }

    String encodeConstant(Appendable out, int entryIndex) throws IOException {
        String[] classRef = new String[]{null};
        String s = this.jc.stringValue(entryIndex, classRef);
        if (classRef[0] != null) {
            if (classRef[0].startsWith("[")) {
                s = this.accessClass("java_lang_Class") + "(false)['forName__Ljava_lang_Class_2Ljava_lang_String_2']('" + classRef[0] + "')";
            } else {
                this.addReference(out, classRef[0]);
                s = this.accessClassFalse(InternalSig.mangleClassName(s)) + ".constructor.$class";
            }
        }
        return s;
    }

    private String javaScriptBody(Appendable out, String destObject, ByteCodeParser.MethodData m, boolean isStatic) throws IOException {
        byte[] arr = m.findAnnotationData(true);
        if (arr == null) {
            return null;
        }
        String jvmType = "Lorg/apidesign/bck2brwsr/core/JavaScriptBody;";
        String htmlType = "Lnet/java/html/js/JavaScriptBody;";
        class P
        extends ByteCodeParser.AnnotationParser {
            int cnt;
            String[] args;
            String body;
            boolean javacall;
            boolean html4j;

            public P() {
                super(false, true);
                this.args = new String[30];
            }

            @Override
            protected void visitAttr(String type, String attr, String at, String value) {
                if (type.equals("Lorg/apidesign/bck2brwsr/core/JavaScriptBody;")) {
                    if ("body".equals(attr)) {
                        this.body = value;
                    } else if ("args".equals(attr)) {
                        this.args[this.cnt++] = value;
                    } else {
                        throw new IllegalArgumentException(attr);
                    }
                }
                if (type.equals("Lnet/java/html/js/JavaScriptBody;")) {
                    this.html4j = true;
                    if ("body".equals(attr)) {
                        this.body = value;
                    } else if ("args".equals(attr)) {
                        this.args[this.cnt++] = value;
                    } else if ("javacall".equals(attr)) {
                        this.javacall = "1".equals(value);
                    } else if (!"wait4js".equals(attr)) {
                        throw new IllegalArgumentException(attr);
                    }
                }
            }
        }
        P p = new P();
        p.parse(arr, this.jc);
        if (p.body == null) {
            return null;
        }
        StringBuilder cnt = new StringBuilder();
        String mn = InternalSig.findMethodName(m, cnt);
        out.append("m = ").append(destObject).append(".").append(mn);
        out.append(" = function(");
        if (p.html4j) {
            out.append(") {").append("\n");
            if (p.html4j) {
                out.append("  var r = (function(");
            }
        }
        String space = "";
        int index = 0;
        StringBuilder toValue = new StringBuilder();
        for (int i = 0; i < cnt.length(); ++i) {
            out.append(space);
            space = ByteCodeToJavaScript.outputArg(out, p.args, index);
            if (p.html4j && space.length() > 0) {
                toValue.append("\n  ").append(p.args[index]).append(" = ").append(this.accessClass("java_lang_Class")).append("(false).toJS(").append(p.args[index]).append(");");
            }
            ++index;
        }
        out.append(") {").append("\n");
        out.append(toValue.toString());
        if (p.javacall) {
            int lastSlash = this.jc.getClassName().lastIndexOf(47);
            String pkg = this.jc.getClassName().substring(0, lastSlash);
            out.append(this.mangleCallbacks(pkg, p.body));
            this.requireReference(pkg + "/$JsCallbacks$");
        } else {
            out.append(p.body);
        }
        if (p.html4j) {
            out.append("\n}).apply(this, arguments");
            out.append(");\n  return r === undefined ? null : r;\n");
        }
        out.append("\n}\n");
        return mn;
    }

    private CharSequence mangleCallbacks(String pkgName, String body) {
        int next;
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (true) {
            if ((next = body.indexOf(".@", pos)) == -1) break;
            int ident = next;
            while (ident > 0) {
                if (Character.isJavaIdentifierPart(body.charAt(--ident))) continue;
                ++ident;
                break;
            }
            String refId = body.substring(ident, next);
            sb.append(body.substring(pos, ident));
            int sigBeg = body.indexOf(40, next);
            int sigEnd = body.indexOf(41, sigBeg);
            int colon4 = body.indexOf("::", next);
            if (sigBeg == -1 || sigEnd == -1 || colon4 == -1) {
                throw new IllegalStateException("Malformed body " + body);
            }
            String fqn = body.substring(next + 2, colon4);
            String method = body.substring(colon4 + 2, sigBeg);
            String params = body.substring(sigBeg, sigEnd + 1);
            int paramBeg = body.indexOf(40, sigEnd + 1);
            int paramEnd = ByteCodeToJavaScript.closingParenthesis(body, paramBeg);
            sb.append(this.accessClass("java_lang_Class")).append("(false).toJS(");
            sb.append("vm.").append(InternalSig.mangleClassName(pkgName)).append("_$JsCallbacks$(false)._VM().");
            sb.append(ByteCodeToJavaScript.mangleJsCallbacks(fqn, method, params, false));
            sb.append("(").append(refId);
            if (body.charAt(paramBeg + 1) != ')') {
                sb.append(",");
            }
            sb.append(body.substring(paramBeg + 1, paramEnd));
            sb.append(")");
            pos = paramEnd;
        }
        sb.append(body.substring(pos));
        body = sb.toString();
        sb = null;
        pos = 0;
        while (true) {
            if ((next = body.indexOf("@", pos)) == -1) {
                if (sb == null) {
                    return body;
                }
                sb.append(body.substring(pos));
                return sb;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(body.substring(pos, next));
            int sigBeg = body.indexOf(40, next);
            int sigEnd = body.indexOf(41, sigBeg);
            int colon4 = body.indexOf("::", next);
            if (sigBeg == -1 || sigEnd == -1 || colon4 == -1) {
                throw new IllegalStateException("Malformed body " + body);
            }
            String fqn = body.substring(next + 1, colon4);
            String method = body.substring(colon4 + 2, sigBeg);
            String params = body.substring(sigBeg, sigEnd + 1);
            int paramBeg = body.indexOf(40, sigEnd + 1);
            int paramEnd = ByteCodeToJavaScript.closingParenthesis(body, paramBeg);
            sb.append(this.accessClass("java_lang_Class")).append("(false).toJS(");
            sb.append("vm.").append(InternalSig.mangleClassName(pkgName)).append("_$JsCallbacks$(false)._VM().");
            sb.append(ByteCodeToJavaScript.mangleJsCallbacks(fqn, method, params, true));
            sb.append("(");
            sb.append(body.substring(paramBeg + 1, paramEnd));
            sb.append(")");
            pos = paramEnd;
        }
    }

    static String mangleJsCallbacks(String fqn, String method, String params, boolean isStatic) {
        if (params.startsWith("(")) {
            params = params.substring(1);
        }
        if (params.endsWith(")")) {
            params = params.substring(0, params.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        String fqnu = fqn.replace('.', '_');
        String rfqn = InternalSig.mangleClassName(fqnu);
        String rm = InternalSig.mangleMethodName(method);
        StringBuilder pb = new StringBuilder();
        int len = params.length();
        int indx = 0;
        while (indx < len) {
            char ch = params.charAt(indx);
            if (ch == '[' || ch == 'L') {
                String real;
                int column = params.indexOf(59, indx) + 1;
                if (column > indx && "Ljava/lang/String;".equals(real = params.substring(indx, column))) {
                    pb.append("Ljava/lang/String;");
                    indx = column;
                    continue;
                }
                pb.append("Ljava/lang/Object;");
                indx = column;
                continue;
            }
            pb.append(ch);
            ++indx;
        }
        String srp = InternalSig.mangleSig(pb.toString());
        String rp = InternalSig.mangleSig(params);
        String mrp = InternalSig.mangleMethodName(rp);
        sb.append(rfqn).append("$").append(rm).append('$').append(mrp).append("__Ljava_lang_Object_2");
        if (!isStatic) {
            sb.append('L').append(fqnu).append("_2");
        }
        sb.append(srp);
        return sb.toString();
    }

    private static String className(ByteCodeParser.ClassData jc) {
        return InternalSig.mangleClassName(jc.getClassName());
    }

    private static String[] findAnnotation(byte[] arr, ByteCodeParser.ClassData cd, String className, final String ... attrNames) throws IOException {
        if (arr == null) {
            return null;
        }
        final String[] values = new String[attrNames.length];
        final boolean[] found = new boolean[]{false};
        final String jvmType = "L" + className.replace('.', '/') + ";";
        ByteCodeParser.AnnotationParser ap = new ByteCodeParser.AnnotationParser(false, true){

            @Override
            protected void visitAttr(String type, String attr, String at, String value) {
                if (type.equals(jvmType)) {
                    found[0] = true;
                    for (int i = 0; i < attrNames.length; ++i) {
                        if (!attrNames[i].equals(attr)) continue;
                        values[i] = value;
                    }
                }
            }
        };
        ap.parse(arr, cd);
        return found[0] ? values : null;
    }

    private CharSequence initField(ByteCodeParser.FieldData v) {
        String is = v.getInternalSig();
        if (is.length() == 1) {
            switch (is.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return " = 0;";
                }
                case 'D': 
                case 'F': {
                    return " = 0.0;";
                }
            }
            throw new IllegalStateException(is);
        }
        return " = null;";
    }

    private static String outputArg(Appendable out, String[] args, int indx) throws IOException {
        String name = args[indx];
        if (name == null) {
            return "";
        }
        if (name.contains(",")) {
            throw new IOException("Wrong parameter with ',': " + name);
        }
        out.append(name);
        return ",";
    }

    static final void emit(Appendable out, StackMapper sm, String format, CharSequence ... params) throws IOException {
        sm.flush(out);
        ByteCodeToJavaScript.emitImpl(out, format, params);
    }

    static void emitImpl(Appendable out, String format, CharSequence ... params) throws IOException {
        int length = format.length();
        int processed = 0;
        int paramOffset = format.indexOf(64);
        while (paramOffset != -1 && paramOffset < length - 1) {
            char paramChar = format.charAt(paramOffset + 1);
            if (paramChar >= '1' && paramChar <= '9') {
                int paramIndex = paramChar - 48 - 1;
                out.append(format, processed, paramOffset);
                out.append(params[paramIndex]);
                processed = ++paramOffset + 1;
            }
            paramOffset = format.indexOf(64, paramOffset + 1);
        }
        out.append(format, processed, length);
    }

    void generateCatch(Appendable out, ByteCodeParser.TrapData[] traps, int current, int topMostLabel) throws IOException {
        out.append("} catch (e) {\n");
        int finallyPC = -1;
        for (ByteCodeParser.TrapData e : traps) {
            if (e == null) break;
            if (e.catch_cpx != 0) {
                String classInternalName = this.jc.getClassName(e.catch_cpx);
                this.addReference(out, classInternalName);
                out.append("e = vm.java_lang_Class(false).bck2BrwsrThrwrbl(e);");
                out.append("if (e['$instOf_" + InternalSig.mangleClassName(classInternalName) + "']) {");
                out.append("var stA0 = e;");
                ByteCodeToJavaScript.goTo(out, current, e.handler_pc, topMostLabel);
                out.append("}\n");
                continue;
            }
            finallyPC = e.handler_pc;
        }
        if (finallyPC == -1) {
            out.append("throw e;");
        } else {
            out.append("var stA0 = e;");
            ByteCodeToJavaScript.goTo(out, current, finallyPC, topMostLabel);
        }
        out.append("\n}");
    }

    static void goTo(Appendable out, int current, int to, int canBack) throws IOException {
        if (to < current) {
            if (canBack < to) {
                out.append("{ gt = 0; continue X_" + to + "; }");
            } else {
                out.append("{ gt = " + to + "; continue X_0; }");
            }
        } else {
            out.append("{ gt = " + to + "; break IF; }");
        }
    }

    static void emitIf(Appendable out, StackMapper sm, String pattern, CharSequence param, int current, int to, int canBack) throws IOException {
        sm.flush(out);
        ByteCodeToJavaScript.emitImpl(out, pattern, param);
        ByteCodeToJavaScript.goTo(out, current, to, canBack);
    }

    void generateNewArray(Appendable out, int atype, StackMapper smapper) throws IOException, IllegalStateException {
        String jvmType;
        switch (atype) {
            case 4: {
                jvmType = "[Z";
                break;
            }
            case 5: {
                jvmType = "[C";
                break;
            }
            case 6: {
                jvmType = "[F";
                break;
            }
            case 7: {
                jvmType = "[D";
                break;
            }
            case 8: {
                jvmType = "[B";
                break;
            }
            case 9: {
                jvmType = "[S";
                break;
            }
            case 10: {
                jvmType = "[I";
                break;
            }
            case 11: {
                jvmType = "[J";
                break;
            }
            default: {
                throw new IllegalStateException("Array type: " + atype);
            }
        }
        ByteCodeToJavaScript.emit(out, smapper, "var @2 = Array.prototype['newArray__Ljava_lang_Object_2ZLjava_lang_String_2Ljava_lang_Object_2I'](true, '@3', null, @1);", smapper.popI(), smapper.pushA(), jvmType);
    }

    void generateANewArray(Appendable out, int type, StackMapper smapper) throws IOException {
        String typeName = this.jc.getClassName(type);
        String ref = "null";
        if (typeName.startsWith("[")) {
            typeName = "'[" + typeName + "'";
        } else {
            ref = "vm." + InternalSig.mangleClassName(typeName);
            typeName = "'[L" + typeName + ";'";
        }
        ByteCodeToJavaScript.emit(out, smapper, "var @2 = Array.prototype['newArray__Ljava_lang_Object_2ZLjava_lang_String_2Ljava_lang_Object_2I'](false, @3, @4, @1);", smapper.popI(), smapper.pushA(), typeName, ref);
    }

    int generateMultiANewArray(Appendable out, int type, byte[] byteCodes, int i, StackMapper smapper) throws IOException {
        String typeName = this.jc.getClassName(type);
        int dim = ByteCodeToJavaScript.readUByte(byteCodes, ++i);
        StringBuilder dims = new StringBuilder();
        dims.append('[');
        for (int d = 0; d < dim; ++d) {
            if (d != 0) {
                dims.insert(1, ",");
            }
            dims.insert(1, smapper.popI());
        }
        dims.append(']');
        String fn = "null";
        if (typeName.charAt(dim) == 'L') {
            fn = "vm." + InternalSig.mangleClassName(typeName.substring(dim + 1, typeName.length() - 1));
        }
        ByteCodeToJavaScript.emit(out, smapper, "var @2 = Array.prototype['multiNewArray__Ljava_lang_Object_2Ljava_lang_String_2_3ILjava_lang_Object_2']('@3', @1, @4);", dims.toString(), smapper.pushA(), typeName, fn);
        return i;
    }

    int generateTableSwitch(Appendable out, int i, byte[] byteCodes, StackMapper smapper, int topMostLabel) throws IOException {
        int table = i / 4 * 4 + 4;
        int dflt = i + this.readInt4(byteCodes, table);
        int high = this.readInt4(byteCodes, table += 4);
        table += 4;
        CharSequence swVar = smapper.popValue();
        smapper.flush(out);
        out.append("switch (").append(swVar).append(") {\n");
        for (int low = this.readInt4(byteCodes, table += 4); low <= high; ++low) {
            int offset = i + this.readInt4(byteCodes, table);
            table += 4;
            out.append("  case " + low).append(":");
            ByteCodeToJavaScript.goTo(out, i, offset, topMostLabel);
            out.append('\n');
        }
        out.append("  default: ");
        ByteCodeToJavaScript.goTo(out, i, dflt, topMostLabel);
        out.append("\n}");
        i = table - 1;
        return i;
    }

    int generateLookupSwitch(Appendable out, int i, byte[] byteCodes, StackMapper smapper, int topMostLabel) throws IOException {
        int table = i / 4 * 4 + 4;
        int dflt = i + this.readInt4(byteCodes, table);
        int n = this.readInt4(byteCodes, table += 4);
        table += 4;
        CharSequence swVar = smapper.popValue();
        smapper.flush(out);
        out.append("switch (").append(swVar).append(") {\n");
        while (n-- > 0) {
            int cnstnt = this.readInt4(byteCodes, table);
            int offset = i + this.readInt4(byteCodes, table += 4);
            table += 4;
            out.append("  case " + cnstnt).append(": ");
            ByteCodeToJavaScript.goTo(out, i, offset, topMostLabel);
            out.append('\n');
        }
        out.append("  default: ");
        ByteCodeToJavaScript.goTo(out, i, dflt, topMostLabel);
        out.append("\n}");
        i = table - 1;
        return i;
    }

    void generateInstanceOf(Appendable out, int indx, StackMapper smapper) throws IOException {
        String type = this.jc.getClassName(indx);
        if (!type.startsWith("[")) {
            ByteCodeToJavaScript.emit(out, smapper, "var @2 = @1 != null && @1['$instOf_@3'] ? 1 : 0;", smapper.popA(), smapper.pushI(), InternalSig.mangleClassName(type));
        } else {
            int cnt = 0;
            while (type.charAt(cnt) == '[') {
                ++cnt;
            }
            if (type.charAt(cnt) == 'L') {
                String component = type.substring(cnt + 1, type.length() - 1);
                this.requireReference(component);
                type = "vm." + InternalSig.mangleClassName(component);
                ByteCodeToJavaScript.emit(out, smapper, "var @2 = Array.prototype['isInstance__ZLjava_lang_Object_2ILjava_lang_Object_2'](@1, @4, @3);", smapper.popA(), smapper.pushI(), type, "" + cnt);
            } else {
                ByteCodeToJavaScript.emit(out, smapper, "var @2 = Array.prototype['isInstance__ZLjava_lang_Object_2Ljava_lang_String_2'](@1, '@3');", smapper.popA(), smapper.pushI(), type);
            }
        }
    }

    void generateCheckcast(Appendable out, int indx, StackMapper smapper) throws IOException {
        String type = this.jc.getClassName(indx);
        CharSequence varName = smapper.getT(0, 4, false);
        this.generateCheckcast(out, type, varName);
    }

    void generateCheckcast(Appendable out, String type, CharSequence varName) throws IOException {
        if ("java/lang/Object".equals(type)) {
            return;
        }
        if (!type.startsWith("[")) {
            ByteCodeToJavaScript.emitImpl(out, "if (@1 !== null && !@1['$instOf_@2']) vm.java_lang_Class(false).castEx(@1, '@3');", varName, InternalSig.mangleClassName(type), type.replace('/', '.'));
        } else {
            int cnt = 0;
            while (type.charAt(cnt) == '[') {
                ++cnt;
            }
            if (type.charAt(cnt) == 'L') {
                String component = type.substring(cnt + 1, type.length() - 1);
                this.requireReference(component);
                type = "vm." + InternalSig.mangleClassName(component);
                ByteCodeToJavaScript.emitImpl(out, "if (@1 !== null && !Array.prototype['isInstance__ZLjava_lang_Object_2ILjava_lang_Object_2'](@1, @3, @2)) vm.java_lang_Class(false).castEx(@1, '');", varName, type, "" + cnt);
            } else {
                ByteCodeToJavaScript.emitImpl(out, "if (@1 !== null && !Array.prototype['isInstance__ZLjava_lang_Object_2Ljava_lang_String_2'](@1, '@2')) vm.java_lang_Class(false).castEx(@1, '');", varName, type);
            }
        }
    }

    void generateByteCodeComment(Appendable out, int prev, int i, byte[] byteCodes) throws IOException {
        for (int j = prev; j <= i; ++j) {
            out.append(" ");
            int cc = ByteCodeToJavaScript.readUByte(byteCodes, j);
            out.append(Integer.toString(cc));
        }
    }

    @JavaScriptBody(args={"msg"}, body="")
    static void println(String msg) {
        System.err.println(msg);
    }

    private static int closingParenthesis(String body, int at) {
        int cnt = 0;
        do {
            switch (body.charAt(at++)) {
                case '(': {
                    ++cnt;
                    break;
                }
                case ')': {
                    --cnt;
                }
            }
        } while (cnt != 0);
        return at;
    }

    IndyHandler[] getIndyHandlers() {
        return this.indyHandlers;
    }

    private class GenerateAnno
    extends ByteCodeParser.AnnotationParser {
        private final Appendable out;
        int[] cnt;
        int depth;

        public GenerateAnno(Appendable out, boolean textual, boolean iterateArray) {
            super(textual, iterateArray);
            this.cnt = new int[32];
            this.out = out;
        }

        @Override
        protected void visitAnnotationStart(String attrType, boolean top) throws IOException {
            String slashType = attrType.substring(1, attrType.length() - 1);
            ByteCodeToJavaScript.this.requireReference(slashType);
            int n = this.depth;
            int n2 = this.cnt[n];
            this.cnt[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(",");
            }
            if (top) {
                this.out.append('\"').append(attrType).append("\" : ");
            }
            this.out.append("{\n");
            this.cnt[++this.depth] = 0;
        }

        @Override
        protected void visitAnnotationEnd(String type, boolean top) throws IOException {
            this.out.append("\n}\n");
            --this.depth;
        }

        @Override
        protected void visitValueStart(String attrName, char type) throws IOException {
            int n = this.depth;
            int n2 = this.cnt[n];
            this.cnt[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(",\n");
            }
            this.cnt[++this.depth] = 0;
            if (attrName != null) {
                this.out.append('\"').append(attrName).append("\" : ");
            }
            if (type == '[') {
                this.out.append("[");
            }
        }

        @Override
        protected void visitValueEnd(String attrName, char type) throws IOException {
            if (type == '[') {
                this.out.append("]");
            }
            --this.depth;
        }

        @Override
        protected void visitAttr(String type, String attr, String attrType, String value) throws IOException {
            if (attr == null && value == null) {
                return;
            }
            this.out.append(value);
        }

        @Override
        protected void visitEnumAttr(String type, String attr, String attrType, String value) throws IOException {
            String slashType = attrType.substring(1, attrType.length() - 1);
            ByteCodeToJavaScript.this.requireReference(slashType);
            String cn = InternalSig.mangleClassName(slashType);
            this.out.append(ByteCodeToJavaScript.this.accessClassFalse(cn)).append("['valueOf__L").append(cn).append("_2Ljava_lang_String_2']('").append(value).append("')");
        }

        @Override
        protected void visitClassAttr(String annoType, String attr, String className) throws IOException {
            if (className.startsWith("L")) {
                String slashType = className.substring(1, className.length() - 1);
                ByteCodeToJavaScript.this.requireReference(slashType);
                String cn = InternalSig.mangleClassName(slashType);
                this.out.append(ByteCodeToJavaScript.this.accessClassFalse(cn)).append(".constructor.$class");
            } else {
                String af;
                String ac;
                String primitiveType = null;
                switch (className.charAt(0)) {
                    case 'J': {
                        primitiveType = "java_lang_Long";
                        break;
                    }
                    case 'I': {
                        primitiveType = "java_lang_Integer";
                        break;
                    }
                    case 'S': {
                        primitiveType = "java_lang_Short";
                        break;
                    }
                    case 'B': {
                        primitiveType = "java_lang_Byte";
                        break;
                    }
                    case 'F': {
                        primitiveType = "java_lang_Float";
                        break;
                    }
                    case 'D': {
                        primitiveType = "java_lang_Double";
                        break;
                    }
                    case 'C': {
                        primitiveType = "java_lang_Character";
                        break;
                    }
                    case 'Z': {
                        primitiveType = "java_lang_Boolean";
                        break;
                    }
                    case '[': {
                        ac = ByteCodeToJavaScript.this.accessClassFalse("java_lang_Class");
                        af = ByteCodeToJavaScript.this.accessStaticMethod(ac, "forName__Ljava_lang_Class_2Ljava_lang_String_2", new String[]{"java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"});
                        this.out.append(af).append("(\"").append(className).append("\")");
                        break;
                    }
                    default: {
                        this.out.append(ByteCodeToJavaScript.this.accessClassFalse("java_lang_Object")).append(".constructor.$class");
                    }
                }
                if (primitiveType != null) {
                    ac = ByteCodeToJavaScript.this.accessClassFalse(primitiveType);
                    af = ByteCodeToJavaScript.this.accessField(ac, null, new String[]{null, "TYPE"});
                    this.out.append(af).append("()");
                }
            }
        }
    }
}

