/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apidesign.bck2brwsr.core.ExtraJavaScript;
import org.apidesign.vm4brwsr.Bck2Brwsr;
import org.apidesign.vm4brwsr.ByteCodeParser;

@ExtraJavaScript(processByteCode=false, resource="")
final class ClassDataCache {
    private static final Object MISSING_CLASS = new Object();
    private final Bck2Brwsr.Resources resources;
    private final Map<String, Object> classDataMap;

    ClassDataCache(Bck2Brwsr.Resources resources) {
        this.resources = resources;
        this.classDataMap = new HashMap<String, Object>();
    }

    ByteCodeParser.ClassData getClassData(String className) throws IOException {
        Object cacheEntry;
        if (className.startsWith("[")) {
            className = "java/lang/Object";
        }
        if ((cacheEntry = this.classDataMap.get(className)) == null) {
            InputStream is = ClassDataCache.loadClass(this.resources, className);
            try {
                cacheEntry = is != null ? new ByteCodeParser.ClassData(is) : MISSING_CLASS;
            }
            catch (IOException ex) {
                throw new IOException("Cannot process " + className, ex);
            }
            this.classDataMap.put(className, cacheEntry);
        }
        return cacheEntry != MISSING_CLASS ? (ByteCodeParser.ClassData)cacheEntry : null;
    }

    ByteCodeParser.MethodData findMethod(String startingClass, String name, String signature) throws IOException {
        return this.findMethod(this.getClassData(startingClass), name, signature);
    }

    ByteCodeParser.FieldData findField(String startingClass, String name, String signature) throws IOException {
        return this.findField(this.getClassData(startingClass), name, signature);
    }

    ByteCodeParser.MethodData findMethod(ByteCodeParser.ClassData startingClass, String name, String signature) throws IOException {
        FindFirstTraversalCallback<ByteCodeParser.MethodData> ffTraversalCallback = new FindFirstTraversalCallback<ByteCodeParser.MethodData>();
        this.findMethods(startingClass, name, signature, ffTraversalCallback);
        return ffTraversalCallback.getFirst();
    }

    ByteCodeParser.FieldData findField(ByteCodeParser.ClassData startingClass, String name, String signature) throws IOException {
        FindFirstTraversalCallback<ByteCodeParser.FieldData> ffTraversalCallback = new FindFirstTraversalCallback<ByteCodeParser.FieldData>();
        this.findFields(startingClass, name, signature, ffTraversalCallback);
        return ffTraversalCallback.getFirst();
    }

    void findMethods(ByteCodeParser.ClassData startingClass, String methodName, String methodSignature, TraversalCallback<ByteCodeParser.MethodData> mdTraversalCallback) throws IOException {
        this.traverseHierarchy(startingClass, new FindMethodsTraversalCallback(methodName, methodSignature, mdTraversalCallback));
    }

    void findFields(ByteCodeParser.ClassData startingClass, String fieldName, String fieldSignature, TraversalCallback<ByteCodeParser.FieldData> fdTraversalCallback) throws IOException {
        this.traverseHierarchy(startingClass, new FindFieldsTraversalCallback(fieldName, fieldSignature, fdTraversalCallback));
    }

    private boolean traverseHierarchy(ByteCodeParser.ClassData currentClass, TraversalCallback<ByteCodeParser.ClassData> cdTraversalCallback) throws IOException {
        while (currentClass != null) {
            if (!cdTraversalCallback.traverse(currentClass)) {
                return false;
            }
            for (String superIfaceName : currentClass.getSuperInterfaces()) {
                if (this.traverseHierarchy(this.getClassData(superIfaceName), cdTraversalCallback)) continue;
                return false;
            }
            String superClassName = currentClass.getSuperClassName();
            if (superClassName == null) break;
            currentClass = this.getClassData(superClassName);
        }
        return true;
    }

    private static InputStream loadClass(Bck2Brwsr.Resources l, String name) throws IOException {
        return l.get(name + ".class");
    }

    private final class FindFirstTraversalCallback<T>
    implements TraversalCallback<T> {
        private T firstObject;

        private FindFirstTraversalCallback() {
        }

        @Override
        public boolean traverse(T object) {
            this.firstObject = object;
            return false;
        }

        public T getFirst() {
            return this.firstObject;
        }
    }

    static interface TraversalCallback<T> {
        public boolean traverse(T var1);
    }

    private final class FindMethodsTraversalCallback
    implements TraversalCallback<ByteCodeParser.ClassData> {
        private final String methodName;
        private final String methodSignature;
        private final TraversalCallback<ByteCodeParser.MethodData> mdTraversalCallback;

        public FindMethodsTraversalCallback(String methodName, String methodSignature, TraversalCallback<ByteCodeParser.MethodData> mdTraversalCallback) {
            this.methodName = methodName;
            this.methodSignature = methodSignature;
            this.mdTraversalCallback = mdTraversalCallback;
        }

        @Override
        public boolean traverse(ByteCodeParser.ClassData classData) {
            ByteCodeParser.MethodData methodData = classData.findMethod(this.methodName, this.methodSignature);
            return methodData != null ? this.mdTraversalCallback.traverse(methodData) : true;
        }
    }

    private final class FindFieldsTraversalCallback
    implements TraversalCallback<ByteCodeParser.ClassData> {
        private final String fieldName;
        private final String fieldSignature;
        private final TraversalCallback<ByteCodeParser.FieldData> fdTraversalCallback;

        public FindFieldsTraversalCallback(String fieldName, String fieldSignature, TraversalCallback<ByteCodeParser.FieldData> fdTraversalCallback) {
            this.fieldName = fieldName;
            this.fieldSignature = fieldSignature;
            this.fdTraversalCallback = fdTraversalCallback;
        }

        @Override
        public boolean traverse(ByteCodeParser.ClassData classData) {
            ByteCodeParser.FieldData fieldData = classData.findField(this.fieldName, this.fieldSignature);
            return fieldData != null ? this.fdTraversalCallback.traverse(fieldData) : true;
        }
    }
}

