/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.StringArray;

final class InternalSig {
    private final String jniName;
    private final String mangledType;
    private final String[] jvmParams;

    private InternalSig(String jniName, String mangledType, String[] parameters) {
        this.jniName = jniName;
        this.mangledType = mangledType;
        this.jvmParams = parameters;
    }

    static InternalSig find(ByteCodeParser.MethodData m) {
        return InternalSig.find(m.getName(), m.getInternalSig());
    }

    static InternalSig find(String methodName, String internalSig) {
        StringBuilder name = new StringBuilder();
        if (methodName != null) {
            if ("<init>".equals(methodName)) {
                name.append("cons");
            } else if ("<clinit>".equals(methodName)) {
                name.append("class");
            } else {
                name.append(InternalSig.mangleMethodName(methodName));
            }
            name.append("__");
        }
        StringArray params = new StringArray();
        String[] retType = new String[]{null};
        InternalSig.countArgs(internalSig, retType, name, null, params);
        return new InternalSig(name.toString(), "" + retType[0], params.toArray());
    }

    static String findMethodName(ByteCodeParser.MethodData m, StringBuilder cnt) {
        return InternalSig.findMethodName(m.getName(), m.getInternalSig(), cnt, null);
    }

    static String findMethodName(ByteCodeParser.MethodData m, StringBuilder cnt, char[] retType) {
        return InternalSig.findMethodName(new String[]{null, m.getName(), m.getInternalSig()}, cnt, retType);
    }

    static String findMethodName(String[] mi, StringBuilder cnt, char[] retType) {
        return InternalSig.findMethodName(mi[1], mi[2], cnt, retType);
    }

    private static String findMethodName(String methodName, String internalSig, StringBuilder cnt, char[] retType) {
        InternalSig sig = InternalSig.find(methodName, internalSig);
        if (cnt != null) {
            for (int i = 0; i < sig.jvmParams.length; ++i) {
                if ("J".equals(sig.jvmParams[i]) || "D".equals(sig.jvmParams[i])) {
                    cnt.append("1");
                    continue;
                }
                cnt.append('0');
            }
        }
        if (retType != null) {
            retType[0] = sig.mangledType.charAt(0);
        }
        return sig.jniName;
    }

    static String mangleMethodName(String name) {
        return name == null ? null : InternalSig.mangle(name, 0, name.length(), false);
    }

    static String mangleJsCallbacks(String fqn, String method, String params, boolean isStatic) {
        if (params.startsWith("(")) {
            params = params.substring(1);
        }
        if (params.endsWith(")")) {
            params = params.substring(0, params.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        String fqnu = fqn.replace('.', '_');
        String rfqn = InternalSig.mangleClassName(fqnu);
        String rm = InternalSig.mangleMethodName(method);
        StringBuilder pb = new StringBuilder();
        int len = params.length();
        int indx = 0;
        while (indx < len) {
            char ch = params.charAt(indx);
            if (ch == '[' || ch == 'L') {
                String real;
                int column = params.indexOf(59, indx) + 1;
                if (column > indx && "Ljava/lang/String;".equals(real = params.substring(indx, column))) {
                    pb.append("Ljava/lang/String;");
                    indx = column;
                    continue;
                }
                pb.append("Ljava/lang/Object;");
                indx = column;
                continue;
            }
            pb.append(ch);
            ++indx;
        }
        String srp = InternalSig.mangleSig(pb.toString());
        String rp = InternalSig.mangleSig(params);
        String mrp = InternalSig.mangleMethodName(rp);
        sb.append(rfqn).append("$").append(rm).append('$').append(mrp).append("__Ljava_lang_Object_2");
        if (!isStatic) {
            sb.append('L').append(fqnu).append("_2");
        }
        sb.append(srp);
        return sb.toString();
    }

    static String mangleSig(String sig) {
        return InternalSig.mangle(sig, 0, sig.length(), false);
    }

    static String mangleSig(String txt, int first, int last) {
        StringBuilder sb = new StringBuilder((last - first) * 2);
        block6: for (int i = first; i < last; ++i) {
            char ch = txt.charAt(i);
            switch (ch) {
                case '/': {
                    sb.append('_');
                    continue block6;
                }
                case '_': {
                    sb.append("_1");
                    continue block6;
                }
                case ';': {
                    sb.append("_2");
                    continue block6;
                }
                case '[': {
                    sb.append("_3");
                    continue block6;
                }
                default: {
                    if (Character.isJavaIdentifierPart(ch)) {
                        sb.append(ch);
                        continue block6;
                    }
                    sb.append("_0");
                    String hex = Integer.toHexString(ch).toLowerCase();
                    for (int m = hex.length(); m < 4; ++m) {
                        sb.append("0");
                    }
                    sb.append(hex);
                }
            }
        }
        return sb.toString();
    }

    static String mangleClassName(String name) {
        return InternalSig.mangleSig(name);
    }

    static String mangle(String originalName, int from, int till, boolean replaceDot) {
        int bufferSize = Math.max((till - from) * 2, 32);
        char[] buf = new char[bufferSize];
        int at = 0;
        block7: for (int i = from; i < till; ++i) {
            if (at > buf.length - 10) {
                buf = InternalSig.copyDouble(buf);
            }
            char ch = originalName.charAt(i);
            switch (ch) {
                case '/': {
                    buf[at++] = 95;
                    continue block7;
                }
                case '_': {
                    buf[at++] = 95;
                    buf[at++] = 49;
                    continue block7;
                }
                case ';': {
                    buf[at++] = 95;
                    buf[at++] = 50;
                    continue block7;
                }
                case '[': {
                    buf[at++] = 95;
                    buf[at++] = 51;
                    continue block7;
                }
                case '.': {
                    if (replaceDot) {
                        buf[at++] = 95;
                        continue block7;
                    }
                }
                default: {
                    boolean valid;
                    boolean bl = valid = i == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch);
                    if (valid) {
                        buf[at++] = ch;
                        continue block7;
                    }
                    buf[at++] = 95;
                    buf[at++] = 48;
                    String hex = Integer.toHexString(ch).toLowerCase();
                    for (int m = hex.length(); m < 4; ++m) {
                        buf[at++] = 48;
                    }
                    for (int r = 0; r < hex.length(); ++r) {
                        buf[at++] = hex.charAt(r);
                    }
                }
            }
        }
        return new String(buf, 0, at);
    }

    private static void countArgs(String descriptor, String[] returnType, StringBuilder sig, StringBuilder cnt, StringArray arr) {
        int i = 0;
        Boolean count = null;
        String array = null;
        int firstPos = sig.length();
        block8: while (i < descriptor.length()) {
            char ch = descriptor.charAt(i++);
            switch (ch) {
                case '(': {
                    count = true;
                    continue block8;
                }
                case ')': {
                    count = false;
                    continue block8;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    if (count.booleanValue()) {
                        if (array != null) {
                            sig.append("_3");
                            if (cnt != null) {
                                cnt.append("0");
                            }
                            if (arr != null) {
                                arr.add(array + ch);
                            }
                        } else {
                            if (cnt != null) {
                                if (ch == 'J' || ch == 'D') {
                                    cnt.append('1');
                                } else {
                                    cnt.append('0');
                                }
                            }
                            if (arr != null) {
                                arr.add("" + ch);
                            }
                        }
                        sig.append(ch);
                    } else {
                        sig.insert(firstPos, ch);
                        if (array != null) {
                            returnType[0] = array + ch;
                            sig.insert(firstPos, "_3");
                        } else {
                            returnType[0] = "" + ch;
                        }
                    }
                    array = null;
                    continue block8;
                }
                case 'V': {
                    assert (!count.booleanValue());
                    returnType[0] = "V";
                    sig.insert(firstPos, 'V');
                    continue block8;
                }
                case 'L': {
                    int next = descriptor.indexOf(59, i);
                    String rawSig = descriptor.substring(i - 1, next + 1);
                    String realSig = InternalSig.mangleSig(rawSig);
                    if (count.booleanValue()) {
                        if (array != null) {
                            sig.append("_3");
                            if (arr != null) {
                                arr.add(array + rawSig);
                            }
                        } else if (arr != null) {
                            arr.add(rawSig);
                        }
                        sig.append(realSig);
                        if (cnt != null) {
                            cnt.append('0');
                        }
                    } else {
                        sig.insert(firstPos, realSig);
                        if (array != null) {
                            sig.insert(firstPos, "_3");
                            returnType[0] = array + realSig;
                        } else {
                            returnType[0] = realSig;
                        }
                    }
                    i = next + 1;
                    array = null;
                    continue block8;
                }
                case '[': {
                    if (array == null) {
                        array = "[";
                        continue block8;
                    }
                    array = array + "[";
                    continue block8;
                }
            }
            throw new IllegalStateException("Invalid char: " + ch);
        }
    }

    private static char[] copyDouble(char[] buf) {
        char[] copy = new char[buf.length * 2];
        for (int i = 0; i < buf.length; ++i) {
            copy[i] = buf[i];
        }
        return copy;
    }

    int getParameterCount() {
        return this.jvmParams.length;
    }

    String getMangledType() {
        return this.mangledType;
    }

    String getJniName() {
        return this.jniName;
    }

    String getJvmParameterType(int i) {
        return this.jvmParams[i];
    }
}

